/*
 * Decompiled with CFR 0.152.
 */
package medicine;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import medicine.Entity;

public class RepeatingEntityCrawler
extends Thread {
    Entity start;
    ActionListener actionlistener;
    Vector searched = new Vector();
    Vector traversedCount = new Vector();
    int serial = 0;
    boolean searching = false;
    int branchMask = 15;
    int currentDistance = 0;
    int MAX_DISTANCE = Integer.MAX_VALUE;
    int maxTraverseCount = 1;

    public RepeatingEntityCrawler() {
    }

    public RepeatingEntityCrawler(Entity startNode, ActionListener al) {
        this.start = startNode;
        this.actionlistener = al;
    }

    public int getBranchMask() {
        return this.branchMask;
    }

    public void setBranchMask(int b) {
        this.branchMask = b;
    }

    public void run() {
        this.searching = true;
        this.searchTree(this.start, 0);
        this.searching = false;
        this.actionlistener.actionPerformed(new ActionEvent(this, -1, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchTree(Entity node, int directionFrom) {
        Vector vector = this.searched;
        synchronized (vector) {
            int i = this.findNode(node, this.searched);
            int count = (Integer)this.traversedCount.get(i);
            this.traversedCount.set(i, new Integer(count++));
            if (count > this.maxTraverseCount) {
                return;
            }
            this.actionlistener.actionPerformed(new ActionEvent(node, this.serial++, node.name, this.currentDistance));
        }
        if (this.currentDistance > this.MAX_DISTANCE) {
            return;
        }
        ++this.currentDistance;
        if (directionFrom != 4 && (this.branchMask & 4) > 0) {
            this.trySearchAll(node.causes, 8);
        }
        if (directionFrom != 8 && (this.branchMask & 8) > 0) {
            this.trySearchAll(node.effects, 4);
        }
        if (directionFrom != 2 && (this.branchMask & 2) > 0) {
            this.trySearchAll(node.children, 1);
        }
        if (directionFrom != 1 && (this.branchMask & 1) > 0) {
            this.trySearchAll(node.parents, 2);
        }
        --this.currentDistance;
    }

    public void trySearchAll(Vector v, int directionFrom) {
        int i = 0;
        while (i < v.size()) {
            Object o = v.get(i);
            this.searchTree((Entity)o, directionFrom);
            ++i;
        }
    }

    private int findNode(Entity node, Vector vector) {
        int i = vector.indexOf(node);
        if (i < 0) {
            vector.add(node);
            this.traversedCount.add(new Integer(0));
            i = vector.indexOf(node);
        }
        return i;
    }

    public int getMaxTraverseCount() {
        return this.maxTraverseCount;
    }

    public void setMaxTraverseCount(int maxTraverseCount) {
        this.maxTraverseCount = maxTraverseCount;
    }
}

