/*
 * Decompiled with CFR 0.152.
 */
package medicine;

import java.awt.Point;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import medicine.gui.MainFrame;

public class MainApplication {
    public static MainFrame frame;

    public static void main(String[] params) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        frame = new MainFrame();
        if (params.length > 0) {
            final String file = params[0];
            Thread nt = new Thread(new Runnable(){

                public void run() {
                    try {
                        File f = new File(file);
                        FileInputStream stream = new FileInputStream(f);
                        if (file.endsWith("txt")) {
                            frame.readTextFromStream(stream, file);
                        } else if (file.endsWith("zip")) {
                            frame.readTextFromZip(stream, file);
                        } else {
                            frame.readDatabaseFrom(stream, file);
                        }
                        MainApplication.frame.filer.setSelectedFile(f);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(null, ex.getMessage(), "Open error: " + file, 0);
                    }
                    catch (ClassNotFoundException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(null, ex.getMessage(), "Incorrect format: " + file, 0);
                    }
                }
            });
            nt.start();
        }
        frame.show();
    }

    public static Point getCentre() {
        if (frame == null) {
            return null;
        }
        return new Point(MainApplication.frame.getLocation().x + MainApplication.frame.getSize().width / 2, MainApplication.frame.getLocation().y + MainApplication.frame.getSize().height / 2);
    }

    public static void centreWindow(Window w) {
        if (frame == null) {
            return;
        }
        Point p = MainApplication.getCentre();
        p.x -= w.getWidth() / 2;
        p.y -= w.getHeight() / 2;
        w.setLocation(p);
    }
}

