/*
 * Decompiled with CFR 0.152.
 */
package medicine;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import medicine.Entity;
import medicine.StopSearch;

public class EntitySearcher
implements Runnable {
    ActionListener al;
    Entity startNode;
    Thread thread = new Thread((Runnable)this, "Searcher_" + this.toString());
    boolean searching = false;
    String searchstring;
    public boolean caseSensitive = false;
    public boolean exactMatch = false;
    Set searchedset = new HashSet();
    Vector found = new Vector();
    int serial = 0;
    boolean running = true;

    public EntitySearcher(String searchstring, Entity startNode, ActionListener al) {
        this.al = al;
        this.startNode = startNode;
        this.searchstring = searchstring;
    }

    public void run() {
        this.searching = true;
        try {
            this.searchTree(this.startNode);
            this.al.actionPerformed(new ActionEvent(this, -1, null));
        }
        catch (StopSearch stopSearch) {
            // empty catch block
        }
        this.searching = false;
    }

    public void start() {
        this.thread.start();
    }

    public synchronized void stop() {
        this.running = false;
    }

    void assertRunning() throws StopSearch {
        if (!this.running) {
            throw new StopSearch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchTree(Entity node) throws StopSearch {
        this.assertRunning();
        boolean found = this.caseSensitive ? (this.exactMatch ? node.equals(this.searchstring) : node.contains(this.searchstring)) : (this.exactMatch ? node.equalsIgnoreCase(this.searchstring) : node.containsIgnoreCase(this.searchstring));
        Set set = this.searchedset;
        synchronized (set) {
            this.assertRunning();
            this.searchedset.add(node);
            if (found) {
                this.foundEntity(node);
            }
        }
        this.assertRunning();
        this.trySearchAll(node.causes);
        this.assertRunning();
        this.trySearchAll(node.effects);
        this.assertRunning();
        this.trySearchAll(node.children);
        this.assertRunning();
        this.trySearchAll(node.parents);
    }

    public void trySearchAll(Vector v) throws StopSearch {
        int i = 0;
        while (i < v.size()) {
            Object o = v.get(i);
            if (!this.searchedset.contains(o)) {
                this.searchTree((Entity)o);
            }
            ++i;
        }
    }

    public void foundEntity(Entity e) {
        this.found.add(e);
        this.al.actionPerformed(new ActionEvent(e, this.serial++, e.name));
    }
}

