/*
 * Decompiled with CFR 0.152.
 */
package medicine;

import java.io.Serializable;
import java.util.Vector;

public class Entity
implements Serializable {
    static int serial = 0;
    public static final int PARENT = 1;
    public static final int CHILD = 2;
    public static final int CAUSE = 4;
    public static final int EFFECT = 8;
    static int[] relationList = new int[]{4, 8, 1, 2};
    public Vector children = new Vector();
    public Vector parents = new Vector();
    public Vector causes = new Vector();
    public Vector effects = new Vector();
    public Vector synonyms;
    public String name;
    public String description;

    public Entity(Entity from, int connection) {
        if (from != null) {
            this.connect(from, connection);
        }
        this.synonyms = new Vector();
        this.name = "Entity" + serial++;
        this.description = "";
    }

    public Vector listOf(int relation) {
        switch (relation) {
            case 1: {
                return this.parents;
            }
            case 2: {
                return this.children;
            }
            case 4: {
                return this.causes;
            }
            case 8: {
                return this.effects;
            }
        }
        return null;
    }

    public static int inverseOf(int reciprocalRelation) {
        switch (reciprocalRelation) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 8;
            }
            case 8: {
                return 4;
            }
        }
        return 0;
    }

    public void connect(Entity to, int connectAs) {
        Vector mylist = this.listOf(connectAs);
        if (mylist.indexOf(to) >= 0) {
            return;
        }
        this.listOf(connectAs).add(to);
        to.listOf(Entity.inverseOf(connectAs)).add(this);
    }

    public void disconnect(Entity from, int relation) {
        if (this.numConnections() < 2) {
            System.out.println("Cannot delete last connection");
            return;
        }
        this.listOf(relation).remove(from);
        from.listOf(Entity.inverseOf(relation)).remove(this);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(String s) {
        if (this.name.equals(s)) {
            return true;
        }
        int i = 0;
        while (i < this.synonyms.size()) {
            if (s.equals((String)this.synonyms.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean equalsIgnoreCase(String s) {
        if (this.name.equalsIgnoreCase(s)) {
            return true;
        }
        int i = 0;
        while (i < this.synonyms.size()) {
            if (s.equalsIgnoreCase((String)this.synonyms.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(String s) {
        if (this.name.indexOf(s) >= 0) {
            return true;
        }
        int i = 0;
        while (i < this.synonyms.size()) {
            if (((String)this.synonyms.get(i)).indexOf(s) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsIgnoreCase(String s) {
        if (this.indexOfIgnoreCase(this.name, s) >= 0) {
            return true;
        }
        int i = 0;
        while (i < this.synonyms.size()) {
            if (this.indexOfIgnoreCase((String)this.synonyms.get(i), s) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int indexOfIgnoreCase(String main, String sub) {
        int k = 0;
        while (k <= main.length() - sub.length()) {
            if (main.substring(k, k + sub.length()).equalsIgnoreCase(sub)) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    public boolean isBlank() {
        return this.synonyms.isEmpty() && this.numConnections() < 2 && this.description.equals("");
    }

    public void replaceAllWith(Entity replacement) {
        int i = 0;
        while (i < relationList.length) {
            int rel = relationList[i];
            Vector v = this.listOf(rel);
            int j = 0;
            while (j < v.size()) {
                Entity dest = (Entity)v.get(j);
                replacement.connect(dest, rel);
                dest.disconnect(this, Entity.inverseOf(rel));
                ++j;
            }
            ++i;
        }
    }

    int numConnections() {
        return this.causes.size() + this.effects.size() + this.parents.size() + this.children.size();
    }
}

