/*
 * Decompiled with CFR 0.152.
 */
package medicine;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import medicine.Entity;
import medicine.EntityCrawler;
import medicine.EntityData;

public class Entities {
    Vector entities;
    ActionListener completionListener;
    boolean isLooking = false;
    Entities thisEntities = this;
    public Hashtable namedEntities = new Hashtable();

    public synchronized void setVector(Entity start, ActionListener onComplete) {
        this.isLooking = true;
        this.entities = new Vector();
        this.completionListener = onComplete;
        EntityCrawler ec = new EntityCrawler(start, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand() == null) {
                    Entities.this.isLooking = false;
                    Entities.this.completionListener.actionPerformed(new ActionEvent(Entities.this.thisEntities, -1, null));
                }
                if (e.getSource() instanceof Entity) {
                    Entity entity = (Entity)e.getSource();
                    Entities.this.entities.add(entity);
                }
            }
        });
        ec.start();
    }

    public void setVector(Vector v) {
        this.entities = v;
    }

    public Vector getVector() {
        return this.entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTextForm(OutputStream os) {
        if (this.isLooking) {
            throw new Error("Search not completed");
        }
        PrintStream out = new PrintStream(os);
        Entities entities = this;
        synchronized (entities) {
            int i = 0;
            while (i < this.entities.size()) {
                Entity ent = (Entity)this.entities.get(i);
                this.writeTextForm(out, ent);
                ++i;
            }
        }
    }

    void writeTextForm(PrintStream out, Entity e) {
        out.println(String.valueOf(e.name) + " {");
        if (e.synonyms.size() > 0) {
            out.println("\tSynonyms {" + this.getDelimitedNames(e.synonyms, ", ") + "}");
        }
        if (e.causes.size() > 0) {
            out.println("\tCauses {" + this.getDelimitedNames(e.causes, ", ") + "}");
        }
        if (e.effects.size() > 0) {
            out.println("\tEffects {" + this.getDelimitedNames(e.effects, ", ") + "}");
        }
        if (e.parents.size() > 0) {
            out.println("\tParents {" + this.getDelimitedNames(e.parents, ", ") + "}");
        }
        if (e.children.size() > 0) {
            out.println("\tChildren {" + this.getDelimitedNames(e.children, ", ") + "}");
        }
        if (!e.description.equals("")) {
            out.println("\tDescription {\"" + e.description.replace('{', '(').replace('}', ')') + "\"}");
        }
        out.println("}");
    }

    public static Entity readTextForm(InputStream is) throws IOException {
        InputStreamReader fr = null;
        EntityData data = null;
        try {
            fr = new InputStreamReader(is);
            data = new EntityData();
            while (true) {
                Entities.readEntity(data, fr);
            }
        }
        catch (EOF eOF) {
            if (fr != null) {
                fr.close();
            }
            if (data == null) {
                return null;
            }
            if (data.size() == 0) {
                return null;
            }
            return data.getFirstEntity();
        }
    }

    public static EntityData readDataTextForm(InputStream is) throws IOException {
        InputStreamReader fr = null;
        EntityData data = null;
        try {
            fr = new InputStreamReader(is);
            data = new EntityData();
            while (true) {
                Entities.readEntity(data, fr);
            }
        }
        catch (EOF eOF) {
            if (fr != null) {
                fr.close();
            }
            if (data == null) {
                return null;
            }
            if (data.size() == 0) {
                return null;
            }
            return data;
        }
    }

    public static Entity mergeTextFromStreams(InputStream is, InputStream is2) throws IOException {
        InputStreamReader fr = null;
        EntityData data = null;
        try {
            fr = new InputStreamReader(is);
            data = new EntityData();
            while (true) {
                Entities.readEntity(data, fr);
            }
        }
        catch (EOF eOF) {
            if (fr != null) {
                fr.close();
                fr = null;
            }
            if (data == null) {
                data = new EntityData();
            }
            try {
                fr = new InputStreamReader(is2);
                while (true) {
                    Entities.readEntity(data, fr);
                }
            }
            catch (EOF eOF2) {
                if (fr != null) {
                    fr.close();
                }
                if (data == null) {
                    return null;
                }
                if (data.size() == 0) {
                    return null;
                }
                return data.getFirstEntity();
            }
        }
    }

    private static void readEntity(EntityData data, Reader r) throws IOException, EOF {
        int ch;
        StringBuffer nameb = new StringBuffer();
        while ((ch = r.read()) != 123 && ch != -1) {
            nameb.append((char)ch);
        }
        if (ch == -1) {
            throw new EOF();
        }
        String name = nameb.toString().trim();
        Entity e = data.findEntityExact(name);
        if (e == null) {
            e = data.addNewEntity(name);
        }
        try {
            while (true) {
                Entities.readSection(e, data, r);
            }
        }
        catch (EOE eOE) {
            return;
        }
    }

    private static void readSection(Entity e, EntityData data, Reader r) throws EOE, IOException {
        int ch;
        StringBuffer nameb = new StringBuffer();
        while ((ch = r.read()) != 123 && ch != 125 && ch != -1) {
            nameb.append((char)ch);
        }
        if (ch == 125) {
            throw new EOE();
        }
        if (ch == -1) {
            throw new EOF();
        }
        String name = nameb.toString().trim();
        if (name.equals("Causes")) {
            Entities.readListTillCloseBracket(e.causes, data, r, true);
        }
        if (name.equals("Effects")) {
            Entities.readListTillCloseBracket(e.effects, data, r, true);
        }
        if (name.equals("Parents")) {
            Entities.readListTillCloseBracket(e.parents, data, r, true);
        }
        if (name.equals("Children")) {
            Entities.readListTillCloseBracket(e.children, data, r, true);
        }
        if (name.equals("Synonyms")) {
            Entities.readListTillCloseBracket(e.synonyms, data, r, false);
        }
        if (name.equals("Description")) {
            StringBuffer desc = new StringBuffer();
            while ((ch = r.read()) != 125 && ch != -1) {
                desc.append((char)ch);
            }
            if (ch == -1) {
                throw new EOF();
            }
            String d = desc.toString().trim();
            if (d.startsWith("\"")) {
                d = d.substring(1, d.length() - 1);
            }
            Entities.mergeDescriptions(e, d);
        }
    }

    private static void readListTillCloseBracket(Vector v, EntityData data, Reader r, boolean convertToEntity) throws IOException, EOF {
        int ch;
        StringBuffer s = new StringBuffer();
        while ((ch = r.read()) != 125) {
            if (ch == -1) {
                throw new EOF();
            }
            if (ch == 44) {
                Entities.storeEntity(s, v, data, convertToEntity);
                continue;
            }
            s.append((char)ch);
        }
        Entities.storeEntity(s, v, data, convertToEntity);
    }

    private static void storeEntity(StringBuffer s, Vector v, EntityData d, boolean convertToEntity) {
        String n = s.toString().trim();
        if (convertToEntity) {
            Entity e = d.findEntityExact(n);
            if (e == null) {
                e = d.addNewEntity(n);
                v.addElement(e);
            } else if (!v.contains(e)) {
                v.addElement(e);
            }
            s.setLength(0);
        } else {
            if (!v.contains(s.toString().intern())) {
                v.addElement(s.toString().trim());
            }
            s.setLength(0);
        }
    }

    private static void mergeDescriptions(Entity e, String d) {
        if (e.description.equals(d)) {
            return;
        }
        if (e.description.startsWith(d)) {
            return;
        }
        if (d.startsWith(e.description)) {
            e.description = d;
            return;
        }
        e.description = String.valueOf(e.description) + '\n' + d;
    }

    String getDelimitedNames(Vector v, String delimiter) {
        StringBuffer list = new StringBuffer();
        int i = 0;
        while (i < v.size()) {
            Object o = v.get(i);
            String s = o.toString();
            s = s.replace('{', '(').replace('}', ')');
            list.append(o.toString());
            if (i < v.size() - 1) {
                list.append(delimiter);
            }
            ++i;
        }
        return list.toString();
    }

    String readUntil(StreamTokenizer st, String c) throws IOException {
        StringBuffer s = new StringBuffer();
        do {
            int tt;
            if ((tt = st.nextToken()) != -3) continue;
            s.append(st.sval);
        } while (!st.sval.equals(c));
        return s.toString().trim();
    }

    public static Vector getAllCauses(Entity entity, Vector except) {
        if (except != null && except.contains(entity)) {
            return null;
        }
        if (except == null) {
            except = new Vector<Entity>();
        }
        Vector v = new Vector();
        except.add(entity);
        int i = 0;
        while (i < entity.causes.size()) {
            Vector ve;
            Entity e = (Entity)entity.causes.get(i);
            if (!(except != null && except.contains(e) || (ve = Entities.getAllCauses(e, v)) == null)) {
                if (ve.size() > 0) {
                    v.addAll(ve);
                } else {
                    ve.add(e);
                }
            }
            ++i;
        }
        return v;
    }

    public static Vector getCauseHierarchy(Entity entity, Vector complete) {
        if (complete != null && complete.contains(entity)) {
            return null;
        }
        if (complete == null) {
            complete = new Vector<Entity>();
        }
        Vector<Vector> v = new Vector<Vector>();
        complete.add(entity);
        int i = 0;
        while (i < entity.causes.size()) {
            Vector add;
            Entity e = (Entity)entity.causes.get(i);
            if (!(complete != null && complete.contains(e) || (add = Entities.getCauseHierarchy(e, complete)) == null)) {
                v.add(add);
            }
            ++i;
        }
        return v;
    }

    public static int numConnections(Entity e) {
        return e.causes.size() + e.effects.size() + e.parents.size() + e.children.size();
    }

    public static boolean isChildOf(Entity queryItem, Entity parent) {
        Vector p = queryItem.parents;
        if (p.indexOf(parent) >= 0) {
            return true;
        }
        int i = 0;
        while (i < p.size()) {
            Entity nquery = (Entity)p.get(i);
            if (Entities.isChildOf(nquery, parent)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Entity getSpecificNamedEntity(String name) {
        Object o = this.namedEntities.get(name);
        if (o != null) {
            return (Entity)o;
        }
        Entity entity = Entities.findNamedEntityExact(name, (Entity)this.entities.get(0));
        this.namedEntities.put(name, entity);
        return entity;
    }

    public static Entity getSpecificNamedEntity(String name, Entity any) {
        Entity entity = Entities.findNamedEntityExact(name, any);
        return entity;
    }

    public static Entity getUltimateParents(Entity e) {
        if (e.parents.size() == 0) {
            return null;
        }
        Entity p = (Entity)e.parents.elementAt(0);
        while (p.parents.size() > 0) {
            p = (Entity)p.parents.elementAt(0);
        }
        return p;
    }

    private static Entity findNamedEntityExact(final String name, Entity startNode) throws AmbiguityException {
        final Vector results = new Vector();
        EntityCrawler ec = new EntityCrawler(startNode, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof Entity) {
                    Entity entity = (Entity)e.getSource();
                    if (entity.name.equalsIgnoreCase(name)) {
                        results.add(entity);
                    }
                }
            }
        });
        ec.start();
        try {
            ec.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (results.size() < 1) {
            return null;
        }
        if (results.size() > 1) {
            throw new AmbiguityException("There are " + results.size() + "entities named " + name);
        }
        return (Entity)results.get(0);
    }

    public static boolean isRelativeOf(Entity queryEntity, Entity putativeRelative, int relation, boolean traverseParents, boolean traverseChildren, int maxRecursionDepth) {
        if (maxRecursionDepth <= 0) {
            return false;
        }
        if (queryEntity == putativeRelative) {
            return true;
        }
        Vector v = queryEntity.listOf(relation);
        int i = 0;
        while (i < v.size()) {
            if (v.get(i) == putativeRelative) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < v.size()) {
            Entity e = (Entity)v.get(i);
            if (Entities.isRelativeOf(e, putativeRelative, relation, traverseParents, traverseChildren, maxRecursionDepth - 1)) {
                return true;
            }
            ++i;
        }
        if (relation == 4 || relation == 8) {
            Entity t;
            if (traverseParents) {
                i = 0;
                while (i < queryEntity.parents.size()) {
                    t = (Entity)queryEntity.parents.get(i);
                    if (Entities.isRelativeOf(t, putativeRelative, relation, traverseParents, traverseChildren, maxRecursionDepth - 1)) {
                        return true;
                    }
                    ++i;
                }
            }
            if (traverseChildren) {
                i = 0;
                while (i < queryEntity.children.size()) {
                    t = (Entity)queryEntity.children.get(i);
                    if (Entities.isRelativeOf(t, putativeRelative, relation, traverseParents, traverseChildren, maxRecursionDepth - 1)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public static class AmbiguityException
    extends RuntimeException {
        public AmbiguityException(String s) {
            super(s);
        }

        public AmbiguityException() {
        }
    }

    public static class DynamicRelationNode
    extends DefaultMutableTreeNode {
        Entity entity;
        int relations;
        boolean loadedChildren = false;

        public DynamicRelationNode(Entity e, int relations) {
            super(e);
            this.entity = e;
            this.relations = relations;
            this.setAllowsChildren(true);
        }

        public boolean isLeaf() {
            return !this.getAllowsChildren();
        }

        public int getChildCount() {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.getChildCount();
        }

        public TreeNode getChildAt(int index) {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.getChildAt(index);
        }

        public Enumeration children() {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.children();
        }

        protected void loadChildren() {
            this.loadedChildren = true;
            DynamicRelationNode.createChildren(this, this.entity, this.relations);
        }

        public static void createChildren(DefaultMutableTreeNode n, Entity entity, int relations) {
            boolean viaParent = (relations & 1) > 0;
            boolean viaChild = (relations & 2) > 0;
            int relation = -1;
            if ((relations & 4) > 0) {
                relation = 4;
            } else if ((relations & 8) > 0) {
                relation = 8;
            }
            if (relation == -1) {
                return;
            }
            Vector rels = entity.listOf(relation);
            DynamicRelationNode.fillWithVector(n, rels, relations);
            if (viaParent) {
                Vector p = entity.listOf(1);
                int i = 0;
                while (i < p.size()) {
                    DynamicRelationNode.fillWithVector(n, ((Entity)p.get(i)).listOf(relation), relations);
                    ++i;
                }
            }
            if (viaChild) {
                DynamicRelationNode.fillWithVector(n, entity.listOf(2), relations);
            }
            n.setAllowsChildren(n.getChildCount() > 0);
        }

        protected static void fillWithVector(DefaultMutableTreeNode n, Vector v, int r) {
            if (v == null || n == null) {
                return;
            }
            int i = 0;
            while (i < v.size()) {
                n.add(new DynamicRelationNode((Entity)v.get(i), r));
                ++i;
            }
        }
    }

    static class EOE
    extends IllegalStateException {
        EOE() {
        }
    }

    static class EOF
    extends IllegalStateException {
        EOF() {
        }
    }
}

