/*
 * Decompiled with CFR 0.152.
 */
package evaluator;

import evaluator.EquationException;
import evaluator.Expression;
import evaluator.MathException;
import evaluator.ParseException;
import evaluator.StackException;
import evaluator.Variable;
import java.io.Serializable;
import phic.common.Container;
import phic.gui.Node;
import phic.gui.PhicEvaluator;
import phic.gui.Variables;
import phic.gui.VisibleVariable;

public class Statement
implements Serializable {
    String string;
    transient Expression expr;
    String left = null;

    public Statement(String s) throws ParseException {
        this.string = s;
        this.compile();
    }

    void compile() {
        boolean needDummyVar;
        this.strip();
        String s = this.string;
        int eq = s.indexOf(61);
        this.left = null;
        if (eq >= 0) {
            String right;
            this.left = s.substring(0, eq).trim();
            s = right = s.substring(eq + 1).trim();
        }
        boolean bl = needDummyVar = this.left != null && this.tryFindVariableByName(this.left) == null && Variable.table.get(this.left) == null;
        if (needDummyVar) {
            Variable.set(this.left, "");
        }
        this.expr = new Expression(s);
        if (needDummyVar) {
            Variable.remove(this.left);
        }
    }

    public Object evaluate() throws MathException, StackException {
        if (this.expr == null) {
            this.compile();
        }
        Object ans = this.expr.evaluate();
        if (this.left != null) {
            this.set(this.left, ans);
        }
        return ans;
    }

    VisibleVariable tryFindVariableByName(String vname) {
        VisibleVariable v;
        try {
            v = Variables.forName(vname);
        }
        catch (IllegalArgumentException e1) {
            try {
                v = Variables.forName("body." + vname);
            }
            catch (IllegalArgumentException e2) {
                try {
                    v = Variables.forName("environment." + vname);
                }
                catch (IllegalArgumentException e3) {
                    v = null;
                }
            }
        }
        return v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(String vname, Object value) throws EquationException {
        Node n;
        VisibleVariable v = this.tryFindVariableByName(vname);
        if (v == null) {
            try {
                n = Node.findNodeByName(vname);
            }
            catch (IllegalArgumentException x) {
                try {
                    PhicEvaluator.set(vname, value);
                    return;
                }
                catch (Exception x2) {
                    Variable.set(vname, value);
                    return;
                }
            }
        } else {
            n = v.node;
        }
        int type = n.getType();
        if (type == 2) {
            if (value instanceof Double) {
                n.doubleSetVal((Double)value);
                return;
            } else {
                n.doubleSetVal(Double.parseDouble(value.toString()));
            }
            return;
        } else if (type == 4) {
            if (!(value instanceof Container)) throw new EquationException("Result '" + value.toString() + "' is not a Container");
            ((Container)n.objectGetVal()).set((Container)value);
            return;
        } else {
            if (type != 3) throw new EquationException("Type mismatch between " + value.toString() + " and " + v.node.canonicalName());
            if (!(value instanceof Boolean)) throw new EquationException("Result '" + value.toString() + "' is not a Boolean");
            n.booleanSetVal((Boolean)value);
        }
    }

    String makeword(String s) {
        if (s.length() == 0) {
            return null;
        }
        String n = new String();
        char c = s.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            return null;
        }
        n = String.valueOf(n) + c;
        int i = 1;
        while (i < s.length()) {
            c = s.charAt(i);
            if (!Character.isIdentifierIgnorable(c)) {
                if (Character.isJavaIdentifierPart(c) || c == '.') {
                    n = String.valueOf(n) + c;
                } else {
                    return null;
                }
            }
            ++i;
        }
        return n;
    }

    public String getDefinition() {
        return this.string;
    }

    public void strip() {
        String oldString = this.string;
        this.string = this.string.trim();
        if (this.string.startsWith(";") || this.string.startsWith("\n")) {
            this.string = this.string.substring(1);
        }
        if (this.string.endsWith(";") || this.string.endsWith("\n")) {
            this.string = this.string.substring(0, this.string.length() - 1);
        }
        if (!this.string.equals(oldString)) {
            this.strip();
        }
    }
}

