/*
 * Decompiled with CFR 0.152.
 */
package evaluator;

import evaluator.ParseException;
import evaluator.Variable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public abstract class ObjectPath {
    Object object;
    Member member;
    static Object[] root = new Object[0];
    static String[] packages = new String[]{"java.lang"};
    Object dummyItem;
    protected int nParams;

    public Member getMember() {
        return this.member;
    }

    public Object getObject() {
        return this.object;
    }

    public static void setRoot(Object[] rroot) {
        root = rroot;
    }

    public static Object[] getRoot() {
        return root;
    }

    public static void setPackage(String[] rpackages) {
        packages = rpackages;
    }

    public static String[] getPackage() {
        return packages;
    }

    void createPath(String path) throws ParseException {
        int i = 0;
        while (i < ObjectPath.getRoot().length) {
            StringTokenizer st = new StringTokenizer(path, ".");
            Object o = ObjectPath.getRoot()[i];
            if (this.find(st, o, o.getClass())) break;
            st = new StringTokenizer(path, ".");
            if (o instanceof Class && this.find(st, null, (Class)o)) break;
            st = new StringTokenizer(path, ".");
            try {
                Object t = Variable.namespaceLookup.getVariableValue(st.nextToken());
                if (t != null && this.find(st, t, t.getClass())) {
                    break;
                }
            }
            catch (Exception t) {
                // empty catch block
            }
            ++i;
        }
        if (this.member == null) {
            String[] packages = ObjectPath.getPackage();
            boolean found = false;
            int i2 = 0;
            while (i2 < packages.length) {
                try {
                    StringTokenizer st = new StringTokenizer(path, ".");
                    String token = st.nextToken();
                    Class<?> cls = Class.forName(String.valueOf(packages[i2]) + '.' + token);
                    found = this.find(st, null, cls);
                    if (found) break;
                }
                catch (ClassNotFoundException e) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
                ++i2;
            }
            if (this.member instanceof Field && ((Field)this.member).getType().isAssignableFrom(phic.common.Variable.class)) {
                try {
                    Variable newObject = (Variable)((Field)this.member).get(this.object);
                    this.member = phic.common.Variable.class.getMethod("get", new Class[0]);
                    this.object = newObject;
                    found = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!found) {
                throw new ParseException("Cannot find object " + path);
            }
        }
    }

    boolean find(StringTokenizer st, Object newobject, Class cls) {
        try {
            while (st.hasMoreElements()) {
                block10: {
                    this.object = newobject;
                    String token = st.nextToken();
                    try {
                        Field field = cls.getField(token);
                        this.member = field;
                        if (st.hasMoreElements()) {
                            newobject = field.get(this.object);
                        }
                    }
                    catch (Exception e) {
                        try {
                            Method method = this.findMethod(cls, token, this.nParams);
                            this.member = method;
                            if (st.hasMoreElements() && this.nParams == 0) {
                                newobject = method.invoke(this.object, null);
                            }
                        }
                        catch (Exception ex) {
                            throw new ParseException("Can't find " + token + " in " + this.object);
                        }
                        if (newobject != null || !st.hasMoreElements()) break block10;
                        throw new ParseException("Null object " + token + " in " + this.object);
                    }
                }
                if (newobject == null) continue;
                cls = newobject.getClass();
            }
            if (this.member == null) {
                throw new ParseException("Error finding object " + st);
            }
        }
        catch (ParseException e) {
            this.object = null;
            return false;
        }
        return true;
    }

    private Method findMethod(Class cls, String token, int nParams) throws NoSuchMethodException {
        Method[] m = cls.getMethods();
        int i = 0;
        while (i < m.length) {
            if (m[i].getName().equals(token) && m[i].getParameterTypes().length == nParams) {
                return m[i];
            }
            ++i;
        }
        throw new NoSuchMethodException();
    }
}

