/*
 * Decompiled with CFR 0.152.
 */
package evaluator;

import evaluator.MathException;
import evaluator.Operator;
import evaluator.Stack;
import evaluator.StackException;
import evaluator.TypeException;

public class MethodAccessOperator
implements Operator {
    int parameters;
    String methodName;

    public MethodAccessOperator(String methodName, int parameters) {
        this.parameters = parameters;
        this.methodName = methodName;
    }

    public void doStackOp(Stack stack) throws MathException, StackException {
        Object[] p = new Object[this.parameters];
        Class[] c = new Class[this.parameters];
        int i = this.parameters - 1;
        while (i >= 0) {
            p[i] = stack.pop();
            c[i] = p[i].getClass();
            --i;
        }
        Object o = stack.pop();
        try {
            Object result = o.getClass().getMethod(this.methodName, c).invoke(o, p);
            stack.push(result);
        }
        catch (Exception e) {
            try {
                int j = 0;
                while (j < this.parameters) {
                    if (c[j] == Double.class) {
                        c[j] = Double.TYPE;
                    }
                    ++j;
                }
                Object result = o.getClass().getMethod(this.methodName, c).invoke(o, p);
                stack.push(result);
            }
            catch (Exception ex) {
                throw new TypeException(stack, "Cannot invoke method '" + this.methodName + "(<<" + this.parameters + ">>)' on object '" + o.toString() + "' :\n" + ex.toString());
            }
        }
    }

    public int getStackCount() {
        return -this.parameters;
    }
}

