/*
 * Decompiled with CFR 0.152.
 */
package evaluator;

public class MathExtra {
    public static final double eulerGamma = 0.5772156649015329;

    public static final double cosh(double x) {
        return (Math.exp(x) + Math.exp(-x)) / 2.0;
    }

    public static final double sinh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / 2.0;
    }

    public static final double tanh(double x) {
        return MathExtra.sinh(x) / MathExtra.cosh(x);
    }

    public static final double cosec(double x) {
        return 1.0 / Math.sin(x);
    }

    public static final double sec(double x) {
        return 1.0 / Math.cos(x);
    }

    public static final double cot(double x) {
        return 1.0 / Math.tan(x);
    }

    public static final double cosech(double x) {
        return 1.0 / MathExtra.sinh(x);
    }

    public static final double sech(double x) {
        return 1.0 / MathExtra.cosh(x);
    }

    public static final double coth(double x) {
        return MathExtra.cosh(x) / MathExtra.sinh(x);
    }

    public static final double log10(double x) {
        return Math.log(x) / Math.log(10.0);
    }

    public static final double sgn(double x) {
        return x / Math.abs(x);
    }

    public static final double factorial(double x) {
        int r = 1;
        int i = 1;
        while ((double)i < x) {
            r *= i;
            ++i;
        }
        return r;
    }

    public static final double frac(double x) {
        return x - Math.floor(x);
    }

    public static final double nCr(double n, double k) {
        return MathExtra.factorial(n) / (MathExtra.factorial(k) * MathExtra.factorial(n - k));
    }

    public static final double ramp(double x) {
        return Math.floor(x) % 2.0 == 0.0 ? MathExtra.frac(x) : 1.0 - MathExtra.frac(x);
    }

    public static final double truncatedRamp(double x) {
        return Math.min(Math.max(MathExtra.ramp(x) * 2.0 - 0.5, 0.0), 1.0);
    }

    public static final double mod(double x, double b) {
        return x % b;
    }

    public static final double gaussian(double x) {
        return Math.exp(-x * x);
    }

    public static final double gabor(double x, double frequency, double phase) {
        return MathExtra.gaussian(x) * Math.cos(x * frequency + phase);
    }

    public static final double sigmoid(double x) {
        return x < 0.0 ? 0.0 : (x > 1.0 ? 1.0 : 0.5 - Math.cos(x * Math.PI) / 2.0);
    }

    public static final double inverseSigmoid(double y) {
        return y <= 0.0 ? 0.0 : (y >= 1.0 ? 1.0 : Math.acos(1.0 - 2.0 * y) / Math.PI);
    }
}

