/*
 * Decompiled with CFR 0.152.
 */
package evaluator;

import evaluator.MathException;
import evaluator.Operator;
import evaluator.Stack;
import evaluator.StackException;
import evaluator.TypeException;
import phic.common.Variable;

public class FieldAccessOperator
implements Operator {
    String fieldName;

    public FieldAccessOperator(String fieldName) {
        this.fieldName = fieldName;
    }

    public void doStackOp(Stack stack) throws MathException, StackException {
        Object o = stack.pop();
        try {
            Object result = o.getClass().getField(this.fieldName).get(o);
            if (result instanceof Variable) {
                result = new Double(((Variable)result).get());
            }
            stack.push(result);
        }
        catch (Exception x) {
            throw new TypeException(stack, "Cannot access field '" + this.fieldName + "' in object '" + o.toString() + "' :\n" + x.toString());
        }
    }

    public int getStackCount() {
        return 0;
    }
}

