/*
 * Decompiled with CFR 0.152.
 */
package evaluator;

import evaluator.EquationException;
import evaluator.Expression;
import evaluator.MathException;
import evaluator.ParseException;
import evaluator.StackException;
import evaluator.Variable;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import phic.modifiable.EvaluatorHelper;

public class EvaluatorConsole
extends JTextPane {
    Action evaluateAction = new AbstractAction("Evaluate"){

        public void actionPerformed(ActionEvent e) {
            EvaluatorConsole.this.evaluateLine();
        }
    };
    JTextComponent.KeyBinding[] defaultBindings = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(10, 0), "Evaluate")};
    JTextComponent c = new JTextPane();
    protected Action evaluateSelection = new AbstractAction("Evaluate selection"){

        public void actionPerformed(ActionEvent e) {
            String s = EvaluatorConsole.this.getSelectedText();
            int p = EvaluatorConsole.this.getCaretPosition();
            int a1 = s.lastIndexOf(10, p - 1) + 1;
            int a2 = s.indexOf(10, p);
            if (a1 <= 0) {
                a1 = 0;
            }
            if (a2 < 0) {
                a2 = s.length();
            }
            try {
                s = EvaluatorConsole.this.evaluate(s);
                EvaluatorConsole.this.insert(String.valueOf('\n') + s + '\n', a2, aOutput);
            }
            catch (ParseException ex) {
                EvaluatorConsole.this.insert(String.valueOf('\n') + ex.getMessage() + '\n', a2, aError);
            }
            catch (MathException ex) {
                EvaluatorConsole.this.insert(String.valueOf('\n') + ex.getMessage() + '\n', a2, aError);
            }
            catch (StackException ex) {
                EvaluatorConsole.this.insert(String.valueOf('\n') + ex.getMessage() + '\n', a2, aError);
            }
            catch (Exception ex) {
                System.out.println("unknown exception");
                ex.printStackTrace();
            }
        }
    };
    protected static SimpleAttributeSet aOutput = new SimpleAttributeSet();
    protected static SimpleAttributeSet aInput = new SimpleAttributeSet();
    protected static SimpleAttributeSet aError = new SimpleAttributeSet();

    static {
        aOutput.addAttribute(StyleConstants.Foreground, Color.blue);
        aError.addAttribute(StyleConstants.Foreground, Color.red);
        aInput.addAttribute(StyleConstants.Foreground, Color.black);
    }

    public EvaluatorConsole() {
        Keymap k = this.c.getKeymap();
        JTextComponent.loadKeymap(k, this.defaultBindings, new Action[]{this.evaluateAction});
        this.setFont(new Font("Monospaced", 0, 12));
    }

    public void evaluateLine() {
        double ans = 0.0;
        String s = "";
        try {
            s = this.getDocument().getText(0, this.getDocument().getLength());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int p = this.getCaretPosition();
        int a1 = s.lastIndexOf(10, p - 1) + 1;
        int a2 = s.indexOf(10, p);
        if (a1 <= 0) {
            a1 = 0;
        }
        if (a2 < 0) {
            a2 = s.length();
        }
        s = s.substring(a1, a2);
        try {
            s = this.evaluate(s);
            this.insert(String.valueOf('\n') + s + '\n', a2, aOutput);
        }
        catch (ParseException ex) {
            this.insert(String.valueOf('\n') + ex.getMessage() + '\n', a2, aError);
        }
        catch (MathException ex) {
            this.insert(String.valueOf('\n') + ex.getMessage() + '\n', a2, aError);
        }
        catch (StackException ex) {
            this.insert(String.valueOf('\n') + ex.getMessage() + '\n', a2, aError);
        }
        catch (Exception ex) {
            System.out.println("unknown exception");
            ex.printStackTrace();
        }
    }

    protected String evaluate(String s) throws MathException, ParseException, StackException {
        int eq = s.indexOf(61);
        String left = null;
        if (eq >= 0) {
            String right;
            left = s.substring(0, eq);
            s = right = s.substring(eq + 1);
        }
        Expression expr = new Expression(s);
        Object ans = expr.evaluate();
        if (left != null) {
            EvaluatorConsole.set(left, ans);
        }
        return EvaluatorHelper.formatAnswer(ans);
    }

    public static void set(String vname, Object value) throws EquationException {
        String n = EvaluatorConsole.makeword(vname);
        if (n == null) {
            throw new EquationException("Invalid LHS");
        }
        Variable.set(n, value);
    }

    static String makeword(String s) {
        if (s.length() == 0) {
            return null;
        }
        String n = new String();
        char c = s.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            return null;
        }
        n = String.valueOf(n) + c;
        int i = 1;
        while (i < s.length()) {
            c = s.charAt(i);
            if (!Character.isIdentifierIgnorable(c)) {
                if (Character.isJavaIdentifierPart(c) || c == '.') {
                    n = String.valueOf(n) + c;
                } else {
                    return null;
                }
            }
            ++i;
        }
        return n;
    }

    protected void insert(String s, int p, AttributeSet a) {
        try {
            this.getDocument().insertString(p, s, a);
            this.setCaretPosition(p + s.length());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setCharacterAttributes(aInput, true);
    }
}

