/*
 * Decompiled with CFR 0.152.
 */
package evaluator;

import evaluator.MathException;
import evaluator.Operator;
import evaluator.Stack;
import evaluator.StackException;

class BinaryOperator
implements Operator {
    static final int PLUS = 0;
    static final int MINUS = 1;
    static final int MULTIPLY = 2;
    static final int DIVIDE = 3;
    static final int POWER = 4;
    int type;

    public BinaryOperator(int type) {
        this.type = type;
    }

    public void doStackOp(Stack stack) throws MathException, StackException {
        double y = stack.popDouble();
        double x = stack.popDouble();
        double ans = Double.NaN;
        switch (this.type) {
            case 0: {
                ans = x + y;
                break;
            }
            case 1: {
                ans = x - y;
                break;
            }
            case 2: {
                ans = x * y;
                break;
            }
            case 3: {
                ans = x / y;
                break;
            }
            case 4: {
                ans = Math.pow(x, y);
            }
        }
        if (Double.isNaN(ans)) {
            throw new MathException(stack, "Operator " + this.type + " not found");
        }
        stack.push(ans);
    }

    public int getStackCount() {
        return -1;
    }
}

