/*
 * Decompiled with CFR 0.152.
 */
package stars;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.util.Random;
import java.util.Vector;
import javax.swing.JPanel;

public class StarPane
extends JPanel
implements Runnable {
    Vector stars = new Vector();
    static Random rand = new Random();
    public double cooling = 0.999;
    public double force = 0.01;
    public double forcepower = 2.0;
    public double initV = 1.0;
    public double temperature = 1000.0;
    public boolean field = false;
    boolean running = false;
    boolean alive = false;
    public Thread thread;
    boolean trails = false;
    private BufferedImage image = null;
    private DataBuffer databuffer;
    private int iwidth;
    private int iheight;
    private int scx = 2;
    private int scy = 2;
    private double sci = 32.0;
    int time;

    public StarPane() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                StarPane.this.createImage();
            }
        });
    }

    public void run() {
        this.alive = true;
        while (this.running) {
            this.calc();
            Thread.yield();
        }
        this.alive = false;
    }

    public void start() {
        this.running = true;
        if (!this.alive) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void stop() {
        this.running = false;
    }

    public void paint(Graphics g) {
        if (!this.trails) {
            super.paint(g);
        }
        g.setColor(this.getForeground());
        if (this.field) {
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, this.iwidth * this.scx, this.iheight * this.scy, null);
            }
        } else {
            int i = 0;
            while (i < this.stars.size()) {
                Star s = (Star)this.stars.get(i);
                g.drawLine((int)s.x, (int)s.y, (int)s.x, (int)s.y);
                ++i;
            }
            int p = (int)StarPane.randomspeed(this.temperature);
            g.drawLine(0, p, 5, p);
        }
    }

    private Image createImage() {
        byte[][] color = new byte[3][256];
        int i = 0;
        while (i < 256) {
            color[0][i] = (byte)(i > 127 ? 255 : 2 * i);
            color[1][i] = (byte)(i < 128 ? 0 : 2 * (i - 128));
            color[2][i] = 0;
            ++i;
        }
        this.iwidth = this.getWidth() / this.scx;
        this.iheight = this.getHeight() / this.scy;
        this.image = new BufferedImage(this.iwidth, this.iheight, 13, new IndexColorModel(8, 256, color[0], color[1], color[2]));
        this.databuffer = this.image.getRaster().getDataBuffer();
        return this.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcimage() {
        if (++this.time % 15 == 0) {
            Vector vector = this.stars;
            synchronized (vector) {
                int i = 0;
                while (i < this.iwidth) {
                    int j = 0;
                    while (j < this.iheight) {
                        this.databuffer.setElem(i + j * this.iwidth, (int)(this.getpixmagn(i * this.scx, j * this.scy) * this.sci) & 0xFF);
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    private double getpixmagn(int x, int y) {
        double m = 0.0;
        int i = 0;
        while (i < this.stars.size()) {
            Star s = (Star)this.stars.get(i);
            double dx = (double)x - s.x;
            double dy = (double)y - s.y;
            double d = dx * dx + dy * dy;
            if (d > 0.1) {
                m += 1.0 / Math.sqrt(d);
            }
            ++i;
        }
        return m;
    }

    public void bang(int x, int y) {
        int i = 0;
        while (i < this.stars.size()) {
            Star s = (Star)this.stars.get(i);
            s.x = x;
            s.y = y;
            s.vx = (rand.nextDouble() - 0.5) * this.initV;
            s.vy = (rand.nextDouble() - 0.5) * this.initV;
            ++i;
        }
    }

    public static double randomspeed(double temp) {
        return Math.random() - 0.5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calc() {
        Vector vector = this.stars;
        synchronized (vector) {
            int i = 0;
            while (i < this.stars.size()) {
                Star s = (Star)this.stars.get(i);
                this.accel(s);
                s.vx *= this.cooling;
                s.vy *= this.cooling;
                ++i;
            }
        }
        int i = 0;
        while (i < this.stars.size()) {
            Star s = (Star)this.stars.get(i);
            s.x += s.vx;
            s.y += s.vy;
            ++i;
        }
        if (this.field) {
            this.calcimage();
        }
        if (this.trails) {
            this.paint(this.getGraphics());
        } else {
            this.repaint();
        }
    }

    protected void accel(Star s) {
        int i = 0;
        while (i < this.stars.size()) {
            double dy;
            double dx;
            double dsquare;
            Star t = (Star)this.stars.get(i);
            if (t != s && (dsquare = (dx = t.x - s.x) * dx + (dy = t.y - s.y) * dy) > 0.1) {
                double d = Math.sqrt(dsquare);
                double f = this.force / Math.pow(d, this.forcepower);
                s.vx += f * dx / d;
                s.vy += f * dy / d;
            }
            ++i;
        }
    }

    public void addStar(int x, int y) {
        Star s = new Star();
        this.stars.add(s);
        s.x = x;
        s.y = y;
        s.vx = StarPane.randomspeed(this.temperature);
        s.vy = StarPane.randomspeed(this.temperature);
    }

    public void removeStar() {
        if (this.stars.size() > 0) {
            this.stars.remove(0);
        }
    }

    class Star {
        double x;
        double y;
        double vx;
        double vy;

        Star() {
        }
    }
}

