/*
 * Decompiled with CFR 0.152.
 */
package sanjay.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class BeanPropertiesPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTable table = new JTable();
    BeanTableModel tablemodel = new BeanTableModel();
    TableCellEditor editor = new BeanTableCellEditor();
    protected Object bean;
    PropertyDescriptor[] props;

    public void setBean(Object b) {
        this.bean = b;
        this.initialise();
        this.table.setCellEditor(this.editor);
    }

    public Object getBean() {
        return this.bean;
    }

    public BeanPropertiesPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.table.setModel(this.tablemodel);
        this.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.table, null);
    }

    protected void initialise() {
        try {
            BeanInfo info = Introspector.getBeanInfo(this.bean.getClass());
            this.props = info.getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    protected class BeanTableCellEditor
    extends DefaultCellEditor {
        PropertyEditor currentEditor;
        JComponent currentComponent;

        BeanTableCellEditor() {
            super(new JComboBox());
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int r, int c) {
            PropertyEditor e = null;
            try {
                e = (PropertyEditor)BeanPropertiesPanel.this.props[r].getPropertyEditorClass().newInstance();
            }
            catch (IllegalAccessException ex1) {
                throw new RuntimeException(ex1);
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            this.currentEditor = e;
            e.setValue(value);
            if (e.isPaintable()) {
                this.currentComponent = new JComboBox();
            } else if (e.getTags() != null) {
                this.currentComponent = new JComboBox();
            }
            return e.getCustomEditor();
        }
    }

    protected class BeanTableModel
    extends AbstractTableModel {
        protected BeanTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return BeanPropertiesPanel.this.props.length;
        }

        public Object getValueAt(int r, int c) {
            Object value;
            if (c == 0) {
                return BeanPropertiesPanel.this.props[r].getName();
            }
            try {
                value = BeanPropertiesPanel.this.props[r].getReadMethod().invoke(BeanPropertiesPanel.this.bean, new Object[0]);
            }
            catch (Exception e) {
                value = null;
                e.printStackTrace();
            }
            return value;
        }

        public void setValueAt(Object value, int r, int c) {
            if (c == 1) {
                try {
                    BeanPropertiesPanel.this.props[r].getWriteMethod().invoke(BeanPropertiesPanel.this.bean, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public boolean isCellEditable(int r, int c) {
            return c == 1;
        }

        public String getColumnName(int c) {
            if (c == 0) {
                return "Property";
            }
            if (c == 1) {
                return "Value";
            }
            return null;
        }
    }
}

