/*
 * Decompiled with CFR 0.152.
 */
package sanjay;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import sanjay.FontPanel;

public class FontSelectionDialog
extends JDialog
implements ItemListener,
ActionListener {
    JLabel fontLabel;
    JLabel sizeLabel;
    JLabel styleLabel;
    FontPanel fontC;
    JComboBox fonts;
    JComboBox sizes;
    JComboBox styles;
    int index = 0;
    String fontchoice = "fontchoice";
    int stChoice = 0;
    String siChoice = "10";
    boolean OK_PRESSED = false;

    public void init() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        JPanel fontPanel = new JPanel();
        JPanel sizePanel = new JPanel();
        JPanel stylePanel = new JPanel();
        JPanel sizeAndStylePanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        fontPanel.setLayout(new GridLayout(2, 1));
        sizePanel.setLayout(new GridLayout(2, 1));
        stylePanel.setLayout(new GridLayout(2, 1));
        sizeAndStylePanel.setLayout(new BorderLayout());
        topPanel.add("West", fontPanel);
        sizeAndStylePanel.add("West", sizePanel);
        sizeAndStylePanel.add("Center", stylePanel);
        topPanel.add("Center", sizeAndStylePanel);
        this.getContentPane().add("North", topPanel);
        this.fontLabel = new JLabel();
        this.fontLabel.setText("Fonts");
        Font newFont = this.getFont();
        this.fontLabel.setFont(newFont);
        this.fontLabel.setHorizontalAlignment(0);
        fontPanel.add(this.fontLabel);
        this.sizeLabel = new JLabel();
        this.sizeLabel.setText("Sizes");
        this.sizeLabel.setFont(newFont);
        this.sizeLabel.setHorizontalAlignment(0);
        sizePanel.add(this.sizeLabel);
        this.styleLabel = new JLabel();
        this.styleLabel.setText("Styles");
        this.styleLabel.setFont(newFont);
        this.styleLabel.setHorizontalAlignment(0);
        stylePanel.add(this.styleLabel);
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] envfonts = gEnv.getAvailableFontFamilyNames();
        Vector<String> vector = new Vector<String>();
        int i = 1;
        while (i < envfonts.length) {
            vector.addElement(envfonts[i]);
            ++i;
        }
        this.fonts = new JComboBox(vector);
        this.fonts.setMaximumRowCount(9);
        this.fonts.addItemListener(this);
        this.fontchoice = this.getFont().getFontName();
        this.fonts.setSelectedItem(this.getFont().getFontName());
        fontPanel.add(this.fonts);
        this.sizes = new JComboBox<Object>(new Object[]{"10", "12", "14", "18", "24", "48"});
        this.sizes.setMaximumRowCount(9);
        this.sizes.addItemListener(this);
        this.sizes.setEditable(true);
        this.sizes.setSelectedItem(new Integer(this.getFont().getSize()));
        sizePanel.add(this.sizes);
        this.styles = new JComboBox<Object>(new Object[]{"PLAIN", "BOLD", "ITALIC", "BOLD & ITALIC"});
        this.styles.setMaximumRowCount(9);
        this.styles.addItemListener(this);
        this.sizes.setMaximumRowCount(9);
        stylePanel.add(this.styles);
        this.fontC = new FontPanel();
        this.fontC.setBackground(Color.white);
        this.getContentPane().add("Center", this.fontC);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        Object list = e.getSource();
        if (list == this.fonts) {
            this.fontchoice = (String)this.fonts.getSelectedItem();
        } else if (list == this.styles) {
            this.stChoice = this.index = this.styles.getSelectedIndex();
        } else {
            this.siChoice = (String)this.sizes.getSelectedItem();
        }
        this.fontC.changeFont(this.fontchoice, this.stChoice, this.siChoice);
    }

    public FontSelectionDialog() {
        this.setSize(550, 250);
        this.init();
        this.init2();
    }

    void init2() {
        JPanel bottom = new JPanel();
        this.getContentPane().add((Component)bottom, "South");
        JButton ok = new JButton("OK");
        JButton cancel = new JButton("Cancel");
        bottom.add(ok);
        bottom.add(cancel);
        ok.addActionListener(this);
        cancel.addActionListener(this);
        this.setModal(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK")) {
            this.setFont(this.fontC.thisFont);
            this.OK_PRESSED = true;
            this.hide();
        } else if (e.getActionCommand().equals("Cancel")) {
            this.hide();
        }
    }
}

