/*
 * Decompiled with CFR 0.152.
 */
package piano;

import evaluator.Expression;
import evaluator.MathException;
import evaluator.ObjectPath;
import evaluator.StackException;
import evaluator.Variable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import piano.TimbreEditorPane;

public class TimbrePanel
extends JPanel {
    TimbreEditorPane editor = new TimbreEditorPane();
    int SAMPLE_RATE = 22050;
    int SAMPLE_BITS = 16;
    boolean SIGNED = true;
    boolean BIGENDIAN = false;
    double A440 = 440.0;
    Mixer mix;
    Clip[] currentNotes = new Clip[128];
    private boolean silent;
    private JPanel frequencyeditor;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        TimbrePanel tp = new TimbrePanel();
        JFrame f = new JFrame();
        JButton button = new JButton("Test");
        f.getContentPane().add((Component)tp, "Center");
        f.getContentPane().add((Component)button, "South");
        button.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TimbrePanel.this.noteOn(64, 64);
            }

            public void mouseReleased(MouseEvent e) {
                TimbrePanel.this.noteOff(64);
            }
        });
        f.pack();
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
    }

    public TimbrePanel() {
        this.mix = AudioSystem.getMixer(AudioSystem.getMixerInfo()[0]);
        this.setLayout(new BorderLayout());
        this.add((Component)this.editor, "Center");
        Object[] objectArray = new Object[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Math");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[0] = clazz;
        ObjectPath.setRoot(objectArray);
    }

    protected void noteOn(int pitch, int volume) {
        if (this.currentNotes[pitch] != null) {
            this.noteOff(pitch);
        }
        byte[] pBuffer = null;
        try {
            pBuffer = this.createNote((int)pitch, (double)2.0, (TimbreEditorPane.Harmonic[])this.editor.getHarmonics()).wave;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Unable to produce note because of " + e);
            e.printStackTrace();
            return;
        }
        try {
            this.currentNotes[pitch] = (Clip)this.mix.getLine(this.mix.getSourceLineInfo(new Line.Info(Class.forName("javax.sound.sampled.Clip")))[0]);
            AudioFormat af = new AudioFormat(this.SAMPLE_RATE, this.SAMPLE_BITS, 1, this.SIGNED, this.BIGENDIAN);
            this.currentNotes[pitch].open(af, pBuffer, 0, pBuffer.length);
            this.currentNotes[pitch].loop(-1);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.silent = true;
        }
    }

    protected void noteOff(int pitch) {
        if (this.currentNotes[pitch] != null) {
            if (this.currentNotes[pitch].isActive()) {
                this.currentNotes[pitch].stop();
            }
            if (this.currentNotes[pitch].isOpen()) {
                this.currentNotes[pitch].close();
            }
            this.currentNotes[pitch] = null;
        }
    }

    byte[] createNote(int pitch, double duration) {
        int sbytes = this.SAMPLE_BITS / 8;
        byte[] d = new byte[(int)(duration * (double)this.SAMPLE_RATE * (double)sbytes)];
        double f0 = this.A440 * Math.pow(2.0, (double)(pitch - 64) / 12.0);
        int i = 0;
        while (i < d.length) {
            double y = 0.5 * Math.sin((double)(i / sbytes * 2) * Math.PI * f0 / (double)this.SAMPLE_RATE);
            if (this.SAMPLE_BITS == 16) {
                short s = (short)(32767.0 * y);
                d[i] = (byte)s;
                d[i + 1] = (byte)(s >>> 8);
            } else {
                d[i] = (byte)(127.0 * y);
            }
            i += sbytes;
        }
        return d;
    }

    NoteData createNote(int pitch, double duration, TimbreEditorPane.Harmonic[] h) throws MathException, StackException {
        int sbytes = this.SAMPLE_BITS / 8;
        int nsamples = (int)(duration * (double)this.SAMPLE_RATE);
        double delta = 1.0E-6;
        byte[] d = new byte[nsamples * sbytes];
        double[][] y = new double[h.length][nsamples];
        double[] yt = new double[nsamples];
        double[] ftt = new double[nsamples];
        double f0 = this.A440 * Math.pow(2.0, (double)(pitch - 64) / 12.0);
        int i = 0;
        while (i < h.length) {
            Expression f = new Expression(h[i].frequency);
            Expression a = new Expression(h[i].amplitude);
            double phi = h[i].phase;
            double dt = 1.0 / (double)this.SAMPLE_RATE;
            double t = 0.0;
            int j = 1;
            while (j < nsamples) {
                t = (double)j * dt;
                double at = this.value(a, f0, t);
                double dadt = (this.value(a, f0, t + delta) - at) / delta;
                double ft = this.value(f, f0, t);
                double dfdt = (this.value(f, f0, t + delta) - ft) / delta;
                double pi = Math.PI;
                double dydt = dadt * Math.sin(2.0 * pi * ft * t + phi) + at * Math.cos(2.0 * pi * ft * t + phi) * 2.0 * pi * (dfdt * t + ft);
                ftt[j] = ft;
                y[i][j] = y[i][j - 1] + dydt * dt;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nsamples) {
            int j = 0;
            while (j < h.length) {
                int n = i;
                yt[n] = yt[n] + y[j][i] * h[j].magnitude;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nsamples) {
            double v = 0.2 * yt[i] / (double)h.length;
            if (this.SAMPLE_BITS == 16) {
                short s = (short)(32767.0 * v);
                d[i * sbytes] = (byte)s;
                d[i * sbytes + 1] = (byte)(s >>> 8);
            } else {
                d[i] = (byte)(127.0 * v);
            }
            ++i;
        }
        NoteData nd = new NoteData();
        nd.wave = d;
        nd.y = y;
        return nd;
    }

    double value(Expression e, double x, double t) throws MathException, StackException {
        Variable.set("t", new Double(t));
        Variable.set("x", new Double(x));
        return e.value();
    }

    public void finalize() throws Throwable {
        int i = 0;
        while (i < this.currentNotes.length) {
            if (this.currentNotes[i] != null) {
                this.noteOff(i);
            }
            ++i;
        }
        this.mix.close();
    }

    class NoteData {
        byte[] wave;
        double[][] y;

        NoteData() {
        }
    }
}

