/*
 * Decompiled with CFR 0.152.
 */
package piano;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TimbreEditorPane
extends JPanel {
    private JPanel freqlistpanel;
    private JPanel editfreqpane;
    private JLabel flabel;
    private JButton pastebutton;
    private JButton copybutton;
    private JButton savebutton;
    private JButton loadbutton;
    private JButton removebutton;
    private JButton newbutton;
    private JPanel jPanel1;
    private JTextArea infotext;
    private JList freqlist;
    private JScrollPane freqlistscroll;
    private JSlider phaseslider;
    private JLabel phlabel;
    private JButton updatebutton;
    private JTextField atext;
    private JLabel alabel;
    private JTextField ftext;
    private DefaultComboBoxModel freqlistModel = new DefaultComboBoxModel();
    Vector harmonics = new Vector();
    Harmonic currentlyEdited = null;
    Action newaction = new AbstractAction("New"){

        public void actionPerformed(ActionEvent e) {
            Harmonic c;
            if (TimbreEditorPane.this.currentlyEdited != null) {
                TimbreEditorPane.this.updateHarmonic();
            }
            TimbreEditorPane.this.currentlyEdited = c = new Harmonic();
            c.n = TimbreEditorPane.this.harmonics.size();
            c.frequency = String.valueOf(c.n + 1) + " * x";
            TimbreEditorPane.this.harmonics.add(c);
            TimbreEditorPane.this.updateList();
            TimbreEditorPane.this.updateEditor();
        }
    };
    private JCheckBox solocheck;
    private JSlider amplslider;
    Action removeaction = new AbstractAction("Remove"){

        public void actionPerformed(ActionEvent e) {
            if (TimbreEditorPane.this.currentlyEdited != null && TimbreEditorPane.this.currentlyEdited.n > 0) {
                TimbreEditorPane.this.harmonics.remove(TimbreEditorPane.this.currentlyEdited);
                TimbreEditorPane.this.currentlyEdited = null;
                TimbreEditorPane.this.updateList();
                TimbreEditorPane.this.updateEditor();
            }
        }
    };
    Action copyaction = new AbstractAction("Copy"){

        public void actionPerformed(ActionEvent e) {
            StringSelection ss = new StringSelection(TimbreEditorPane.this.harmonicsToText());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
        }
    };
    Action pasteaction = new AbstractAction("Paste"){

        public void actionPerformed(ActionEvent e) {
            try {
                String s = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                Vector v = TimbreEditorPane.this.harmonicsFromText(s);
                if (v.size() > 0 && JOptionPane.showConfirmDialog(TimbreEditorPane.this, "Replace current timbre with " + v.size() + " pasted harmonics?", "Paste?", 2) == 0) {
                    TimbreEditorPane.this.harmonics = v;
                    TimbreEditorPane.this.currentlyEdited = (Harmonic)v.get(0);
                    TimbreEditorPane.this.updateList();
                    TimbreEditorPane.this.updateEditor();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
                JOptionPane.showMessageDialog(TimbreEditorPane.this, "Clipboard data not suitable.");
            }
        }
    };
    FocusListener focuslistener = new FocusAdapter(){

        public void focusLost(FocusEvent e) {
            TimbreEditorPane.this.updateHarmonic();
        }
    };

    public TimbreEditorPane() {
        Harmonic f0 = new Harmonic();
        this.harmonics.add(f0);
        this.initGUI();
        this.currentlyEdited = f0;
        this.updateList();
        this.updateEditor();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            this.setPreferredSize(new Dimension(434, 226));
            this.freqlistpanel = new JPanel();
            BorderLayout freqlistpanelLayout = new BorderLayout();
            this.freqlistpanel.setLayout(freqlistpanelLayout);
            BorderLayout editfreqpaneLayout = new BorderLayout();
            this.add((Component)this.freqlistpanel, "West");
            this.freqlistscroll = new JScrollPane();
            this.freqlistpanel.add((Component)this.freqlistscroll, "Center");
            this.freqlist = new JList();
            this.freqlistscroll.setViewportView(this.freqlist);
            this.freqlist.setModel(this.freqlistModel);
            this.freqlist.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent evt) {
                    TimbreEditorPane.this.updateHarmonic();
                    TimbreEditorPane.this.currentlyEdited = (Harmonic)TimbreEditorPane.this.freqlist.getSelectedValue();
                    TimbreEditorPane.this.updateEditor();
                }
            });
            this.freqlistpanel.setLayout(freqlistpanelLayout);
            this.freqlistpanel.setPreferredSize(new Dimension(151, 226));
            this.editfreqpane = new JPanel();
            this.add((Component)this.editfreqpane, "Center");
            GridBagLayout editfreqpaneLayout1 = new GridBagLayout();
            this.editfreqpane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Edit harmonic", 4, 2));
            editfreqpaneLayout1.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            editfreqpaneLayout1.rowHeights = new int[]{7, 7, 7, 20};
            editfreqpaneLayout1.columnWeights = new double[]{0.1, 0.1, 0.1, 0.0, 0.1, 0.1};
            editfreqpaneLayout1.columnWidths = new int[]{7, 7, 7, -1, 20, 20};
            this.editfreqpane.setLayout(editfreqpaneLayout1);
            this.editfreqpane.setLayout(editfreqpaneLayout1);
            this.editfreqpane.setPreferredSize(new Dimension(205, 226));
            this.flabel = new JLabel();
            this.editfreqpane.add((Component)this.flabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.flabel.setText("f=");
            this.ftext = new JTextField();
            this.editfreqpane.add((Component)this.ftext, new GridBagConstraints(1, 0, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.ftext.addFocusListener(this.focuslistener);
            this.ftext.setText("x");
            this.alabel = new JLabel();
            this.editfreqpane.add((Component)this.alabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.alabel.setText("a=");
            this.atext = new JTextField();
            this.editfreqpane.add((Component)this.atext, new GridBagConstraints(1, 1, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.atext.addInputMethodListener(new InputMethodListener(){

                public void inputMethodTextChanged(InputMethodEvent evt) {
                    TimbreEditorPane.this.updateHarmonic();
                }

                public void caretPositionChanged(InputMethodEvent event) {
                }
            });
            this.atext.addFocusListener(this.focuslistener);
            this.atext.setText("1");
            this.updatebutton = new JButton();
            this.editfreqpane.add((Component)this.updatebutton, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.updatebutton.setText("Update");
            this.phlabel = new JLabel();
            this.editfreqpane.add((Component)this.phlabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.phlabel.setText("Phase");
            this.phaseslider = new JSlider();
            this.editfreqpane.add((Component)this.phaseslider, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.phaseslider.addFocusListener(this.focuslistener);
            this.infotext = new JTextArea();
            this.editfreqpane.add((Component)this.infotext, new GridBagConstraints(0, 3, 6, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.infotext.setText("You can specify the frequency and amplitude as a function of the fundamental frequency 'x' and the time in seconds 't'");
            this.infotext.setEditable(false);
            this.infotext.setWrapStyleWord(true);
            this.infotext.setLineWrap(true);
            this.infotext.setFont(new Font("Monospaced", 0, 10));
            this.amplslider = new JSlider();
            this.editfreqpane.add((Component)this.amplslider, new GridBagConstraints(5, 0, 1, 3, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.amplslider.setOrientation(1);
            this.amplslider.setValue(100);
            this.amplslider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent evt) {
                    TimbreEditorPane.this.updateHarmonic();
                }
            });
            this.amplslider.addFocusListener(this.focuslistener);
            this.solocheck = new JCheckBox();
            this.editfreqpane.add((Component)this.solocheck, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.solocheck.setText("Solo");
            this.jPanel1 = new JPanel();
            GridLayout jPanel1Layout = new GridLayout(6, 1);
            jPanel1Layout.setColumns(1);
            jPanel1Layout.setHgap(5);
            jPanel1Layout.setVgap(5);
            jPanel1Layout.setRows(6);
            this.jPanel1.setLayout(jPanel1Layout);
            this.add((Component)this.jPanel1, "East");
            this.newbutton = new JButton();
            this.jPanel1.add(this.newbutton);
            this.newbutton.setText("New");
            this.newbutton.addActionListener(this.newaction);
            this.removebutton = new JButton();
            this.jPanel1.add(this.removebutton);
            this.removebutton.setText("Remove");
            this.removebutton.addActionListener(this.removeaction);
            this.loadbutton = new JButton();
            this.jPanel1.add(this.loadbutton);
            this.loadbutton.setText("Load");
            this.savebutton = new JButton();
            this.jPanel1.add(this.savebutton);
            this.savebutton.setText("Save");
            this.pastebutton = new JButton();
            this.jPanel1.add(this.pastebutton);
            this.pastebutton.setText("Paste");
            this.pastebutton.addActionListener(this.pasteaction);
            this.copybutton = new JButton();
            this.jPanel1.add(this.copybutton);
            this.copybutton.setText("Copy");
            this.copybutton.addActionListener(this.copyaction);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    String harmonicsToText() {
        StringBuffer b = new StringBuffer();
        b.append("{\n");
        int i = 0;
        while (i < this.harmonics.size()) {
            Harmonic h = (Harmonic)this.harmonics.get(i);
            b.append('\t');
            b.append(h.n);
            b.append('{');
            b.append("f=");
            b.append(h.frequency);
            b.append(";a=");
            b.append(h.amplitude);
            b.append(";p=");
            b.append(h.phase);
            b.append(";m=");
            b.append(h.magnitude);
            b.append(";}\n");
            ++i;
        }
        b.append('}');
        return b.toString();
    }

    /*
     * Unable to fully structure code
     */
    Vector harmonicsFromText(String s) throws StringIndexOutOfBoundsException {
        pos = 0;
        v = new Vector<Harmonic>();
        while (pos < s.length() && s.charAt(pos) != '}') {
            h = new Harmonic();
            while (!Character.isDigit(s.charAt(pos))) {
                ++pos;
            }
            i = 0;
            while (Character.isDigit(s.charAt(pos))) {
                i = i * 10 + Integer.parseInt(Character.toString(s.charAt(pos)));
                ++pos;
            }
            h.n = i;
            while (s.charAt(pos) != '{') {
                ++pos;
            }
            ++pos;
            ** GOTO lbl45
            {
                ++pos;
                do {
                    if (Character.isWhitespace(s.charAt(pos))) continue block4;
                    startprop = pos;
                    while (s.charAt(pos) != '=') {
                        ++pos;
                    }
                    endprop = pos;
                    propname = s.substring(startprop, endprop).trim();
                    while (s.charAt(pos) != ';') {
                        ++pos;
                    }
                    endval = pos;
                    propval = s.substring(endprop + 1, endval).trim();
                    if (propname.equalsIgnoreCase("f")) {
                        h.frequency = propval;
                    }
                    if (propname.equalsIgnoreCase("a")) {
                        h.amplitude = propval;
                    }
                    if (propname.equalsIgnoreCase("p")) {
                        h.phase = Double.parseDouble(propval);
                    }
                    if (propname.equalsIgnoreCase("m")) {
                        h.magnitude = Double.parseDouble(propval);
                    }
                    ++pos;
                    while (Character.isWhitespace(s.charAt(pos))) {
                        ++pos;
                    }
lbl45:
                    // 2 sources

                } while (s.charAt(pos) != '}');
            }
            ++pos;
            while (Character.isWhitespace(s.charAt(pos))) {
                ++pos;
            }
            v.add(h);
        }
        return v;
    }

    protected void updateList() {
        this.freqlistModel.removeAllElements();
        int i = 0;
        while (i < this.harmonics.size()) {
            Harmonic h = (Harmonic)this.harmonics.get(i);
            h.n = i++;
            this.freqlistModel.addElement(h);
        }
        if (this.currentlyEdited != null) {
            this.freqlist.setSelectedValue(this.currentlyEdited, true);
        }
    }

    protected void updateHarmonic() {
        if (this.currentlyEdited != null) {
            this.currentlyEdited.frequency = this.ftext.getText();
            this.currentlyEdited.amplitude = this.atext.getText();
            this.currentlyEdited.phase = Math.PI * 2 * (double)this.phaseslider.getValue() / (double)this.phaseslider.getMaximum();
            this.currentlyEdited.magnitude = (double)this.amplslider.getValue() / (double)this.amplslider.getMaximum();
        }
    }

    protected void updateEditor() {
        boolean enab = this.currentlyEdited != null;
        this.ftext.setEditable(enab);
        this.phaseslider.setEnabled(enab);
        if (this.currentlyEdited == null) {
            this.ftext.setText("");
            this.atext.setText("");
            this.phaseslider.setValue(0);
        } else {
            this.ftext.setText(this.currentlyEdited.frequency);
            this.atext.setText(this.currentlyEdited.amplitude);
            this.phaseslider.setValue((int)(this.currentlyEdited.phase / 2.0 / Math.PI * (double)this.phaseslider.getMaximum()));
            this.amplslider.setValue((int)((double)this.amplslider.getMaximum() * this.currentlyEdited.magnitude));
        }
    }

    public Harmonic[] getHarmonics() {
        if (this.solocheck.isSelected()) {
            return new Harmonic[]{this.currentlyEdited};
        }
        Harmonic[] h = new Harmonic[this.harmonics.size()];
        return this.harmonics.toArray(h);
    }

    class Harmonic {
        int n = 0;
        String frequency = "x";
        String amplitude = "1";
        double phase = 0.0;
        double magnitude = 1.0;

        Harmonic() {
        }

        public String toString() {
            return "f" + this.n + ": f=" + this.frequency;
        }
    }
}

