/*
 * Decompiled with CFR 0.152.
 */
package piano;

import evaluator.EvaluatorConsole;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import piano.ChordSequencePanel;
import piano.NoteEvent;
import piano.NoteListener;
import piano.PianoPanel;
import piano.Thoughts;

public class SequencerPanel
extends JPanel
implements NoteListener,
MetaEventListener {
    Thoughts thoughts = new Thoughts(this);
    String permFile = "c:\\history.mid";
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JToggleButton playbutton = new JToggleButton();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList jList1 = new JList();
    BorderLayout borderLayout2 = new BorderLayout();
    DefaultListModel sequencelistmodel = new DefaultListModel();
    JButton ffbutton = new JButton();
    JButton sfbutton = new JButton();
    JPanel jPanel3 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel4 = new JPanel();
    JSlider jSlider1 = new JSlider();
    JPopupMenu popupMenu1 = new JPopupMenu();
    JMenuItem expmidimenu = new JMenuItem();
    PianoPanel piano;
    EvaluatorConsole econsole;
    Transmitter seqTransmitter;
    Receiver myReceiver = new Receiver(){

        public void close() {
        }

        public void send(MidiMessage message, long timeStamp) {
            if (message instanceof ShortMessage) {
                ShortMessage msg = (ShortMessage)message;
                if (msg.getCommand() == 144) {
                    int key = msg.getData1();
                    SequencerPanel.this.piano.keyDown(key, msg.getData2(), false);
                    SequencerPanel.this.piano.isHeld[key] = true;
                    SequencerPanel.this.piano.repaint();
                } else if (msg.getCommand() == 128) {
                    int key = msg.getData1();
                    SequencerPanel.this.piano.keyUp(key, false);
                    SequencerPanel.this.piano.isHeld[key] = false;
                    SequencerPanel.this.piano.repaint();
                }
            }
        }
    };
    Vector clips = new Vector();
    Clip current = null;
    ChordSequencePanel chordSequencePanel;
    boolean isPlaying = false;
    int MAX_NOTES = 65536000;
    int MAX_CLIPS = 65536;
    long SPLIT_TRACK_THRESHOLD_MS = 850L;
    int TICKS_PER_CROTCHET = 96;
    int recordTempo = 100;
    long recordTimeMillis = 0L;
    long lastEventMillis = 0L;
    Sequencer sequencer;
    Action playAction = new PlayAction("Play", 1.0f);
    Action slowForward = new PlayAction("SF", 0.25f);
    Action fastForward = new PlayAction("FF", 6.0f);
    Timer autoAdjustSlider = new Timer(200, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (SequencerPanel.this.isPlaying) {
                SequencerPanel.this.grabSequencerPos();
            }
        }
    });
    ClipRenderer clipRenderer = new ClipRenderer();
    boolean sftemp;
    ListMouseListener listMouseListener = new ListMouseListener();
    AbstractAction deleteClip = new AbstractAction("Delete"){

        public void actionPerformed(ActionEvent e) {
            Clip c = (Clip)SequencerPanel.this.jList1.getSelectedValue();
            if (c != null) {
                SequencerPanel.this.clips.remove(c);
            }
            SequencerPanel.this.updateList();
        }
    };
    JFileChooser fc = new JFileChooser();
    AbstractAction importClip = new AbstractAction("Import MIDI"){

        public void actionPerformed(ActionEvent e) {
            try {
                Clip c = new Clip();
                InputStream is = SequencerPanel.this.getOpenFile();
                c.sequence = MidiSystem.getSequence(is);
                is.close();
                c.name = "file" + is.hashCode();
                c.track = c.sequence.getTracks()[0];
                SequencerPanel.this.clips.add(c);
                SequencerPanel.this.updateList();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    };
    AbstractAction appendBelow = new AbstractAction("Append next item"){

        public void actionPerformed(ActionEvent e) {
            int i = SequencerPanel.this.jList1.getSelectedIndex();
            Clip c1 = (Clip)SequencerPanel.this.jList1.getModel().getElementAt(i);
            Clip c2 = (Clip)SequencerPanel.this.jList1.getModel().getElementAt(i + 1);
            long delay = c1.track.ticks();
            int j = 0;
            while (j < c2.track.size()) {
                c1.track.add(new MidiEvent(c2.track.get(j).getMessage(), c2.track.get(j).getTick() + delay));
                ++j;
            }
            SequencerPanel.this.clips.remove(c2);
            SequencerPanel.this.updateList();
        }
    };
    AbstractAction splitTrack = new AbstractAction("Split"){

        public void actionPerformed(ActionEvent e) {
            Clip c = (Clip)SequencerPanel.this.jList1.getSelectedValue();
            Clip c2 = new Clip();
            try {
                c2.sequence = new Sequence(0.0f, SequencerPanel.this.TICKS_PER_CROTCHET);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            c2.track = c2.sequence.createTrack();
            long threshTick = c.tkpos;
            boolean[] noteOn = new boolean[256];
            int i = 0;
            while (i < c.track.size()) {
                MidiEvent ev = c.track.get(i);
                if (ev.getTick() > threshTick) {
                    c2.track.add(new MidiEvent(ev.getMessage(), ev.getTick() - threshTick));
                    c.track.remove(ev);
                    --i;
                }
                ++i;
            }
            if (c2.sequence.getTickLength() > 0L) {
                SequencerPanel.this.clips.add(c2);
            }
            if (c.sequence.getTickLength() < 1L) {
                SequencerPanel.this.clips.remove(c);
            }
            SequencerPanel.this.updateList();
        }
    };
    AbstractAction mergeBelow = new AbstractAction("Merge next item"){

        public void actionPerformed(ActionEvent e) {
            int i = SequencerPanel.this.jList1.getSelectedIndex();
            Clip c1 = (Clip)SequencerPanel.this.jList1.getModel().getElementAt(i);
            Clip c2 = (Clip)SequencerPanel.this.jList1.getModel().getElementAt(i + 1);
            int j = 0;
            while (j < c2.track.size()) {
                c1.track.add(c2.track.get(j));
                ++j;
            }
            SequencerPanel.this.clips.remove(c2);
            SequencerPanel.this.updateList();
        }
    };
    AbstractAction saveAll = new AbstractAction("Export all"){

        public void actionPerformed(ActionEvent e) {
            try {
                OutputStream os = SequencerPanel.this.getSaveFile();
                SequencerPanel.this.doSaveAllTracks(os);
                os.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    };
    AbstractAction loadAll = new AbstractAction("Import all"){

        public void actionPerformed(ActionEvent e) {
            try {
                InputStream is = SequencerPanel.this.getOpenFile();
                Sequence all = MidiSystem.getSequence(is);
                is.close();
                SequencerPanel.this.doLoadAllTracks(all);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    };
    JPanel jPanel5 = new JPanel();
    JLabel notecount = new JLabel();

    public SequencerPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.sequencer = MidiSystem.getSequencer();
            this.seqTransmitter = this.sequencer.getTransmitter();
            this.seqTransmitter.setReceiver(this.myReceiver);
        }
        catch (MidiUnavailableException ex) {
            ex.printStackTrace();
        }
        this.sequencer.addMetaEventListener(this);
        this.jList1.setCellRenderer(this.clipRenderer);
        this.jList1.addMouseListener(this.listMouseListener);
        this.jList1.addMouseMotionListener(this.listMouseListener);
    }

    public void shutdown() {
        this.seqTransmitter.close();
        if (this.permFile != null) {
            try {
                FileOutputStream fos = new FileOutputStream(this.permFile);
                this.doSaveAllTracks(fos);
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void noteOff(NoteEvent e) {
        if (!this.isPlaying) {
            this.storeNote(e);
        }
    }

    public void noteOn(NoteEvent e) {
        if (!this.isPlaying) {
            this.storeNote(e);
        }
    }

    void storeNote(NoteEvent e) {
        int N = this.totalNotes();
        if (this.current == null || this.splitSequence(e)) {
            if (this.current != null && (this.current.track.ticks() < 10L || this.current.track.size() < 7)) {
                this.clips.remove(this.current);
            }
            this.current = new Clip();
            try {
                this.current.sequence = new Sequence(0.0f, this.TICKS_PER_CROTCHET);
            }
            catch (InvalidMidiDataException ex) {
                ex.printStackTrace();
            }
            this.current.startRecTime = System.currentTimeMillis();
            this.current.track = this.current.sequence.createTrack();
            this.clips.add(this.current);
            if (N > this.MAX_NOTES || this.clips.size() > this.MAX_CLIPS) {
                this.clips.remove(0);
            }
            this.recordTimeMillis = e.createTime;
            int oi = this.jList1.getSelectedIndex();
            this.updateList();
            int sz = this.sequencelistmodel.getSize();
            if (oi == sz - 2 || oi < 1) {
                this.jList1.setSelectedIndex(sz - 1);
                this.jList1.scrollRectToVisible(this.jList1.getCellBounds(sz - 1, sz - 1));
            }
        }
        this.recordTempo = this.chordSequencePanel.getSong().tempo;
        ShortMessage m = new ShortMessage();
        try {
            m.setMessage(e.on ? 144 : 128, 0, e.note, e.vel);
        }
        catch (InvalidMidiDataException ex1) {
            ex1.printStackTrace();
        }
        this.current.track.add(new MidiEvent(m, (e.createTime - this.recordTimeMillis) * (long)this.recordTempo * (long)this.TICKS_PER_CROTCHET / 60000L));
        this.lastEventMillis = e.createTime;
        int sz = this.sequencelistmodel.getSize();
        if (this.current.track.size() < 800) {
            this.jList1.repaint(this.jList1.getCellBounds(sz - 1, sz - 1));
        }
        this.setNoteCount(N);
    }

    public void setNoteCount(int N) {
        this.notecount.setText(String.valueOf(N) + "/" + this.MAX_NOTES);
    }

    int totalNotes() {
        int n = 0;
        int i = 0;
        while (i < this.clips.size()) {
            n += ((Clip)this.clips.get((int)i)).track.size();
            ++i;
        }
        return n;
    }

    public boolean splitSequence(NoteEvent e) {
        int[] n;
        return e.on && e.createTime - this.lastEventMillis > this.SPLIT_TRACK_THRESHOLD_MS && ((n = this.piano.getCurrentNotes()).length == 0 || n.length == 1 && n[0] == e.note);
    }

    public void addNotify() {
        block16: {
            if (this.piano != null) {
                this.piano.addNoteListener(this);
            }
            FileInputStream fis = null;
            if (this.permFile != null) {
                try {
                    try {
                        fis = new FileInputStream(this.permFile);
                        this.doLoadAllTracks(MidiSystem.getSequence(fis));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.setNoteCount(this.totalNotes());
        super.addNotify();
    }

    public void removeNotify() {
        if (this.piano != null) {
            this.piano.removeNoteListener(this);
        }
        super.removeNotify();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.playbutton.setAction(this.playAction);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jList1.setModel(this.sequencelistmodel);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                SequencerPanel.this.jList1_valueChanged(e);
            }
        });
        this.ffbutton.setMargin(new Insets(2, 2, 2, 2));
        this.ffbutton.setText("FF");
        this.ffbutton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                SequencerPanel.this.ff_pressed(e);
            }

            public void mouseReleased(MouseEvent e) {
                SequencerPanel.this.ff_released(e);
            }
        });
        this.sfbutton.setMargin(new Insets(2, 2, 2, 2));
        this.sfbutton.setText("SF");
        this.sfbutton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                SequencerPanel.this.sf_pressed(e);
            }

            public void mouseReleased(MouseEvent e) {
                SequencerPanel.this.sf_released(e);
            }
        });
        this.jPanel2.setLayout(this.borderLayout3);
        this.jSlider1.setPaintLabels(true);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.setPaintTrack(true);
        this.jSlider1.setPreferredSize(new Dimension(100, 48));
        this.expmidimenu.setLabel("Export MIDI");
        this.expmidimenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SequencerPanel.this.expmidimenu_actionPerformed(e);
            }
        });
        this.notecount.setText("0/25000");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jList1, null);
        this.add((Component)this.jPanel2, "East");
        this.jPanel2.add((Component)this.jPanel3, "North");
        this.jPanel3.add((Component)this.sfbutton, null);
        this.jPanel3.add((Component)this.playbutton, null);
        this.jPanel3.add((Component)this.ffbutton, null);
        this.jPanel2.add((Component)this.jPanel4, "South");
        this.jPanel4.add((Component)this.jSlider1, null);
        this.jPanel2.add((Component)this.jPanel5, "Center");
        this.jPanel5.add((Component)this.notecount, null);
        this.popupMenu1.add(this.expmidimenu);
        this.jSlider1.setValue(0);
        this.popupMenu1.add(this.importClip);
        this.popupMenu1.add(this.deleteClip);
        this.popupMenu1.add(this.mergeBelow);
        this.popupMenu1.add(this.appendBelow);
        this.popupMenu1.add(this.splitTrack);
        this.popupMenu1.add(this.saveAll);
        this.popupMenu1.add(this.loadAll);
    }

    public void grabSequencerPos() {
        Clip c = (Clip)this.jList1.getSelectedValue();
        if (this.sequencer.getMicrosecondLength() == 0L) {
            return;
        }
        c.tkpos = this.sequencer.getTickPosition();
        this.jSlider1.setValue((int)((long)this.jSlider1.getMaximum() * c.tkpos / c.sequence.getTickLength()));
        this.jList1.repaint();
    }

    public void pushSequencerPos() {
        Clip c = (Clip)this.jList1.getSelectedValue();
        c.tkpos = (long)this.jSlider1.getValue() * c.sequence.getTickLength() / (long)this.jSlider1.getMaximum();
        this.sequencer.setTickPosition(c.tkpos);
    }

    void stopPlaying() {
        this.grabSequencerPos();
        this.isPlaying = false;
        this.sequencer.stop();
        this.sequencer.close();
        this.autoAdjustSlider.stop();
    }

    public void finalize() throws Throwable {
        if (this.sequencer != null) {
            this.sequencer.stop();
            this.sequencer.close();
        }
        super.finalize();
    }

    void updateList() {
        this.sequencelistmodel.clear();
        int i = 0;
        while (i < this.clips.size()) {
            this.sequencelistmodel.addElement(this.clips.get(i));
            ++i;
        }
    }

    public void meta(MetaMessage meta) {
        if (meta.getType() == 47) {
            this.isPlaying = false;
            this.playbutton.setSelected(false);
        }
    }

    void sf_pressed(MouseEvent e) {
        this.sftemp = this.isPlaying;
        this.isPlaying = false;
        this.slowForward.actionPerformed(new ActionEvent(e.getSource(), 0, this.sfbutton.getActionCommand()));
    }

    void sf_released(MouseEvent e) {
        if (this.isPlaying) {
            this.stopPlaying();
            if (this.sftemp) {
                this.playAction.actionPerformed(new ActionEvent(e.getSource(), 0, this.sfbutton.getActionCommand()));
            }
        }
    }

    void ff_pressed(MouseEvent e) {
        this.sftemp = this.isPlaying;
        this.isPlaying = false;
        this.fastForward.actionPerformed(new ActionEvent(e.getSource(), 0, this.ffbutton.getActionCommand()));
    }

    void ff_released(MouseEvent e) {
        this.stopPlaying();
        if (this.sftemp) {
            this.playAction.actionPerformed(new ActionEvent(e.getSource(), 0, this.ffbutton.getActionCommand()));
        }
    }

    void expmidimenu_actionPerformed(ActionEvent e) {
        Clip c = (Clip)this.jList1.getSelectedValue();
        if (c == null) {
            return;
        }
        try {
            OutputStream os = this.getSaveFile();
            MidiSystem.write(c.sequence, MidiSystem.getMidiFileTypes(c.sequence)[0], os);
            os.close();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public InputStream getOpenFile() throws FileNotFoundException {
        this.fc.showOpenDialog(this);
        return new FileInputStream(this.fc.getSelectedFile());
    }

    public OutputStream getSaveFile() throws FileNotFoundException {
        this.fc.showSaveDialog(this);
        return new FileOutputStream(this.fc.getSelectedFile());
    }

    private void doSaveAllTracks(OutputStream os) throws IOException, ArrayIndexOutOfBoundsException, InvalidMidiDataException {
        Sequence all = new Sequence(0.0f, this.TICKS_PER_CROTCHET);
        int i = 0;
        while (i < this.clips.size()) {
            Track t = all.createTrack();
            Clip c = (Clip)this.clips.get(i);
            int j = 0;
            while (j < c.track.size()) {
                if (c.track.get(0).getMessage().getStatus() != 255) {
                    MetaMessage m = new MetaMessage();
                    m.setMessage(4, c.name.getBytes("US-ASCII"), c.name.length());
                    c.track.add(new MidiEvent(m, 0L));
                }
                t.add(c.track.get(j));
                ++j;
            }
            ++i;
        }
        MidiSystem.write(all, MidiSystem.getMidiFileTypes(all)[0], os);
    }

    public void doLoadAllTracks(Sequence all) throws ArrayIndexOutOfBoundsException, InvalidMidiDataException {
        Vector newclips = new Vector();
        Track[] tracks = all.getTracks();
        int i = 0;
        while (i < tracks.length) {
            Sequence s = new Sequence(0.0f, this.TICKS_PER_CROTCHET);
            Track t = s.createTrack();
            int j = 0;
            while (j < tracks[i].size()) {
                t.add(tracks[i].get(j));
                ++j;
            }
            Clip c = new Clip();
            c.sequence = s;
            c.track = t;
            c.startRecTime = System.currentTimeMillis();
            if (t.get(0).getMessage().getStatus() == 255) {
                byte[] d = t.get(0).getMessage().getMessage();
                try {
                    c.name = new String(d, 1, (int)d[0], "US-ASCII");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            } else {
                c.name = "file " + all.hashCode() + " t " + i;
            }
            this.clips.add(c);
            ++i;
        }
        this.updateList();
    }

    void jList1_valueChanged(ListSelectionEvent e) {
        Clip c = (Clip)this.jList1.getSelectedValue();
        if (c == null || c.sequence.getTickLength() == 0L) {
            return;
        }
        this.jSlider1.setValue((int)((long)this.jSlider1.getMaximum() * c.tkpos / c.sequence.getTickLength()));
    }

    class Clip {
        Sequence sequence;
        Track track;
        long startRecTime;
        String name = "";
        long tkpos;
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);

        public Clip() {
            this.startRecTime = System.currentTimeMillis();
            this.name = this.df.format(new Date(this.startRecTime));
        }

        public String millisToString(long x) {
            return String.valueOf(x / 60000L) + ":" + x % 60000L / 1000L;
        }

        public String toString() {
            return String.valueOf(this.name) + " - " + this.millisToString(60000L * this.track.ticks() / (long)SequencerPanel.this.TICKS_PER_CROTCHET / (long)SequencerPanel.this.recordTempo);
        }
    }

    class ClipRenderer
    extends JPanel
    implements ListCellRenderer {
        Clip clip;
        JLabel label = new JLabel();
        JPanel pic = new JPanel(this){
            final /* synthetic */ ClipRenderer this$1;
            {
                this.this$1 = clipRenderer;
            }

            public void paint(Graphics g) {
                super.paint(g);
                int[] startOfNote = new int[128];
                long tlen = this.this$1.clip.track.ticks();
                if (tlen == 0L) {
                    return;
                }
                int nevents = Math.min(this.this$1.clip.track.size(), 5000);
                int i = 0;
                while (i < nevents) {
                    MidiEvent e = this.this$1.clip.track.get(i);
                    MidiMessage m = e.getMessage();
                    if (m instanceof ShortMessage) {
                        byte[] msg = m.getMessage();
                        int nx = (int)(e.getTick() * (long)this.getWidth() / tlen);
                        int ny = this.getHeight() - msg[1] * this.getHeight() / 128;
                        if (msg[0] == -112) {
                            startOfNote[msg[1]] = nx;
                        }
                        if (msg[0] == -128) {
                            g.drawLine(startOfNote[msg[1]], ny, nx, ny);
                        }
                    }
                    ++i;
                }
                g.setColor(Color.red);
                int hp = (int)((long)this.getWidth() * this.this$1.clip.tkpos / this.this$1.clip.sequence.getTickLength());
                g.drawLine(hp, 0, hp, this.getHeight());
            }
        };

        public ClipRenderer() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.label, "West");
            this.label.setPreferredSize(new Dimension(140, 20));
            this.add((Component)this.pic, "Center");
            this.pic.setOpaque(false);
            this.setPreferredSize(new Dimension(200, 30));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.clip = (Clip)value;
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.label.setText(this.clip.toString());
            return this;
        }
    }

    class ListMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        Clip clp;
        boolean dragleft = false;

        ListMouseListener() {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                SequencerPanel.this.jList1.setSelectedIndex(SequencerPanel.this.jList1.locationToIndex(e.getPoint()));
                boolean isnext = SequencerPanel.this.jList1.getSelectedIndex() < SequencerPanel.this.jList1.getModel().getSize() - 1;
                SequencerPanel.this.mergeBelow.setEnabled(isnext);
                SequencerPanel.this.appendBelow.setEnabled(isnext);
                SequencerPanel.this.popupMenu1.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
            this.dragleft = e.getButton() == 1;
            if (this.dragleft) {
                this.updatePos(e);
            }
        }

        public void updatePos(MouseEvent e) {
            this.clp = (Clip)SequencerPanel.this.jList1.getSelectedValue();
            if (this.clp == null) {
                return;
            }
            if (this.clp.sequence.getTickLength() == 0L) {
                return;
            }
            ClipRenderer cr = (ClipRenderer)SequencerPanel.this.jList1.getCellRenderer();
            int px = e.getX() - cr.pic.getX();
            if (this.clp != null && px > 0) {
                this.clp.tkpos = this.clp.sequence.getTickLength() * (long)px / (long)cr.pic.getWidth();
                SequencerPanel.this.jList1.repaint();
                SequencerPanel.this.jSlider1.setValue((int)((long)SequencerPanel.this.jSlider1.getMaximum() * this.clp.tkpos / this.clp.sequence.getTickLength()));
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.dragleft) {
                this.updatePos(e);
            }
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    class PlayAction
    extends AbstractAction {
        float speed = 1.0f;

        public PlayAction(String name, float speed) {
            super(name);
            this.speed = speed;
        }

        public void actionPerformed(ActionEvent e) {
            if (SequencerPanel.this.isPlaying) {
                SequencerPanel.this.stopPlaying();
                SequencerPanel.this.playbutton.setSelected(false);
            } else {
                Object o = SequencerPanel.this.jList1.getSelectedValue();
                if (o instanceof Clip) {
                    Clip c = (Clip)o;
                    try {
                        SequencerPanel.this.sequencer.open();
                        SequencerPanel.this.sequencer.setMasterSyncMode(Sequencer.SyncMode.INTERNAL_CLOCK);
                        Cursor oldCursor = SequencerPanel.this.getCursor();
                        SequencerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                        SequencerPanel.this.sequencer.setSequence(c.sequence);
                        SequencerPanel.this.setCursor(oldCursor);
                        SequencerPanel.this.sequencer.start();
                        SequencerPanel.this.sequencer.setTempoInBPM(SequencerPanel.this.chordSequencePanel.getSong().tempo);
                        SequencerPanel.this.sequencer.setTempoFactor(this.speed);
                        SequencerPanel.this.pushSequencerPos();
                        if (SequencerPanel.this.sequencer.getMicrosecondLength() - SequencerPanel.this.sequencer.getMicrosecondPosition() < 500000L) {
                            SequencerPanel.this.sequencer.setMicrosecondPosition(0L);
                        }
                        SequencerPanel.this.isPlaying = true;
                        SequencerPanel.this.autoAdjustSlider.start();
                    }
                    catch (MidiUnavailableException ex) {
                        ex.printStackTrace();
                    }
                    catch (InvalidMidiDataException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
        }
    }
}

