/*
 * Decompiled with CFR 0.152.
 */
package piano;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import piano.AudioListenPanel;
import piano.ExtSynth;
import piano.ExternalPlayer;
import piano.PianoApp;
import piano.PianoPanel;
import piano.SelectMidiDialog_jButton1_actionAdapter;

public class SelectMidiDialog
extends JDialog {
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JComboBox inputCombo = new JComboBox();
    JLabel jLabel2 = new JLabel();
    JComboBox outputcombo = new JComboBox();
    DefaultComboBoxModel inputmodel = new DefaultComboBoxModel();
    DefaultComboBoxModel outputmodel = new DefaultComboBoxModel();
    JPanel jPanel3 = new JPanel();
    JButton jButton1 = new JButton();
    Vector tx = new Vector();
    Vector rx = new Vector();
    Vector au = new Vector();
    AudioListenPanel audiolistenpanel;
    ExternalPlayer externalDevice;
    PianoPanel piano;
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel5 = new JPanel();
    JLabel jLabel3 = new JLabel();
    JComboBox audioinlist = new JComboBox();
    DefaultComboBoxModel audiomodel = new DefaultComboBoxModel();

    public SelectMidiDialog() throws HeadlessException {
        this.tx.removeAllElements();
        this.rx.removeAllElements();
        this.au.removeAllElements();
        try {
            MidiDevice.Info[] mi = MidiSystem.getMidiDeviceInfo();
            int i = 0;
            while (i < mi.length) {
                MidiDevice d = MidiSystem.getMidiDevice(mi[i]);
                System.out.println(d);
                if (d.getMaxTransmitters() != 0) {
                    this.tx.add(d);
                    this.inputmodel.addElement(mi[i].getName());
                }
                if (d.getMaxReceivers() != 0) {
                    this.outputmodel.addElement(mi[i].getName());
                    this.rx.add(d);
                }
                ++i;
            }
            Mixer.Info[] ai = AudioSystem.getMixerInfo();
            int i2 = 0;
            while (i2 < ai.length) {
                Mixer d = AudioSystem.getMixer(ai[i2]);
                if (d.getSourceLineInfo().length > 0) {
                    this.audiomodel.addElement(ai[i2].getName());
                    this.au.add(d);
                }
                ++i2;
            }
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pack();
        PianoApp.centerFrame(this);
    }

    private void jbInit() throws Exception {
        this.setTitle("Select MIDI device");
        this.jLabel1.setText("Midi in");
        this.jLabel2.setText("Midi out");
        this.inputCombo.setEnabled(true);
        this.inputCombo.setModel(this.inputmodel);
        this.outputcombo.setModel(this.outputmodel);
        this.jButton1.setText("OK");
        this.jButton1.addActionListener(new SelectMidiDialog_jButton1_actionAdapter(this));
        this.jPanel1.setLayout(this.borderLayout1);
        this.jLabel3.setText("Audio in");
        this.audioinlist.setModel(this.audiomodel);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.jPanel2.add((Component)this.jLabel1, null);
        this.jPanel2.add((Component)this.inputCombo, null);
        this.getContentPane().add((Component)this.jPanel3, "South");
        this.jPanel3.add((Component)this.jButton1, null);
        this.jPanel1.add((Component)this.jPanel4, "North");
        this.jPanel4.add((Component)this.jLabel2, null);
        this.jPanel4.add((Component)this.outputcombo, null);
        this.jPanel1.add((Component)this.jPanel5, "Center");
        this.jPanel5.add((Component)this.jLabel3, null);
        this.jPanel5.add((Component)this.audioinlist, null);
    }

    void jButton1_actionPerformed(ActionEvent e) {
        try {
            Mixer mix;
            MidiDevice in;
            int i = this.inputCombo.getSelectedIndex();
            if (i >= 0 && (in = (MidiDevice)this.tx.get(i)) != null) {
                this.externalDevice.setMidiDevice(in);
            }
            i = this.outputcombo.getSelectedIndex();
            try {
                MidiDevice out;
                if (i >= 0 && (out = (MidiDevice)this.rx.get(i)) != null) {
                    if (out instanceof Synthesizer) {
                        this.piano.setMidiDevice((Synthesizer)out);
                    } else {
                        this.piano.setMidiDevice(new ExtSynth(out));
                    }
                }
            }
            catch (ClassCastException x) {
                JOptionPane.showMessageDialog(this, x, "Can't use the selected synth", 0);
            }
            if ((i = this.audioinlist.getSelectedIndex()) >= 0 && (mix = (Mixer)this.au.get(i)) != null) {
                this.audiolistenpanel.setMixer(mix);
            }
        }
        catch (MidiUnavailableException x) {
            x.printStackTrace();
        }
        this.hide();
    }
}

