/*
 * Decompiled with CFR 0.152.
 */
package piano;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Synthesizer;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import piano.NoteEvent;
import piano.NoteListener;

class PianoPanel
extends JPanel
implements Scrollable {
    int N = 126;
    int w = 4;
    int h = 12;
    int fcut = 3;
    int fc2 = 3;
    int d = 4;
    double xzoom = 8.0;
    double yzoom = 8.0;
    Shape C;
    Shape D;
    Shape E;
    Shape S;
    Shape[] order;
    boolean[] white;
    int[] x;
    int[] y;
    Shape[] keyShape;
    GeneralPath[] keyPath;
    int highlight;
    boolean[] enabled;
    boolean[] isHeld;
    boolean pressed;
    Instrument[] instr;
    Color hoverW;
    Color hoverB;
    Color disabledW;
    Color disabledB;
    Stroke arrowStroke;
    Synthesizer s;
    MidiChannel c;
    MidiChannel[] allCh;
    boolean thru;
    int base;
    private int[] bends;
    private int vol;
    private int transpose;
    private int keyNote;
    Vector arrows;
    HashSet listeners;

    PianoPanel() {
        int[] nArray = new int[7];
        nArray[1] = this.w;
        nArray[2] = this.w;
        nArray[3] = this.fcut;
        nArray[4] = this.fcut;
        int[] nArray2 = new int[7];
        nArray2[2] = this.d;
        nArray2[3] = this.d;
        nArray2[4] = this.h;
        nArray2[5] = this.h;
        this.C = new Polygon(nArray, nArray2, 7);
        int[] nArray3 = new int[9];
        nArray3[1] = this.w;
        nArray3[2] = this.w;
        nArray3[3] = this.fc2;
        nArray3[4] = this.fc2;
        nArray3[5] = this.w - this.fc2;
        nArray3[6] = this.w - this.fc2;
        int[] nArray4 = new int[9];
        nArray4[2] = this.d;
        nArray4[3] = this.d;
        nArray4[4] = this.h;
        nArray4[5] = this.h;
        nArray4[6] = this.d;
        nArray4[7] = this.d;
        this.D = new Polygon(nArray3, nArray4, 9);
        this.E = AffineTransform.getTranslateInstance(this.w, 0.0).createTransformedShape(AffineTransform.getScaleInstance(-1.0, 1.0).createTransformedShape(this.C));
        int[] nArray5 = new int[5];
        nArray5[2] = 2 * this.w - this.fcut - this.fc2;
        nArray5[3] = 2 * this.w - this.fcut - this.fc2;
        int[] nArray6 = new int[5];
        nArray6[0] = this.d;
        nArray6[1] = this.h - this.d;
        nArray6[2] = this.h - this.d;
        this.S = new Polygon(nArray5, nArray6, 5);
        this.order = new Shape[]{this.C, this.S, this.D, this.S, this.E, this.C, this.S, this.D, this.S, this.D, this.S, this.E};
        boolean[] blArray = new boolean[12];
        blArray[0] = true;
        blArray[2] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[7] = true;
        blArray[9] = true;
        blArray[11] = true;
        this.white = blArray;
        int[] nArray7 = new int[13];
        nArray7[1] = this.fcut;
        nArray7[2] = this.w;
        nArray7[3] = this.w + this.fcut;
        nArray7[4] = 2 * this.w;
        nArray7[5] = 3 * this.w;
        nArray7[6] = 3 * this.w + this.fcut;
        nArray7[7] = 4 * this.w;
        nArray7[8] = 4 * this.w + this.fcut;
        nArray7[9] = 5 * this.w;
        nArray7[10] = 5 * this.w + this.fcut;
        nArray7[11] = 6 * this.w;
        nArray7[12] = 7 * this.w;
        this.x = nArray7;
        int[] nArray8 = new int[13];
        nArray8[1] = this.d;
        nArray8[3] = this.d;
        nArray8[6] = this.d;
        nArray8[8] = this.d;
        nArray8[10] = this.d;
        nArray8[12] = this.d;
        this.y = nArray8;
        this.keyShape = new Shape[this.N];
        this.keyPath = new GeneralPath[this.N];
        this.highlight = -1;
        this.enabled = new boolean[12];
        this.isHeld = new boolean[this.N];
        this.pressed = false;
        this.hoverW = new Color(255, 255, 150);
        this.hoverB = new Color(70, 70, 0);
        this.disabledW = new Color(170, 170, 255);
        this.disabledB = new Color(95, 95, 130);
        this.arrowStroke = new BasicStroke(3.0f);
        this.thru = true;
        this.base = 0;
        this.bends = null;
        this.vol = 64;
        this.transpose = 0;
        this.keyNote = 0;
        this.arrows = new Vector();
        this.listeners = new HashSet();
        this.setZoom(75);
        Arrays.fill(this.enabled, true);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int i;
                if (!PianoPanel.this.hasFocus()) {
                    PianoPanel.this.requestFocusInWindow();
                }
                PianoPanel.this.highlight = i = PianoPanel.this.getKeyAt(e.getPoint());
                if (PianoPanel.this.highlight >= 0) {
                    PianoPanel.this.pressed = PianoPanel.this.enabled[i % 12];
                    if (PianoPanel.this.pressed) {
                        PianoPanel.this.keyDown(PianoPanel.this.highlight);
                    }
                } else {
                    PianoPanel.this.pressed = false;
                }
                PianoPanel.this.repaint();
            }

            public void mouseReleased(MouseEvent e) {
                PianoPanel.this.pressed = false;
                if (PianoPanel.this.highlight >= 0) {
                    PianoPanel.this.keyUp(PianoPanel.this.highlight);
                }
                PianoPanel.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                int i = PianoPanel.this.getKeyAt(e.getPoint());
                if (PianoPanel.this.highlight != i) {
                    PianoPanel.this.highlight = i;
                    PianoPanel.this.repaint();
                }
            }

            public void mouseDragged(MouseEvent e) {
                int i = PianoPanel.this.getKeyAt(e.getPoint());
                if (PianoPanel.this.highlight != i) {
                    PianoPanel.this.keyUp(PianoPanel.this.highlight);
                    PianoPanel.this.highlight = i;
                    if (PianoPanel.this.highlight >= 0) {
                        PianoPanel.this.pressed = PianoPanel.this.enabled[i % 12];
                        if (PianoPanel.this.pressed) {
                            PianoPanel.this.keyDown(PianoPanel.this.highlight);
                        }
                    } else {
                        PianoPanel.this.pressed = false;
                    }
                    PianoPanel.this.repaint();
                }
            }
        });
        try {
            this.s = MidiSystem.getSynthesizer();
            this.setMidiDevice(this.s);
            System.out.println("Default synth: " + this.s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setMidiDevice(Synthesizer out) throws MidiUnavailableException {
        if (this.s.isOpen()) {
            this.s.close();
        }
        this.s = out;
        this.s.open();
        this.c = this.s.getChannels()[0];
        this.allCh = this.s.getChannels();
        this.allCh[9] = this.allCh[12];
        this.instr = this.s.getAvailableInstruments();
    }

    public void finalize() throws Throwable {
        if (this.s.isOpen()) {
            this.s.close();
        }
        super.finalize();
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        int i = 0;
        while (i < this.N) {
            Color c;
            boolean wh = this.white[i % 12];
            Color color = c = wh ? Color.white : Color.black;
            if (i == this.highlight) {
                Color color2 = this.pressed ? Color.red : (c = wh ? this.hoverW : this.hoverB);
            }
            if (!this.enabled[i % 12]) {
                Color color3 = c = wh ? this.disabledW : this.disabledB;
            }
            if (this.isHeld[i]) {
                c = Color.red;
            }
            g.setColor(c);
            g2.fill(this.keyPath[i]);
            ++i;
        }
        this.paintArrows(g);
    }

    void paintArrows(Graphics g) {
        int i = 0;
        while (i < this.arrows.size()) {
            int[] data = (int[])this.arrows.get(i);
            if (data[0] != data[1]) {
                Rectangle k0 = this.keyPath[data[0]].getBounds();
                Rectangle k1 = this.keyPath[data[1]].getBounds();
                g.setColor(Color.blue);
                ((Graphics2D)g).setStroke(this.arrowStroke);
                int dy = data[2] / 10 % 20 - 10;
                int epx = k1.x + k1.width / 2;
                int epy = k1.y + k1.height / 2 + dy;
                int spx = k0.x + k0.width / 2;
                int dir = epx > spx ? 1 : -1;
                g.drawLine(spx, k0.y + k0.height / 2 + dy, epx, epy);
                g.drawLine(epx, epy, epx - dir * 5, epy + 5);
                g.drawLine(epx, epy, epx - dir * 5, epy - 5);
            }
            ++i;
        }
    }

    int getKeyAt(Point p) {
        int i = 0;
        while (i < this.N) {
            if (this.keyShape[i].contains(p)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void repaint(int key) {
        this.repaint(this.keyPath[key].getBounds());
    }

    void setZoom(int percent) {
        this.xzoom = (double)(percent * 12) / 100.0;
        AffineTransform t = AffineTransform.getScaleInstance(this.xzoom, -this.yzoom);
        t.translate(0.0, -this.yzoom * 4.0 / 3.0);
        int i = 0;
        while (i < this.N) {
            this.keyShape[i] = t.createTransformedShape(AffineTransform.getTranslateInstance((double)i / 4.0 + (double)this.x[i % 12] + (double)(this.w * 7 * (i / 12)), this.y[i % 12]).createTransformedShape(this.order[i % 12]));
            GeneralPath p = new GeneralPath(this.keyShape[i]);
            p.setWindingRule(1);
            this.keyPath[i] = p;
            ++i;
        }
        Dimension s = new Dimension((int)(((double)this.w * this.xzoom + 1.0) * (double)this.N * 7.0 / 12.0), (int)(this.yzoom * (double)this.h));
        this.setPreferredSize(s);
        this.setSize(s);
        this.repaint();
    }

    public void keyUp(int i, boolean midiOutput) {
        if (i < 0) {
            return;
        }
        MidiChannel pc = this.c;
        if (this.bends != null) {
            pc = this.allCh[(i + this.keyNote) % 12];
        }
        if (midiOutput && pc != null) {
            pc.noteOff(i + this.base + this.transpose);
        }
        this.fireNoteEvent(i, false, 0);
    }

    public void keyUp(int i) {
        this.keyUp(i, true);
    }

    public void keyDown(int n, int v, boolean midiOutput) {
        MidiChannel pc = this.c;
        if (this.bends != null) {
            pc = this.allCh[(n + this.keyNote) % 12];
        }
        if (midiOutput && pc != null) {
            pc.noteOn(n + this.base + this.transpose, v);
        }
        this.fireNoteEvent(n, true, v);
    }

    public void keyDown(int i) {
        this.keyDown(i, this.getVol());
    }

    public void keyDown(int n, int v) {
        this.keyDown(n, v, this.thru);
    }

    public void setTemperament(int[] t) {
        this.bends = t;
        int i = 0;
        while (i < 12) {
            if (this.bends != null) {
                this.allCh[i].setPitchBend(8192 + this.bends[i]);
            } else {
                this.allCh[i].setPitchBend(8192);
            }
            this.allCh[i].programChange(this.c.getProgram());
            ++i;
        }
    }

    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 7 * (int)((double)this.w * this.xzoom + 1.0);
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return (int)((double)this.w * this.xzoom + 1.0);
    }

    public int getVol() {
        return this.vol;
    }

    public void setVol(int vol) {
        this.vol = vol;
    }

    public int getTranspose() {
        return this.transpose;
    }

    public void setTranspose(int t) {
        this.transpose = t;
    }

    public void setKeyNote(int keyNote) {
        this.keyNote = keyNote;
    }

    public int getKeyNote() {
        return this.keyNote;
    }

    public void programChange(int i, int i1) {
        this.c.programChange(i, i1);
        this.setTemperament(this.bends);
    }

    public void addNoteListener(NoteListener listener) {
        this.listeners.add(listener);
    }

    public void removeNoteListener(NoteListener listener) {
        this.listeners.remove(listener);
    }

    public final void fireNoteEvent(int note, boolean on, int vel) {
        if (this.listeners.isEmpty()) {
            return;
        }
        NoteEvent e = new NoteEvent(note, on, vel);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            if (on) {
                ((NoteListener)i.next()).noteOn(e);
                continue;
            }
            ((NoteListener)i.next()).noteOff(e);
        }
    }

    public int[] getCurrentNotes() {
        Vector<Integer> notes = new Vector<Integer>();
        int i = 0;
        while (i < this.N) {
            if (this.isHeld[i]) {
                notes.add(new Integer(i));
            }
            ++i;
        }
        int[] q = new int[notes.size()];
        int i2 = 0;
        while (i2 < q.length) {
            q[i2] = (Integer)notes.get(i2);
            ++i2;
        }
        return q;
    }
}

