/*
 * Decompiled with CFR 0.152.
 */
package piano;

import evaluator.EvaluatorConsole;
import evaluator.ObjectPath;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Hashtable;
import javax.sound.midi.Instrument;
import javax.sound.midi.Patch;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import piano.AudioListenPanel;
import piano.ChordAnalyser;
import piano.ChordSelect;
import piano.ChordSequencePanel;
import piano.CounterpointPanel;
import piano.ExternalPlayer;
import piano.PianoApp_controllerlist_itemAdapter;
import piano.PianoApp_filterKeyMenu_actionAdapter;
import piano.PianoApp_filterMIDImenu_actionAdapter;
import piano.PianoApp_jButton1_actionAdapter;
import piano.PianoApp_jMenuItem1_actionAdapter;
import piano.PianoApp_keyslider_changeAdapter;
import piano.PianoApp_list1_itemAdapter;
import piano.PianoApp_reverbslider_changeAdapter;
import piano.PianoApp_temper_itemAdapter;
import piano.PianoApp_transposeslider_changeAdapter;
import piano.PianoApp_volslider_changeAdapter;
import piano.PianoApp_zoomslider_changeAdapter;
import piano.PianoPanel;
import piano.SelectMidiDialog;
import piano.SequencerPanel;
import sanjay.PlafMenu;

public class PianoApp
extends JFrame {
    public JPanel controls = new JPanel();
    public PianoPanel piano = new PianoPanel();
    public DefaultComboBoxModel model = new DefaultComboBoxModel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JPanel jPanel1 = new JPanel();
    public JSlider zoomslider = new JSlider();
    JMenuBar jMenuBar1 = new JMenuBar();
    public JMenu helpmenu = new JMenu();
    public JMenuItem aboutmenu = new JMenuItem();
    JPanel jPanel2 = new JPanel();
    public JComboBox list1 = new JComboBox();
    public JSlider volslider = new JSlider();
    BorderLayout borderLayout1 = new BorderLayout();
    public JPanel scaleControlPanel = new JPanel();
    public JSlider keyslider = new JSlider();
    JPanel jPanel3 = new JPanel();
    public JComboBox temper = new JComboBox();
    public DefaultComboBoxModel tempermodel = new DefaultComboBoxModel();
    JLabel jLabel1 = new JLabel();
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    JPanel jPanel4 = new JPanel();
    JEditorPane jEditorPane1 = new JEditorPane();
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel jLabel2 = new JLabel();
    public JSlider transposeslider = new JSlider();
    public JLabel transptxt = new JLabel();
    JScrollPane jScrollPane2 = new JScrollPane();
    public JSlider reverbslider = new JSlider();
    JMenu jMenu1 = new JMenu();
    public JCheckBoxMenuItem filterKeyMenu = new JCheckBoxMenuItem();
    public JCheckBoxMenuItem filterMIDImenu = new JCheckBoxMenuItem();
    public JComboBox controllerlist = new JComboBox();
    public DefaultComboBoxModel controllermodel;
    JButton jButton1 = new JButton();
    JMenuItem jMenuItem1 = new JMenuItem();
    JMenuItem thruMenuItem = new JCheckBoxMenuItem();
    public ChordAnalyser chordAnalyser = new ChordAnalyser();
    public ChordSelect chordSelect1 = new ChordSelect();
    public CounterpointPanel counterpointPanel1 = new CounterpointPanel();
    public ChordSequencePanel chordSequencePanel1;
    public AudioListenPanel audioListenPanel1 = new AudioListenPanel();
    public String chordSeqClassName = "piano.ChordSequencePanel";
    public Hashtable labels = new Hashtable();
    public ButtonGroup scaleGroup = new ButtonGroup();
    public static String[] keyName = new String[]{"C", "C#", "D", "Eb", "E", "F", "F#", "G", "Ab", "A", "Bb", "B"};
    public ActionListener changeScaleAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            PianoApp.this.updateEnabledKeys();
        }
    };
    public int[][] temperaments;
    public String[] temperamentNames;
    public KeyListener keyListener;
    public boolean filterKeyPresses;
    public boolean filterMidiIn;
    public Action aboutAction;
    public Action thruAction;
    public int[][] scales;
    public String[] scaleNames;
    public ExternalPlayer ext;
    public String[] controllerName;
    public int[] controller;
    public JPanel scriptpanel;
    BorderLayout borderLayout3;
    JScrollPane jScrollPane3;
    public EvaluatorConsole evaluatorConsole1;
    SequencerPanel sequencerPanel1;
    JPanel jPanel5;
    BorderLayout borderLayout4;
    JSplitPane jSplitPane1;
    static /* synthetic */ Class class$0;

    public PianoApp() throws HeadlessException {
        int[][] nArrayArray = new int[6][];
        nArrayArray[0] = new int[12];
        int[] nArray = new int[12];
        nArray[1] = -981;
        nArray[2] = 701;
        nArray[3] = 701;
        nArray[4] = -981;
        nArray[5] = 701;
        nArray[6] = -981;
        nArray[7] = 701;
        nArray[8] = -981;
        nArray[9] = 701;
        nArray[10] = 701;
        nArray[11] = -981;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[12];
        nArray2[1] = 561;
        nArray2[2] = 160;
        nArray2[3] = -240;
        nArray2[4] = 320;
        nArray2[5] = -80;
        nArray2[6] = 480;
        nArray2[7] = 80;
        nArray2[8] = 640;
        nArray2[9] = 240;
        nArray2[10] = -160;
        nArray2[11] = 400;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[12];
        nArray3[1] = -400;
        nArray3[2] = -320;
        nArray3[3] = -240;
        nArray3[4] = -400;
        nArray3[5] = -80;
        nArray3[6] = -480;
        nArray3[7] = -160;
        nArray3[8] = -320;
        nArray3[9] = -480;
        nArray3[10] = -160;
        nArray3[11] = -320;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[12];
        nArray4[1] = -320;
        nArray4[2] = -280;
        nArray4[3] = -240;
        nArray4[4] = -561;
        nArray4[5] = -80;
        nArray4[6] = -400;
        nArray4[7] = -140;
        nArray4[8] = -240;
        nArray4[9] = -420;
        nArray4[10] = -160;
        nArray4[11] = -481;
        nArrayArray[4] = nArray4;
        int[] nArray5 = new int[12];
        nArray5[1] = -553;
        nArray5[2] = -287;
        nArray5[3] = -164;
        nArray5[4] = -573;
        nArray5[5] = 143;
        nArray5[6] = -635;
        nArray5[7] = -143;
        nArray5[8] = -471;
        nArray5[9] = -430;
        nArray5[10] = 205;
        nArray5[11] = -696;
        nArrayArray[5] = nArray5;
        this.temperaments = nArrayArray;
        this.temperamentNames = new String[]{"Equal", "1/4 comma mean tone", "Pythagorean", "Werckmeister III", "Kirnberger 3", "Rameau MMT"};
        this.keyListener = new KeyListener(){
            public int[] singleRowKeyCodes = new int[]{65, 87, 83, 69, 68, 70, 84, 71, 89, 72, 85, 74, 75, 79, 76, 80, 59, 222, 93, 520};
            public int[] keyCodes = new int[]{92, 65, 90, 83, 88, 67, 70, 86, 71, 66, 72, 78, 77, 75, 44, 76, 46, 47, 222, 9, 49, 81, 50, 87, 69, 52, 82, 53, 84, 89, 55, 85, 56, 73, 57, 79, 80, 45, 91, 61, 93};
            public int keyBase = 48;

            public void keyPressed(KeyEvent e) {
                int k = e.getKeyCode();
                int i = 0;
                while (i < this.keyCodes.length) {
                    if (this.keyCodes[i] == k) {
                        if (PianoApp.this.piano.isHeld[i + this.keyBase]) {
                            return;
                        }
                        int key = i + this.keyBase;
                        if (PianoApp.this.filterKeyPresses && !PianoApp.this.piano.enabled[key % 12]) {
                            return;
                        }
                        PianoApp.this.piano.isHeld[key] = true;
                        PianoApp.this.piano.keyDown(key);
                        PianoApp.this.piano.repaint();
                        break;
                    }
                    ++i;
                }
            }

            public void keyReleased(KeyEvent e) {
                int k = e.getKeyCode();
                int i = 0;
                while (i < this.keyCodes.length) {
                    if (this.keyCodes[i] == k) {
                        int key = i + this.keyBase;
                        if (PianoApp.this.filterKeyPresses && !PianoApp.this.piano.enabled[key % 12]) {
                            return;
                        }
                        PianoApp.this.piano.isHeld[key] = false;
                        PianoApp.this.piano.keyUp(key);
                        PianoApp.this.piano.repaint();
                    }
                    ++i;
                }
            }

            public void keyTyped(KeyEvent e) {
            }
        };
        this.filterKeyPresses = false;
        this.filterMidiIn = false;
        this.aboutAction = new AbstractAction("About..."){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(PianoApp.this, "Click on the piano then use your keyboard (ZXC etc)! (c) Sanjay Manohar 2005", "Sanjay's Keyboard", 1);
            }
        };
        this.thruAction = new AbstractAction("Midi output"){

            public void actionPerformed(ActionEvent e) {
                PianoApp.this.piano.thru = PianoApp.this.thruMenuItem.isSelected();
            }
        };
        int[][] nArrayArray2 = new int[10][];
        int[] nArray6 = new int[12];
        nArray6[1] = 1;
        nArray6[2] = 2;
        nArray6[3] = 3;
        nArray6[4] = 4;
        nArray6[5] = 5;
        nArray6[6] = 6;
        nArray6[7] = 7;
        nArray6[8] = 8;
        nArray6[9] = 9;
        nArray6[10] = 10;
        nArray6[11] = 11;
        nArrayArray2[0] = nArray6;
        int[] nArray7 = new int[7];
        nArray7[1] = 2;
        nArray7[2] = 4;
        nArray7[3] = 5;
        nArray7[4] = 7;
        nArray7[5] = 9;
        nArray7[6] = 11;
        nArrayArray2[1] = nArray7;
        int[] nArray8 = new int[7];
        nArray8[1] = 1;
        nArray8[2] = 3;
        nArray8[3] = 4;
        nArray8[4] = 6;
        nArray8[5] = 8;
        nArray8[6] = 10;
        nArrayArray2[2] = nArray8;
        int[] nArray9 = new int[7];
        nArray9[1] = 2;
        nArray9[2] = 3;
        nArray9[3] = 5;
        nArray9[4] = 7;
        nArray9[5] = 8;
        nArray9[6] = 11;
        nArrayArray2[3] = nArray9;
        int[] nArray10 = new int[5];
        nArray10[1] = 2;
        nArray10[2] = 4;
        nArray10[3] = 7;
        nArray10[4] = 9;
        nArrayArray2[4] = nArray10;
        int[] nArray11 = new int[6];
        nArray11[1] = 2;
        nArray11[2] = 4;
        nArray11[3] = 6;
        nArray11[4] = 8;
        nArray11[5] = 10;
        nArrayArray2[5] = nArray11;
        int[] nArray12 = new int[8];
        nArray12[1] = 2;
        nArray12[2] = 3;
        nArray12[3] = 5;
        nArray12[4] = 6;
        nArray12[5] = 8;
        nArray12[6] = 9;
        nArray12[7] = 11;
        nArrayArray2[6] = nArray12;
        int[] nArray13 = new int[7];
        nArray13[1] = 2;
        nArray13[2] = 4;
        nArray13[3] = 6;
        nArray13[4] = 7;
        nArray13[5] = 9;
        nArray13[6] = 10;
        nArrayArray2[7] = nArray13;
        int[] nArray14 = new int[8];
        nArray14[1] = 2;
        nArray14[2] = 4;
        nArray14[3] = 5;
        nArray14[4] = 6;
        nArray14[5] = 8;
        nArray14[6] = 10;
        nArray14[7] = 11;
        nArrayArray2[8] = nArray14;
        int[] nArray15 = new int[7];
        nArray15[1] = 2;
        nArray15[2] = 3;
        nArray15[3] = 5;
        nArray15[4] = 6;
        nArray15[5] = 8;
        nArray15[6] = 10;
        nArrayArray2[9] = nArray15;
        this.scales = nArrayArray2;
        this.scaleNames = new String[]{"Chromatic", "Major", "Altered", "Melodic m", "Pentatonic", "Whole tone", "Diminished", "Dominant", "Two-five", "Locrian#2"};
        this.ext = new ExternalPlayer(this.piano);
        this.controllerName = new String[]{"Modulation", "Pan", "Expression", "Sustain", "Reverb", "Chorus"};
        this.controller = new int[]{1, 10, 11, 64, 91, 93};
        this.scriptpanel = new JPanel();
        this.borderLayout3 = new BorderLayout();
        this.jScrollPane3 = new JScrollPane();
        this.evaluatorConsole1 = new EvaluatorConsole();
        this.sequencerPanel1 = new SequencerPanel();
        this.jPanel5 = new JPanel();
        this.borderLayout4 = new BorderLayout();
        this.jSplitPane1 = new JSplitPane();
        try {
            this.chordSequencePanel1 = (ChordSequencePanel)Class.forName(this.chordSeqClassName).newInstance();
            this.chordSequencePanel1.piano = this.piano;
            this.chordSelect1.chordSequencePanel = this.chordSequencePanel1;
            this.chordAnalyser.chordSequencePanel = this.chordSequencePanel1;
            this.sequencerPanel1.piano = this.piano;
            this.sequencerPanel1.chordSequencePanel = this.chordSequencePanel1;
            this.sequencerPanel1.econsole = this.evaluatorConsole1;
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pack();
        this.setSize(700, 300);
        PianoApp.centerFrame(this);
        this.model = new DefaultComboBoxModel<Instrument>(this.piano.instr);
        this.list1.setModel(this.model);
        this.tempermodel = new DefaultComboBoxModel<String>(this.temperamentNames);
        this.temper.setModel(this.tempermodel);
        this.controllermodel = new DefaultComboBoxModel<String>(this.controllerName);
        this.controllerlist.setModel(this.controllermodel);
        this.piano.scrollRectToVisible(new Rectangle(this.piano.getPreferredSize().width / 2 + 200, 1, 150, 1));
        this.createScaleControls();
        this.piano.addKeyListener(this.keyListener);
        this.piano.requestFocus();
        this.chordAnalyser.piano = this.piano;
        this.chordSelect1.piano = this.piano;
        this.counterpointPanel1.piano = this.piano;
        this.audioListenPanel1.piano = this.piano;
        Object[] objectArray = new Object[3];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Math");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[0] = clazz;
        objectArray[1] = this;
        objectArray[2] = this.evaluatorConsole1;
        ObjectPath.setRoot(objectArray);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                PianoApp.this.sequencerPanel1.shutdown();
            }
        });
    }

    public static void centerFrame(Component f) throws HeadlessException {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        f.setLocation((d.width - f.getWidth()) / 2, (d.height - f.getHeight()) / 2);
    }

    void createScaleControls() {
        int i = 0;
        while (i < 12) {
            this.labels.put(new Integer(i), new JLabel(keyName[i]));
            ++i;
        }
        this.keyslider.setLabelTable(this.labels);
        i = 0;
        while (i < this.scaleNames.length) {
            JRadioButton r = new JRadioButton(this.scaleNames[i]);
            r.addActionListener(this.changeScaleAction);
            r.getModel().setActionCommand(this.scaleNames[i]);
            this.scaleGroup.add(r);
            this.scaleControlPanel.add(r);
            if (i == 0) {
                r.setSelected(true);
            }
            ++i;
        }
    }

    public static void main(String[] s) {
        new PianoApp();
    }

    private void jbInit() throws Exception {
        this.setJMenuBar(this.jMenuBar1);
        this.setTitle("Sanjay's Keyboard");
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.zoomslider.setOrientation(1);
        this.zoomslider.setMinimum(18);
        this.zoomslider.setPreferredSize(new Dimension(24, 80));
        this.zoomslider.setToolTipText("Key width");
        this.zoomslider.addChangeListener(new PianoApp_zoomslider_changeAdapter(this));
        this.helpmenu.setText("Help");
        this.aboutmenu.setText("About...");
        this.aboutmenu.addActionListener(this.aboutAction);
        this.list1.addItemListener(new PianoApp_list1_itemAdapter(this));
        this.volslider.setMajorTickSpacing(6);
        this.volslider.setMaximum(12);
        this.volslider.setMinorTickSpacing(1);
        this.volslider.setPaintTicks(true);
        this.volslider.setPreferredSize(new Dimension(100, 24));
        this.volslider.setToolTipText("Volume");
        this.volslider.setValue(6);
        this.volslider.addChangeListener(new PianoApp_volslider_changeAdapter(this));
        this.controls.setLayout(this.borderLayout1);
        this.keyslider.setMaximum(11);
        this.keyslider.setPaintLabels(true);
        this.keyslider.setPaintTicks(true);
        this.keyslider.setPreferredSize(new Dimension(160, 45));
        this.keyslider.setToolTipText("Key slider");
        this.keyslider.setValue(0);
        this.keyslider.addChangeListener(new PianoApp_keyslider_changeAdapter(this));
        this.list1.addItemListener(new PianoApp_list1_itemAdapter(this));
        this.scaleControlPanel.setMinimumSize(new Dimension(46, 57));
        this.scaleControlPanel.setPreferredSize(new Dimension(90, 90));
        this.jMenu1.setText("Options");
        this.filterKeyMenu.setText("Filter keypresses");
        this.filterKeyMenu.addActionListener(new PianoApp_filterKeyMenu_actionAdapter(this));
        this.filterMIDImenu.setText("Filter MIDI input");
        this.filterMIDImenu.addActionListener(new PianoApp_filterMIDImenu_actionAdapter(this));
        this.temper.addItemListener(new PianoApp_temper_itemAdapter(this));
        this.jLabel1.setText("Vol");
        this.jPanel4.setLayout(this.borderLayout2);
        this.jEditorPane1.setEditable(false);
        this.jEditorPane1.setText("");
        this.jLabel2.setText("Transpose");
        this.transposeslider.setMajorTickSpacing(6);
        this.transposeslider.setMaximum(12);
        this.transposeslider.setMinorTickSpacing(1);
        this.transposeslider.setPaintTicks(true);
        this.transposeslider.setPaintTrack(true);
        this.transposeslider.setPreferredSize(new Dimension(100, 24));
        this.transposeslider.setValue(6);
        this.transposeslider.addChangeListener(new PianoApp_transposeslider_changeAdapter(this));
        this.transptxt.setText("0");
        this.jPanel4.setPreferredSize(new Dimension(315, 60));
        this.reverbslider.setPreferredSize(new Dimension(100, 24));
        this.reverbslider.setPreferredSize(new Dimension(100, 24));
        this.reverbslider.addChangeListener(new PianoApp_reverbslider_changeAdapter(this));
        this.controllerlist.addItemListener(new PianoApp_controllerlist_itemAdapter(this));
        this.jButton1.setText("Reset controllers");
        this.jButton1.addActionListener(new PianoApp_jButton1_actionAdapter(this));
        this.jPanel2.setPreferredSize(new Dimension(100, 40));
        this.jMenuItem1.setText("Select device...");
        this.jMenuItem1.addActionListener(new PianoApp_jMenuItem1_actionAdapter(this));
        this.chordAnalyser.setPreferredSize(new Dimension(258, 60));
        this.scriptpanel.setLayout(this.borderLayout3);
        this.jScrollPane3.setPreferredSize(new Dimension(9, 40));
        this.jScrollPane2.setPreferredSize(new Dimension(615, 53));
        this.jPanel5.setLayout(this.borderLayout4);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jPanel2.add((Component)this.jLabel1, null);
        this.jPanel2.add((Component)this.volslider, null);
        this.jPanel2.add((Component)this.list1, null);
        this.jPanel2.add((Component)this.controllerlist, null);
        this.jPanel2.add((Component)this.reverbslider, null);
        this.jPanel2.add((Component)this.jButton1, null);
        this.jTabbedPane1.add((Component)this.scaleControlPanel, "Scale");
        this.scaleControlPanel.add((Component)this.keyslider, null);
        this.jTabbedPane1.add((Component)this.jPanel3, "Temperament");
        this.jPanel2.add((Component)this.reverbslider, null);
        this.jTabbedPane1.add((Component)this.jPanel2, "MIDI");
        this.jPanel5.add((Component)this.jScrollPane1, "Center");
        this.jPanel5.add((Component)this.jPanel1, "West");
        this.jPanel1.add((Component)this.zoomslider, null);
        this.jScrollPane1.getViewport().add(this.piano);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.controls, "top");
        this.controls.add((Component)this.jTabbedPane1, "Center");
        this.jPanel3.add((Component)this.temper, null);
        this.jPanel3.add((Component)this.jLabel2, null);
        this.jPanel3.add((Component)this.transposeslider, null);
        this.jPanel3.add((Component)this.transptxt, null);
        this.jTabbedPane1.add((Component)this.chordAnalyser, "Chord analyse");
        this.jTabbedPane1.add((Component)this.chordSelect1, "Chord player");
        this.jTabbedPane1.add((Component)this.counterpointPanel1, "Counterpoint");
        this.jTabbedPane1.add((Component)this.chordSequencePanel1, "Changes");
        this.jTabbedPane1.add((Component)this.audioListenPanel1, "Microphone");
        this.jTabbedPane1.add((Component)this.jPanel4, "About");
        this.jPanel4.add((Component)this.jScrollPane2, "Center");
        this.jTabbedPane1.add((Component)this.scriptpanel, "Script");
        this.scriptpanel.add((Component)this.jScrollPane3, "Center");
        this.jTabbedPane1.add((Component)this.sequencerPanel1, "Memory");
        this.jSplitPane1.add((Component)this.jPanel5, "bottom");
        this.jScrollPane3.getViewport().add((Component)this.evaluatorConsole1, null);
        this.jScrollPane2.getViewport().add((Component)this.jEditorPane1, null);
        this.jPanel3.add((Component)this.transposeslider, null);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenuBar1.add(this.helpmenu);
        this.helpmenu.add(this.aboutmenu);
        this.helpmenu.add(new PlafMenu(this));
        this.jMenu1.add(this.filterKeyMenu);
        this.jMenu1.add(this.filterMIDImenu);
        this.jMenu1.add(this.jMenuItem1);
        this.zoomslider.setValue(50);
        this.keyslider.setMajorTickSpacing(1);
        this.piano.setBackground(Color.darkGray);
        this.keyslider.setSnapToTicks(true);
        this.transposeslider.setSnapToTicks(true);
        this.jEditorPane1.setPage(this.getClass().getResource("About.html"));
        this.setDefaultCloseOperation(3);
        this.jSplitPane1.setDividerLocation(140);
        this.jMenu1.add(this.thruMenuItem);
        this.thruMenuItem.setSelected(true);
        this.thruMenuItem.setAction(this.thruAction);
    }

    void list1_itemStateChanged(ItemEvent e) {
        Patch p = ((Instrument)this.list1.getSelectedItem()).getPatch();
        this.piano.programChange(p.getBank(), p.getProgram());
    }

    void zoomslider_stateChanged(ChangeEvent e) {
        this.piano.setZoom(this.zoomslider.getValue() * 100 / this.zoomslider.getMaximum());
    }

    public void updateEnabledKeys() {
        int[] scale = this.getSelectedScale();
        int key = this.keyslider.getValue();
        if (scale != null) {
            Arrays.fill(this.piano.enabled, false);
            int i = 0;
            while (i < scale.length) {
                this.piano.enabled[(scale[i] + key) % 12] = true;
                ++i;
            }
        }
        this.piano.repaint();
    }

    public int[] getSelectedScale() {
        String scale = this.scaleGroup.getSelection().getActionCommand();
        int i = 0;
        while (i < this.scaleNames.length) {
            if (this.scaleNames[i].equals(scale)) {
                return this.scales[i];
            }
            ++i;
        }
        return null;
    }

    void keyslider_stateChanged(ChangeEvent e) {
        this.updateEnabledKeys();
        this.piano.setKeyNote(this.keyslider.getValue());
    }

    void volslider_stateChanged(ChangeEvent e) {
        this.piano.setVol(this.volslider.getValue() * 127 / this.volslider.getMaximum());
    }

    void setfilters(ActionEvent e) {
        this.filterMidiIn = this.filterMIDImenu.isSelected();
        this.filterKeyPresses = this.filterKeyMenu.isSelected();
        if (this.ext != null) {
            this.ext.filterMIDI = this.filterMidiIn;
        }
    }

    void temper_itemStateChanged(ItemEvent e) {
        int i = 0;
        while (i < this.temperamentNames.length) {
            if (this.temperamentNames[i].equals(this.temper.getSelectedItem().toString())) {
                this.piano.setTemperament(this.temperaments[i]);
                break;
            }
            ++i;
        }
    }

    void transposeslider_stateChanged(ChangeEvent e) {
        int tr = this.transposeslider.getValue() - this.transposeslider.getMaximum() / 2;
        this.piano.setTranspose(tr);
        this.transptxt.setText(String.valueOf(tr));
    }

    void reverbslider_stateChanged(ChangeEvent e) {
        int c = this.getSelectedController();
        int rev = this.reverbslider.getValue() * this.getControllerMax(c) / this.reverbslider.getMaximum();
        this.piano.c.controlChange(c, rev);
    }

    public int getSelectedController() {
        int i = 0;
        while (i < this.controllerName.length) {
            if (this.controllerName[i].equals(this.controllerlist.getSelectedItem().toString())) {
                return this.controller[i];
            }
            ++i;
        }
        return -1;
    }

    public int getControllerMax(int controller) {
        return controller < 90 ? 127 : 16384;
    }

    void controllerlist_itemStateChanged(ItemEvent e) {
        int i = this.getSelectedController();
        this.reverbslider.setValue(this.reverbslider.getMaximum() * this.piano.c.getController(i) / this.getControllerMax(i));
    }

    void jButton1_actionPerformed(ActionEvent e) {
        this.piano.c.resetAllControllers();
    }

    void jMenuItem1_actionPerformed(ActionEvent e) {
        SelectMidiDialog d = new SelectMidiDialog();
        d.piano = this.piano;
        d.externalDevice = this.ext;
        d.audiolistenpanel = this.audioListenPanel1;
        d.show();
    }
}

