/*
 * Decompiled with CFR 0.152.
 */
package piano;

import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import piano.PianoPanel;

public class ExternalPlayer
implements Receiver {
    PianoPanel p;
    Transmitter t;
    MidiDevice device;
    boolean filterMIDI = false;

    public ExternalPlayer(PianoPanel p) {
        this.p = p;
        Vector<MidiDevice> tx = new Vector<MidiDevice>();
        try {
            MidiDevice.Info[] mi = MidiSystem.getMidiDeviceInfo();
            int i = 0;
            while (i < mi.length) {
                MidiDevice d = MidiSystem.getMidiDevice(mi[i]);
                System.out.println(d);
                if (d.getClass().getName().indexOf("MidiIn") >= 0) {
                    tx.add(d);
                }
                ++i;
            }
            if (tx.size() == 0) {
                System.out.println("No midi In devices found");
                return;
            }
            try {
                this.device = (MidiDevice)tx.get(0);
                this.setMidiDevice(this.device);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (MidiUnavailableException ex) {
            ex.printStackTrace();
        }
    }

    void setMidiDevice(MidiDevice nd) throws MidiUnavailableException {
        this.close();
        this.device = nd;
        this.t = this.device.getTransmitter();
        this.device.open();
        this.t.setReceiver(this);
    }

    public void close() {
        if (this.t != null) {
            this.t.close();
            this.device.close();
            this.t.setReceiver(null);
            this.t = null;
        }
    }

    public void finalize() throws Throwable {
        this.close();
    }

    public void send(MidiMessage message, long timeStamp) {
        if (message instanceof ShortMessage) {
            ShortMessage s = (ShortMessage)message;
            int c = s.getCommand();
            int n = s.getData1();
            int v = s.getData2();
            if (c == 128 || c == 144 && v == 0) {
                if (this.filterMIDI && !this.p.enabled[n % 12]) {
                    return;
                }
                this.p.isHeld[n] = false;
                this.p.keyUp(n);
                this.p.repaint();
                return;
            }
            if (c == 144) {
                if (this.filterMIDI && !this.p.enabled[n % 12]) {
                    return;
                }
                this.p.isHeld[n] = true;
                this.p.keyDown(n, v);
                this.p.repaint();
            }
        }
    }
}

