/*
 * Decompiled with CFR 0.152.
 */
package piano;

import java.util.List;
import javax.sound.midi.Instrument;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.VoiceStatus;

class ExtSynth
implements Synthesizer {
    MidiDevice out;
    ExtChannel[] ch = new ExtChannel[16];
    Receiver rec;

    ExtSynth(MidiDevice out) {
        this.out = out;
        int i = 0;
        while (i < 16) {
            int j;
            int n = j = i < 10 ? i : i + 1;
            if (j == 16) {
                j = 10;
            }
            this.ch[i] = new ExtChannel(j);
            ++i;
        }
    }

    public Instrument[] getAvailableInstruments() {
        return null;
    }

    public MidiChannel[] getChannels() {
        return this.ch;
    }

    public Soundbank getDefaultSoundbank() {
        return null;
    }

    public long getLatency() {
        return 0L;
    }

    public Instrument[] getLoadedInstruments() {
        return null;
    }

    public int getMaxPolyphony() {
        return 16;
    }

    public VoiceStatus[] getVoiceStatus() {
        return null;
    }

    public boolean isSoundbankSupported(Soundbank soundbank) {
        return false;
    }

    public boolean loadAllInstruments(Soundbank soundbank) {
        return false;
    }

    public boolean loadInstrument(Instrument instrument) {
        return false;
    }

    public boolean loadInstruments(Soundbank soundbank, Patch[] patchList) {
        return false;
    }

    public boolean remapInstrument(Instrument from, Instrument to) {
        return false;
    }

    public void unloadAllInstruments(Soundbank soundbank) {
    }

    public void unloadInstrument(Instrument instrument) {
    }

    public void unloadInstruments(Soundbank soundbank, Patch[] patchList) {
    }

    public void close() {
        this.rec.close();
        this.out.close();
        this.rec = null;
    }

    public MidiDevice.Info getDeviceInfo() {
        return this.out.getDeviceInfo();
    }

    public int getMaxReceivers() {
        return this.out.getMaxReceivers();
    }

    public int getMaxTransmitters() {
        return this.out.getMaxTransmitters();
    }

    public long getMicrosecondPosition() {
        return this.out.getMicrosecondPosition();
    }

    public Receiver getReceiver() throws MidiUnavailableException {
        return this.out.getReceiver();
    }

    public List getReceivers() {
        return this.out.getReceivers();
    }

    public Transmitter getTransmitter() throws MidiUnavailableException {
        return this.out.getTransmitter();
    }

    public List getTransmitters() {
        return this.out.getTransmitters();
    }

    public boolean isOpen() {
        return this.out.isOpen();
    }

    public void open() throws MidiUnavailableException {
        this.out.open();
        this.rec = this.out.getReceiver();
    }

    class ExtChannel
    implements MidiChannel {
        int ich;
        ShortMessage m = new ShortMessage();

        ExtChannel(int i) {
            this.ich = i;
        }

        public void allNotesOff() {
        }

        public void allSoundOff() {
        }

        public void controlChange(int controller, int value) {
            try {
                this.m.setMessage(176, this.ich, controller, value);
                ExtSynth.this.rec.send(this.m, 0L);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        }

        public int getChannelPressure() {
            return 0;
        }

        public int getController(int controller) {
            return 0;
        }

        public boolean getMono() {
            return false;
        }

        public boolean getMute() {
            return false;
        }

        public boolean getOmni() {
            return false;
        }

        public int getPitchBend() {
            return 0;
        }

        public int getPolyPressure(int noteNumber) {
            return 0;
        }

        public int getProgram() {
            return 0;
        }

        public boolean getSolo() {
            return false;
        }

        public boolean localControl(boolean on) {
            return false;
        }

        public void noteOff(int noteNumber) {
            try {
                this.m.setMessage(128, this.ich, noteNumber, 0);
                ExtSynth.this.rec.send(this.m, 0L);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        }

        public void noteOff(int noteNumber, int velocity) {
            try {
                this.m.setMessage(128, this.ich, noteNumber, velocity);
                ExtSynth.this.rec.send(this.m, 0L);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        }

        public void noteOn(int noteNumber, int velocity) {
            try {
                this.m.setMessage(144, this.ich, noteNumber, velocity);
                ExtSynth.this.rec.send(this.m, 0L);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        }

        public void programChange(int program) {
            try {
                this.m.setMessage(192, this.ich, program, 0);
                ExtSynth.this.rec.send(this.m, 0L);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        }

        public void programChange(int bank, int program) {
            try {
                this.m.setMessage(192, this.ich, bank, program);
                ExtSynth.this.rec.send(this.m, 0L);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        }

        public void resetAllControllers() {
        }

        public void setChannelPressure(int pressure) {
        }

        public void setMono(boolean on) {
        }

        public void setMute(boolean mute) {
        }

        public void setOmni(boolean on) {
        }

        public void setPitchBend(int bend) {
            try {
                this.m.setMessage(224, this.ich, bend & 0x7F, bend >> 7 & 0x7F);
                ExtSynth.this.rec.send(this.m, 0L);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        }

        public void setPolyPressure(int noteNumber, int pressure) {
        }

        public void setSolo(boolean soloState) {
        }
    }
}

