/*
 * Decompiled with CFR 0.152.
 */
package piano;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import piano.CounterpointListener;
import piano.PianoPanel;

public class CounterpointPanel
extends JPanel
implements ComponentListener,
ActionListener,
ChangeListener {
    CounterpointListener counterpoint = new CounterpointListener();
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextPane jTextPane1 = new JTextPane();
    PianoPanel piano;
    JPanel jPanel1 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JSlider timeslider = new JSlider();
    JLabel timelabel = new JLabel();

    public CounterpointPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addComponentListener(this);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jLabel1.setText("Timing window");
        this.timeslider.setMajorTickSpacing(0);
        this.timeslider.setMaximum(1200);
        this.timeslider.setPreferredSize(new Dimension(100, 24));
        this.timeslider.setValue(500);
        this.timelabel.setText("500");
        this.setPreferredSize(new Dimension(220, 40));
        this.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.jPanel1, "East");
        this.jPanel1.add((Component)this.jLabel1, null);
        this.jPanel1.add((Component)this.timeslider, null);
        this.jPanel1.add((Component)this.timelabel, null);
        this.jScrollPane1.getViewport().add((Component)this.jTextPane1, null);
        this.timeslider.addChangeListener(this);
    }

    public void componentShown(ComponentEvent e) {
        if (this.piano != null) {
            this.piano.addNoteListener(this.counterpoint);
        }
        this.counterpoint.setActionListener(this);
    }

    public void componentHidden(ComponentEvent e) {
        if (this.piano != null) {
            this.piano.removeNoteListener(this.counterpoint);
        }
        this.counterpoint.setActionListener(null);
        this.counterpoint.reset();
        try {
            this.jTextPane1.getDocument().remove(0, this.jTextPane1.getDocument().getLength() - 1);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (!e.getActionCommand().equals("")) {
            Document d = this.jTextPane1.getDocument();
            try {
                d.insertString(d.getLength(), e.getActionCommand(), null);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        if (e.getSource() instanceof int[]) {
            int[] dat = (int[])e.getSource();
            this.piano.arrows.add(e.getSource());
            this.piano.repaint();
            new RepaintTimer((int)((long)dat[2] - System.currentTimeMillis() + 100L));
        }
    }

    public void stateChanged(ChangeEvent e) {
        int ms = this.timeslider.getValue();
        this.timelabel.setText(String.valueOf(ms));
        this.counterpoint.sequelDelay = ms;
    }

    class RepaintTimer
    implements ActionListener {
        RepaintTimer(int time) {
            Timer t = new Timer(time, this);
            t.setRepeats(false);
            t.setInitialDelay(time);
            t.start();
        }

        public void actionPerformed(ActionEvent e) {
            int t = (int)System.currentTimeMillis();
            int i = 0;
            while (i < CounterpointPanel.this.piano.arrows.size()) {
                int[] data = (int[])CounterpointPanel.this.piano.arrows.get(i);
                if (t > data[2]) {
                    CounterpointPanel.this.piano.arrows.remove(i--);
                }
                ++i;
            }
            CounterpointPanel.this.piano.repaint();
        }
    }
}

