/*
 * Decompiled with CFR 0.152.
 */
package piano;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.Timer;
import piano.ChordAnalyser;
import piano.NoteEvent;
import piano.NoteListener;
import piano.PianoApp;

public class CounterpointListener
implements NoteListener {
    Vector recentlyReleased = new Vector();
    Vector unclaimedPressed = new Vector();
    int sequelDelay = 400;
    Vector unpairedStarts = new Vector();
    HashMap endFromStart = new HashMap();
    HashMap startFromEnd = new HashMap();
    HashMap changeFromEnd = new HashMap();
    HashMap changeFromStart = new HashMap();
    Vector recentChanges = new Vector();
    int changeExpiry = 100;
    int[] badIntervals = new int[]{1, 2, 5, 7, 10, 11, 12};
    String[] intervals = new String[]{"Octave", "Minor second", "Second", "Minor third", "Major third", "Fourth", "Tritone", "Fifth", "Minor sixth", "Major sixth", "Minor seventh", "Major seventh"};
    Comparator noteComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof NoteEvent) || !(o2 instanceof NoteEvent)) {
                throw new IllegalArgumentException("Can't compare " + o2 + " with " + o2);
            }
            return ((NoteEvent)o1).note - ((NoteEvent)o2).note;
        }
    };
    int arrowDelay = 500;
    ActionListener al = null;

    public void noteOn(NoteEvent e) {
        this.unclaimedPressed.add(e);
        this.unpairedStarts.add(e);
    }

    public void noteOff(NoteEvent e) {
        this.recentlyReleased.add(e);
        int i = 0;
        while (i < this.unpairedStarts.size()) {
            NoteEvent st = (NoteEvent)this.unpairedStarts.get(i);
            if (st.note == e.note) {
                this.endOfNote(st, e);
            }
            ++i;
        }
        Timer t = new Timer(this.sequelDelay, new ClaimSequel(e));
        t.setRepeats(false);
        t.setInitialDelay(this.sequelDelay);
        t.start();
    }

    void endOfNote(NoteEvent st, NoteEvent fin) {
        this.endFromStart.put(st, fin);
        this.startFromEnd.put(fin, st);
    }

    void reset() {
        this.endFromStart = new HashMap();
        this.startFromEnd = new HashMap();
        this.changeFromEnd = new HashMap();
        this.changeFromStart = new HashMap();
        this.recentChanges = new Vector();
        this.unpairedStarts = new Vector();
        this.recentlyReleased = new Vector();
        this.unclaimedPressed = new Vector();
    }

    public static final int sign(int value) {
        return value == 0 ? 0 : (value > 0 ? 1 : -1);
    }

    public void setActionListener(ActionListener al) {
        this.al = al;
    }

    public void message(String s) {
        if (this.al != null) {
            this.al.actionPerformed(new ActionEvent(this, 0, s));
        }
    }

    public void message(String s, NoteEvent from, NoteEvent to) {
        int[] data = new int[]{from.note, to.note, (int)(System.currentTimeMillis() + (long)this.arrowDelay)};
        if (this.al != null) {
            this.al.actionPerformed(new ActionEvent(data, 0, s));
        }
    }

    class ClaimSequel
    implements ActionListener {
        NoteEvent releasedNote;

        public void actionPerformed(ActionEvent e) {
            long currtime = System.currentTimeMillis();
            int i = 0;
            while (i < CounterpointListener.this.unclaimedPressed.size()) {
                NoteEvent x = (NoteEvent)CounterpointListener.this.unclaimedPressed.get(i);
                if (this.releasedNote.createTime > x.createTime + (long)CounterpointListener.this.sequelDelay) {
                    CounterpointListener.this.unclaimedPressed.remove(i--);
                } else if (this.releasedNote.note == x.note && this.releasedNote.createTime > x.createTime) {
                    CounterpointListener.this.unclaimedPressed.remove(i--);
                }
                ++i;
            }
            NoteEvent chosenSequel = null;
            Vector candidates = (Vector)CounterpointListener.this.unclaimedPressed.clone();
            int i2 = 0;
            while (i2 < candidates.size()) {
                NoteEvent x = (NoteEvent)candidates.get(i2);
                NoteEvent myStart = (NoteEvent)CounterpointListener.this.startFromEnd.get(this.releasedNote);
                if (myStart != null && myStart.createTime >= x.createTime) {
                    candidates.remove(i2--);
                }
                ++i2;
            }
            if (candidates.size() == CounterpointListener.this.recentlyReleased.size()) {
                Vector recR = (Vector)CounterpointListener.this.recentlyReleased.clone();
                Collections.sort(candidates, CounterpointListener.this.noteComparator);
                Collections.sort(recR, CounterpointListener.this.noteComparator);
                int i3 = recR.indexOf(this.releasedNote);
                if (i3 >= 0) {
                    chosenSequel = (NoteEvent)candidates.get(i3);
                }
            } else {
                int[] scores = new int[candidates.size()];
                int i4 = 0;
                while (i4 < candidates.size()) {
                    NoteEvent sq = (NoteEvent)candidates.get(i4);
                    int n = i4++;
                    int tmp = sq.note - this.releasedNote.note;
                    scores[n] = scores[n] + (127 - tmp * tmp);
                }
                int hiscore = Integer.MIN_VALUE;
                NoteEvent hiscorer = null;
                int i5 = 0;
                while (i5 < scores.length) {
                    if (scores[i5] > hiscore) {
                        hiscore = scores[i5];
                        hiscorer = (NoteEvent)candidates.get(i5);
                    }
                    ++i5;
                }
                chosenSequel = hiscorer;
            }
            if (chosenSequel != null) {
                CounterpointListener.this.unclaimedPressed.remove(chosenSequel);
            }
            CounterpointListener.this.recentlyReleased.remove(this.releasedNote);
            if (chosenSequel != null) {
                this.foundNextNote(this.releasedNote, chosenSequel);
            }
        }

        private void foundNextNote(NoteEvent releasedNote, NoteEvent chosenSequel) {
            CounterpointListener.this.message(String.valueOf(PianoApp.keyName[releasedNote.note % 12]) + "-" + PianoApp.keyName[chosenSequel.note % 12] + ", ", releasedNote, chosenSequel);
            int currtime = (int)System.currentTimeMillis();
            int i = 0;
            while (i < CounterpointListener.this.recentChanges.size()) {
                Change c = (Change)CounterpointListener.this.recentChanges.get(i);
                if (currtime > c.time + CounterpointListener.this.changeExpiry) {
                    CounterpointListener.this.recentChanges.remove(i--);
                } else {
                    int ch1 = chosenSequel.note - releasedNote.note;
                    int ch2 = c.to.note - c.from.note;
                    if (CounterpointListener.sign(ch1) == CounterpointListener.sign(ch2) && !this.areSameVoice(releasedNote, c.from)) {
                        int i2;
                        int i1 = Math.abs(chosenSequel.note - c.to.note);
                        if (i1 == (i2 = Math.abs(releasedNote.note - c.from.note))) {
                            if (ChordAnalyser.indexOf(ChordAnalyser.toDeg(i2), CounterpointListener.this.badIntervals) >= 0) {
                                CounterpointListener.this.message(" *Parallel " + CounterpointListener.this.intervals[ChordAnalyser.toDeg(i2)] + "*");
                            }
                        } else if (ChordAnalyser.indexOf(ChordAnalyser.toDeg(i1), CounterpointListener.this.badIntervals) >= 0) {
                            CounterpointListener.this.message("Parallel voicing ending on a " + CounterpointListener.this.intervals[ChordAnalyser.toDeg(i1)]);
                        }
                    }
                }
                ++i;
            }
            CounterpointListener.this.recentChanges.add(new Change(releasedNote, chosenSequel, currtime));
        }

        boolean areSameVoice(NoteEvent off1, NoteEvent off2) {
            return this.recurseSameVoice(off1, off2, off1, off2);
        }

        boolean recurseSameVoice(NoteEvent o1, NoteEvent o2, NoteEvent n1, NoteEvent n2) {
            Change c2;
            NoteEvent s2;
            Change c1;
            NoteEvent s1;
            NoteEvent newoff1 = null;
            NoteEvent newoff2 = null;
            if (n1 != null && (s1 = (NoteEvent)CounterpointListener.this.startFromEnd.get(n1)) != null && (c1 = (Change)CounterpointListener.this.changeFromEnd.get(s1)) != null && o2 == (newoff1 = c1.from)) {
                return true;
            }
            if (n2 != null && (s2 = (NoteEvent)CounterpointListener.this.startFromEnd.get(n2)) != null && (c2 = (Change)CounterpointListener.this.changeFromEnd.get(s2)) != null && o1 == (newoff2 = c2.from)) {
                return true;
            }
            if (newoff1 == null && newoff2 == null) {
                return false;
            }
            return this.recurseSameVoice(o1, o2, newoff1, newoff2);
        }

        ClaimSequel(NoteEvent releasedNote) {
            this.releasedNote = releasedNote;
        }

        class Change {
            NoteEvent from;
            NoteEvent to;
            int time;

            Change(NoteEvent from, NoteEvent to, int time) {
                this.from = from;
                this.to = to;
                this.time = time;
                ((ClaimSequel)ClaimSequel.this).CounterpointListener.this.changeFromEnd.put(to, this);
                ((ClaimSequel)ClaimSequel.this).CounterpointListener.this.changeFromStart.put(from, this);
            }
        }
    }
}

