/*
 * Decompiled with CFR 0.152.
 */
package piano;

import improviser.Chord;
import improviser.SongData;
import improviser.gui.SongEditorPane;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.ObjectInputStream;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import piano.ImproviserPlayer;
import piano.PianoPanel;

public class ChordSequencePanel
extends SongEditorPane {
    public DragListener dl = new DragListener();
    JToggleButton playbutton = new JToggleButton("Play");
    Action openAction = new AbstractAction("Open"){

        public void actionPerformed(ActionEvent e) {
            ChordSequencePanel.this.fileOpen();
        }
    };
    JButton openButton = new JButton(this.openAction);
    JCheckBox basschk = new JCheckBox();
    JCheckBox chordchk = new JCheckBox();
    JCheckBox melchk = new JCheckBox();
    JCheckBox drumchk = new JCheckBox();
    JCheckBox thruchk = new JCheckBox();
    PianoPanel piano;
    ActionListener selectlistener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (ChordSequencePanel.this.playbutton.isSelected()) {
                return;
            }
            int ix = ChordSequencePanel.this.songDisplay.getSelected();
            if (ix < 0) {
                return;
            }
            Chord curr = ChordSequencePanel.this.getSong().getChord(ix);
            int[] n = curr.getChordNotes();
            if (ChordSequencePanel.this.piano != null) {
                ChordSequencePanel.this.playChord(n);
            }
        }
    };
    ActionListener chkchange = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (ChordSequencePanel.this.playbutton.isSelected()) {
                ChordSequencePanel.this.playbutton.doClick();
            }
            if (ChordSequencePanel.this.player != null) {
                ChordSequencePanel.this.setActiveTracks(ChordSequencePanel.this.player);
            }
        }
    };
    int chordDuration = 250;
    int octave = 5;
    ActionListener playlistener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (ChordSequencePanel.this.playbutton.isSelected()) {
                ChordSequencePanel.this.play();
            } else {
                ChordSequencePanel.this.stop();
            }
        }
    };
    ImproviserPlayer player;
    JFileChooser filer;

    public ChordSequencePanel() {
        this.panel1.setPreferredSize(new Dimension(100, 32));
        this.setPreferredSize(new Dimension(100, 40));
        this.setSong(new SongData());
        this.panel1.add(this.playbutton);
        this.basschk.setText("Bass");
        this.chordchk.setText("Chord");
        this.melchk.setText("Solo");
        this.drumchk.setText("Drum");
        this.thruchk.setText("Merge");
        this.thruchk.setToolTipText("Outputs the improvised elements into the piano keyboard");
        this.chordchk.setSelected(true);
        this.basschk.addActionListener(this.chkchange);
        this.chordchk.addActionListener(this.chkchange);
        this.melchk.addActionListener(this.chkchange);
        this.songDisplay.addActionListener(this.selectlistener);
        this.playbutton.addActionListener(this.playlistener);
        this.songDisplay.removeMouseListener(this.songDisplay.ml);
        this.songDisplay.addMouseListener(this.dl);
        this.songDisplay.addMouseMotionListener(this.dl);
        try {
            this.filer = new JFileChooser();
            this.panel1.add(this.openButton);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        this.panel1.add(this.basschk);
        this.panel1.add(this.chordchk);
        this.panel1.add(this.drumchk);
        this.panel1.add(this.melchk);
        this.panel1.add(this.thruchk);
    }

    void playChord(final int[] n) {
        int i = 0;
        while (i < n.length) {
            int k = n[i] + 12 * this.octave;
            this.piano.keyDown(k);
            this.piano.isHeld[k] = true;
            this.piano.repaint(k);
            ++i;
        }
        Timer t = new Timer(this.chordDuration, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int i = 0;
                while (i < n.length) {
                    int k = n[i] + 12 * ChordSequencePanel.this.octave;
                    ChordSequencePanel.this.piano.keyUp(k);
                    ChordSequencePanel.this.piano.isHeld[k] = false;
                    ChordSequencePanel.this.piano.repaint(k);
                    ++i;
                }
            }
        });
        t.setRepeats(false);
        t.setInitialDelay(this.chordDuration);
        t.start();
    }

    void play() {
        this.player = new ImproviserPlayer(this.getSong(), this.piano);
        this.setActiveTracks(this.player);
        this.player.startChordIndex = this.getSelected();
        if (this.player.startChordIndex < 0) {
            this.player.startChordIndex = 0;
        }
        this.player.editorPane = this;
        this.player.followScoreSelection = true;
        this.player.followScoreScroll = false;
        this.player.start();
    }

    void stop() {
        if (this.player != null) {
            this.player.stop();
            int i = 0;
            while (i < this.player.tracks.length) {
                this.player.tracks[i].turnOffChord();
                ++i;
            }
        }
    }

    public void setActiveTracks(ImproviserPlayer p) {
        p.bassTrack.trackActive = this.basschk.isSelected();
        p.chordsTrack.trackActive = this.chordchk.isSelected();
        p.soloTrack.trackActive = this.melchk.isSelected();
        p.drumsTrack.trackActive = this.drumchk.isSelected();
        p.thru = this.thruchk.isSelected();
    }

    void fileOpen() {
        int res = this.filer.showOpenDialog(this);
        if (res == 1) {
            return;
        }
        File file = this.filer.getSelectedFile();
        if (file == null) {
            return;
        }
        try {
            URL f = file.toURL();
            SongData d = (SongData)new ObjectInputStream(f.openStream()).readObject();
            this.setSong(d);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.toString(), "Error opening file", 0);
        }
    }

    class DragListener
    extends MouseAdapter
    implements MouseMotionListener {
        DragListener() {
        }

        public void mousePressed(MouseEvent e) {
            int[] p = ChordSequencePanel.this.songDisplay.xToTime(e.getX());
            int index = ChordSequencePanel.this.getSong().chordIndexAtTime(p);
            if (index == -1 || index == -2) {
                ChordSequencePanel.this.setSelected(-1);
            } else {
                ChordSequencePanel.this.setSelected(index);
            }
            ChordSequencePanel.this.repaint();
        }

        public void mouseDragged(MouseEvent e) {
            int[] p = ChordSequencePanel.this.songDisplay.xToTime(e.getX());
            int index = ChordSequencePanel.this.getSong().chordIndexAtTime(p);
            if (index != ChordSequencePanel.this.getSelected()) {
                if (index == -1 || index == -2) {
                    ChordSequencePanel.this.setSelected(-1);
                } else {
                    ChordSequencePanel.this.setSelected(index);
                }
                ChordSequencePanel.this.repaint();
            }
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

