/*
 * Decompiled with CFR 0.152.
 */
package piano;

import improviser.Chord;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import piano.ChordAnalyser;
import piano.ChordSequencePanel;
import piano.PianoPanel;

public class ChordSelect
extends JPanel
implements ListSelectionListener,
ItemListener,
ChangeListener,
ActionListener {
    public String chfile = "Chords.properties";
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JToggleButton jButton1 = new JToggleButton();
    Box box1;
    JList catlist = new JList();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList chlist = new JList();
    JScrollPane jScrollPane2 = new JScrollPane();
    BorderLayout borderLayout2 = new BorderLayout();
    ListModel catmodel;
    DefaultComboBoxModel chmodel = new DefaultComboBoxModel();
    String currChord = null;
    int octave = 5;
    int[] currentNotes = null;
    PianoPanel piano;
    boolean playing = false;
    int invert = 0;
    JPanel jPanel3 = new JPanel();
    JSpinner inversion = new JSpinner();
    JLabel jLabel1 = new JLabel();
    SpinnerNumberModel invmodel = new SpinnerNumberModel();
    JCheckBox omitroot = new JCheckBox();
    JCheckBox omitfifth = new JCheckBox();
    JButton tochanges = new JButton();
    Action toChangesAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            Chord c = ChordSelect.this.createChord();
            ChordSelect.this.chordSequencePanel.insertChord(c);
        }
    };
    ChordSequencePanel chordSequencePanel;

    public ChordSelect() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] s = this.getStringList(this.chfile, "Chords");
        if (s != null) {
            this.catmodel = new DefaultComboBoxModel<String>(s);
            this.catlist.setModel(this.catmodel);
            this.catlist.setSelectedIndex(0);
        }
        this.setPreferredSize(new Dimension(10, 40));
        this.invmodel.setMaximum(new Integer(2));
        this.invmodel.setMinimum(new Integer(0));
        this.invmodel.setValue(new Integer(0));
    }

    private void jbInit() throws Exception {
        this.box1 = Box.createHorizontalBox();
        this.setLayout(this.borderLayout1);
        this.jButton1.setText("Play");
        this.jPanel1.setLayout(this.borderLayout2);
        this.chlist.setModel(this.chmodel);
        this.catlist.addListSelectionListener(this);
        this.chlist.addListSelectionListener(this);
        this.jLabel1.setText("Inversion");
        this.inversion.setModel(this.invmodel);
        this.omitroot.setText("Omit root");
        this.jPanel3.setPreferredSize(new Dimension(132, 33));
        this.omitfifth.setText("Omit fifth");
        this.tochanges.setText("Add to changes");
        this.jPanel3.add((Component)this.jLabel1, null);
        this.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.box1, "Center");
        this.box1.add((Component)this.jScrollPane1, null);
        this.box1.add((Component)this.jScrollPane2, null);
        this.box1.add((Component)this.jPanel3, null);
        this.jPanel3.add((Component)this.inversion, null);
        this.jPanel3.add((Component)this.omitroot, null);
        this.jPanel3.add((Component)this.omitfifth, null);
        this.jScrollPane2.getViewport().add((Component)this.chlist, null);
        this.jScrollPane1.getViewport().add((Component)this.catlist, null);
        this.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.jButton1, null);
        this.jPanel2.add((Component)this.tochanges, null);
        this.jButton1.addItemListener(this);
        this.inversion.addChangeListener(this);
        this.omitroot.addActionListener(this);
        this.omitfifth.addActionListener(this);
        this.tochanges.addActionListener(this.toChangesAction);
    }

    public String[] getStringList(String resource, String prop) {
        Properties p = this.getProperties(resource);
        String l = p.getProperty(prop);
        if (l == null) {
            return null;
        }
        String[] e = l.split("\\s*,\\s*");
        return e;
    }

    public int[] getIntList(String resource, String prop) {
        if (prop == null) {
            return null;
        }
        String[] e = this.getStringList(resource, prop);
        if (e == null) {
            return null;
        }
        int[] x = new int[e.length];
        int i = 0;
        while (i < e.length) {
            x[i] = Integer.parseInt(e[i]);
            ++i;
        }
        return x;
    }

    public Properties getProperties(String resource) {
        Properties p = new Properties();
        try {
            p.load(this.getClass().getResourceAsStream(resource));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return p;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.catlist) {
            String s = (String)this.catlist.getSelectedValue();
            if (s != null) {
                String[] ch = this.getStringList(this.chfile, s);
                if (ch == null) {
                    this.chmodel.removeAllElements();
                    return;
                }
                this.chmodel = new DefaultComboBoxModel<String>(ch);
                this.chlist.setModel(this.chmodel);
            } else {
                this.chmodel.removeAllElements();
            }
        } else if (e.getSource() == this.chlist) {
            int[] n;
            String s = (String)this.chlist.getSelectedValue();
            if (this.currChord != s && (n = this.getIntList(this.chfile, s)) != null) {
                boolean wasPlaying = this.playing;
                if (wasPlaying) {
                    this.playOff();
                }
                this.currentNotes = n;
                if (wasPlaying) {
                    this.playOn();
                }
                if (n != null) {
                    this.invmodel.setMaximum(new Integer(n.length - 1));
                    if ((Integer)this.invmodel.getValue() > n.length - 1) {
                        this.invmodel.setValue(this.invmodel.getMaximum());
                    }
                }
            }
            this.currChord = s;
        }
    }

    public void playOn() {
        this.playing = true;
        boolean or = this.omitroot.isSelected();
        boolean of = this.omitfifth.isSelected();
        if (this.currentNotes == null) {
            return;
        }
        int i = 0;
        while (i < this.currentNotes.length) {
            int ni = this.currentNotes[i];
            int n = ni + this.piano.getKeyNote() + 12 * this.octave;
            if (!(or && ni == 0 || of && ni == 7)) {
                if (i < this.invert) {
                    n += 12;
                }
                this.piano.keyDown(n);
                this.piano.isHeld[n] = true;
            }
            ++i;
        }
        this.piano.repaint();
    }

    public void playOff() {
        if (this.currentNotes == null) {
            return;
        }
        int i = 0;
        while (i < this.currentNotes.length) {
            int n = this.currentNotes[i] + this.piano.getKeyNote() + 12 * this.octave;
            if (i < this.invert) {
                n += 12;
            }
            this.piano.keyUp(n);
            this.piano.isHeld[n] = false;
            ++i;
        }
        this.piano.repaint();
        this.playing = false;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.jButton1) {
            if (e.getStateChange() == 1) {
                this.playOn();
            } else if (e.getStateChange() == 2) {
                this.playOff();
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.inversion) {
            boolean wasPlaying = this.playing;
            if (wasPlaying) {
                this.playOff();
            }
            this.invert = (Integer)this.invmodel.getValue();
            if (wasPlaying) {
                this.playOn();
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if ((e.getSource() == this.omitroot || e.getSource() == this.omitfifth) && this.playing) {
            this.playOff();
            this.playOn();
        }
    }

    Chord createChord() {
        int k = this.piano.getKeyNote();
        Chord c = new Chord(k, "");
        String name = this.chlist.getSelectedValue().toString();
        if (name.startsWith("Minor")) {
            this.initChord(c, 0);
        }
        if (name.startsWith("Seventh")) {
            this.initChord(c, 3);
        }
        if (name.startsWith("Half")) {
            this.initChord(c, 4);
        }
        if (name.startsWith("Augmented")) {
            this.initChord(c, 5);
            c.typeName = "+";
        }
        if (name.indexOf("arp.ninth") >= 0) {
            this.initChord(c, 5);
        }
        if (name.startsWith("Diminished")) {
            this.initChord(c, 6);
        }
        int deg = ChordSelect.degreesFromNotes(this.currentNotes);
        if (this.omitroot.isSelected()) {
            deg &= 0xFFFFFFFE;
        }
        if (this.omitfifth.isSelected()) {
            deg &= 0xFFFFFF7F;
        }
        c.chordDegrees = deg;
        c.longName = name;
        return c;
    }

    void initChord(Chord c, int typeIndex) {
        c.typeIndex = typeIndex;
        c.chordDegrees = Chord.getAllChordNotes()[typeIndex][0];
        c.scaleDegrees = Chord.getAllChordNotes()[typeIndex][1];
        c.typeName = Chord.getAllChordNames()[typeIndex][1];
        c.longName = Chord.getAllChordNames()[typeIndex][0];
    }

    public static final int degreesFromNotes(int[] n) {
        int z = 0;
        int i = 0;
        while (i < n.length) {
            z |= 1 << ChordAnalyser.toDeg(n[i]);
            ++i;
        }
        return z;
    }
}

