/*
 * Decompiled with CFR 0.152.
 */
package piano;

import improviser.Chord;
import improviser.Note;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import piano.ChordSequencePanel;
import piano.NoteEvent;
import piano.NoteListener;
import piano.PianoApp;
import piano.PianoPanel;

public class ChordAnalyser
extends JPanel
implements NoteListener {
    JScrollPane jScrollPane1 = new JScrollPane();
    JList jList1 = new JList();
    BorderLayout borderLayout1 = new BorderLayout();
    PianoPanel piano;
    DefaultListModel model = new DefaultListModel();
    JPanel jPanel1 = new JPanel();
    JCheckBox slashcheck = new JCheckBox();
    JCheckBox guessrootcheck = new JCheckBox();
    ChordSequencePanel chordSequencePanel;
    Action toChangesAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            Chord c = ChordAnalyser.this.createChord();
            ChordAnalyser.this.chordSequencePanel.insertChord(c);
        }
    };
    boolean slash = true;
    boolean guessRoot = true;
    int[][] patterns;
    String[] patternName;
    int[][] hiddenRoots;
    String[] hiddenRootNames;
    JCheckBox sortcheck;
    JButton addtochanges;
    JPanel jPanel2;
    GridLayout gridLayout1;

    public ChordAnalyser() {
        int[][] nArrayArray = new int[5][];
        int[] nArray = new int[3];
        nArray[1] = 3;
        nArray[2] = 6;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[1] = 3;
        nArray2[2] = 6;
        nArray2[3] = 9;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[1] = 3;
        nArray3[2] = 6;
        nArray3[3] = 10;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[1] = 4;
        nArray4[2] = 7;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[1] = 3;
        nArray5[2] = 7;
        nArrayArray[4] = nArray5;
        this.patterns = nArrayArray;
        this.patternName = new String[]{"dim", "dim7", "half dim", "", "m"};
        this.hiddenRoots = new int[][]{{10, 2, 4}, {10, 2, 4, 7}, {10, 2, 4, 6}, {11, 2, 3, 7}, {9, 11, 2, 3}, {9, 11, 2, 3, 7}, {10, 2, 3}, {10, 2, 3, 7}, {11, 2, 4}, {11, 2, 4, 7}, {9, 2, 3, 7}, {9, 2, 4, 7}, {4, 8, 10, 3}, {9, 10, 2, 4}};
        this.hiddenRootNames = new String[]{" 7,9", " 7,9", " 7,9,#11", "m maj7,9", "m maj7,13", "m maj7,13", "m7,9", "m7,9", "maj7,9", "maj7,9", "m 6,9", "9,13", "m6,#9", "7,13"};
        this.sortcheck = new JCheckBox();
        this.addtochanges = new JButton();
        this.jPanel2 = new JPanel();
        this.gridLayout1 = new GridLayout();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jList1.setModel(this.model);
        this.slashcheck.setToolTipText("");
        this.slashcheck.setText("Slash notation");
        this.guessrootcheck.setText("Guess root");
        this.sortcheck.setText("Sort");
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                if (ChordAnalyser.this.piano != null) {
                    ChordAnalyser.this.piano.addNoteListener(ChordAnalyser.this);
                }
                ChordAnalyser.this.noteChange();
            }

            public void componentHidden(ComponentEvent e) {
                if (ChordAnalyser.this.piano != null) {
                    ChordAnalyser.this.piano.removeNoteListener(ChordAnalyser.this);
                }
            }
        });
        this.addtochanges.setText("Add to changes");
        this.jPanel2.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(3);
        this.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.jPanel1, "East");
        this.jPanel1.add((Component)this.jPanel2, null);
        this.jPanel1.add((Component)this.addtochanges, null);
        this.jPanel2.add((Component)this.sortcheck, null);
        this.jPanel2.add((Component)this.guessrootcheck, null);
        this.jPanel2.add((Component)this.slashcheck, null);
        this.jScrollPane1.getViewport().add((Component)this.jList1, null);
        this.sortcheck.setSelected(true);
        this.addtochanges.addActionListener(this.toChangesAction);
    }

    public void noteChange() {
        if (!this.isShowing()) {
            return;
        }
        this.slash = this.slashcheck.isSelected();
        this.guessRoot = this.guessrootcheck.isSelected();
        this.model.removeAllElements();
        String[] c = this.getChords();
        if (c != null) {
            int i = 0;
            while (i < c.length) {
                this.model.addElement(c[i]);
                ++i;
            }
        }
    }

    public Vector sortChordList(Vector os) {
        Vector s = new Vector(new HashSet(os));
        if (!this.sortcheck.isSelected()) {
            return s;
        }
        Collections.sort(s, new Comparator(){

            public boolean equals(Object obj) {
                return false;
            }

            public int compare(Object o1, Object o2) {
                return ((String)o1).length() - ((String)o2).length();
            }
        });
        return s;
    }

    public String[] getChords() {
        String[] s;
        Vector chords = new Vector();
        Vector<Integer> notes = new Vector<Integer>();
        Vector<Integer> degrees = new Vector<Integer>();
        boolean[] p = new boolean[12];
        int i = 0;
        while (i < this.piano.N) {
            if (this.piano.isHeld[i]) {
                notes.add(new Integer(i));
                degrees.add(new Integer(i % 12));
                p[i % 12] = true;
            }
            ++i;
        }
        int NN = degrees.size();
        if (NN < 3) {
            return null;
        }
        Collections.sort(degrees);
        Integer[] deg = degrees.toArray(new Integer[NN]);
        int root = (Integer)notes.get(0);
        int startIdx = 0;
        int i2 = 0;
        while (i2 < deg.length) {
            if (deg[i2] == root) {
                startIdx = i2;
            }
            ++i2;
        }
        if (this.guessRoot && (s = this.findHiddenRoot(p)) != null) {
            int i3 = 0;
            while (i3 < s.length) {
                chords.add(s[i3]);
                ++i3;
            }
        }
        i = 0;
        while (i < deg.length) {
            StringBuffer chord = new StringBuffer();
            int r = deg[(i + startIdx) % deg.length];
            if (this.slash && NN > 3 && r != root) {
                boolean[] np = (boolean[])p.clone();
                np[root % 12] = false;
                int nr = 0;
                while (nr < 12) {
                    String m = this.tryMatchPattern(nr, np);
                    if (m != null) {
                        chords.add(String.valueOf(PianoApp.keyName[nr]) + m + "/" + PianoApp.keyName[root % 12]);
                    }
                    ++nr;
                }
            }
            chord.append(PianoApp.keyName[r]);
            String t = this.tryMatchPattern(r, p);
            if (t != null) {
                chord.append(t);
                chords.add(chord.toString());
            } else {
                if (ChordAnalyser.hasDeg(3, r, p) && !ChordAnalyser.hasDeg(4, r, p)) {
                    chord.append("m ");
                }
                if (ChordAnalyser.hasDeg(11, r, p) && !ChordAnalyser.hasDeg(10, r, p)) {
                    chord.append(" maj7 ");
                }
                if (ChordAnalyser.hasDeg(10, r, p) && !ChordAnalyser.hasDeg(11, r, p)) {
                    chord.append("7 ");
                }
                if (ChordAnalyser.hasDeg(10, r, p) && ChordAnalyser.hasDeg(11, r, p)) {
                    chord.append(" maj/min7 ");
                }
                if (ChordAnalyser.hasDeg(1, r, p)) {
                    chord.append(" b9 ");
                }
                if (ChordAnalyser.hasDeg(2, r, p)) {
                    chord.append("9 ");
                }
                if (ChordAnalyser.hasDeg(6, r, p)) {
                    chord.append(" #11 ");
                }
                if (ChordAnalyser.hasDeg(8, r, p)) {
                    chord.append(" m6 ");
                }
                if (ChordAnalyser.hasDeg(9, r, p)) {
                    chord.append("13 ");
                }
                if (ChordAnalyser.hasDeg(3, r, p) && ChordAnalyser.hasDeg(4, r, p)) {
                    chord.append(" #9 ");
                }
                if (ChordAnalyser.hasDeg(5, r, p)) {
                    chord.append(" sus4");
                }
                chords.add(chord.toString());
            }
            ++i;
        }
        chords = this.sortChordList(chords);
        return chords.toArray(new String[chords.size()]);
    }

    String[] findHiddenRoot(boolean[] b) {
        Vector<String> g = new Vector<String>();
        int i = 0;
        while (i < this.hiddenRoots.length) {
            int r = 0;
            while (r < 12) {
                if (this.matches(this.hiddenRoots[i], b, r)) {
                    g.add(String.valueOf(PianoApp.keyName[r]) + this.hiddenRootNames[i]);
                }
                ++r;
            }
            ++i;
        }
        if (g.size() == 0) {
            return null;
        }
        return g.toArray(new String[g.size()]);
    }

    public Chord createChord() {
        String s = this.getChords()[0];
        int r = Note.value(s.substring(0, 1));
        int nc = s.length() == 1 ? 1 : (s.charAt(1) == '#' || s.charAt(1) == 'b' ? 2 : 1);
        String sym = s.substring(nc);
        Chord c = new Chord(r, sym);
        c.keyNote = r;
        c.typeName = sym;
        c.chordDegrees = 0;
        int[] notes = this.piano.getCurrentNotes();
        int i = 0;
        while (i < notes.length) {
            c.chordDegrees |= 1 << (notes[i] - r + 12) % 12;
            ++i;
        }
        return c;
    }

    private String tryMatchPattern(int r, boolean[] p) {
        int i = 0;
        while (i < this.patterns.length) {
            if (this.matches(this.patterns[i], p, r)) {
                return this.patternName[i];
            }
            ++i;
        }
        return null;
    }

    boolean matches(int[] degrees, boolean[] flags, int root) {
        int i = 0;
        while (i < 12) {
            boolean insc = false;
            int j = 0;
            while (j < degrees.length) {
                if (degrees[j] == i) {
                    insc = true;
                    break;
                }
                ++j;
            }
            if (flags[ChordAnalyser.toDeg(i + root)] != insc) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static final boolean hasDeg(int deg, int root, boolean[] b) {
        return b[ChordAnalyser.toDeg(deg + root)];
    }

    public static final int toDeg(int n) {
        while (n > 11) {
            n -= 12;
        }
        while (n < 0) {
            n += 12;
        }
        return n;
    }

    public static final int indexOf(int x, int[] y) {
        int i = 0;
        while (i < y.length) {
            if (y[i] == x) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void noteOn(NoteEvent e) {
        this.noteChange();
    }

    public void noteOff(NoteEvent e) {
        this.noteChange();
    }
}

