/*
 * Decompiled with CFR 0.152.
 */
package piano;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import piano.FFT;
import piano.PianoPanel;

public class AudioListenPanel
extends JPanel
implements ComponentListener,
Runnable,
ChangeListener,
ActionListener {
    Box box1;
    JProgressBar[] bar = new JProgressBar[3];
    JSlider threshsl = new JSlider();
    JLabel threshtxt = new JLabel();
    JCheckBox multinote = new JCheckBox();
    AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 8, 1, 1, 22050.0f, false);
    TargetDataLine line;
    Thread thread = new Thread((Runnable)this, "Audio receiver");
    Mixer mixer;
    boolean isActive = false;
    FFT fft = new FFT();
    int count = 0;
    int fftLength = 0;
    float MAGN_THRESHOLD = 1.0f;
    int MAX_BUF = 4096;
    int MIN_BUF = 1024;
    float noteThreshold = 10.0f;
    float SAMPLE_FREQ = 22500.0f;
    boolean kill = false;
    JLabel jLabel1 = new JLabel();
    boolean allowmultinotes = false;
    PianoPanel piano;
    int currpk = -1;
    int currnote = -1;
    double topiperfft;
    double bottomiperfft;
    static /* synthetic */ Class class$0;

    public AudioListenPanel() {
        int i = 0;
        while (i < this.bar.length) {
            this.bar[i] = new JProgressBar();
            this.bar[i].setMaximum(256);
            ++i;
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.initAudio();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error("No Audio Available :" + e);
        }
    }

    private void jbInit() throws Exception {
        this.box1 = Box.createVerticalBox();
        this.jLabel1.setPreferredSize(new Dimension(160, 15));
        this.jLabel1.setText("jLabel1");
        this.threshsl.setMaximum(80);
        this.threshsl.setPreferredSize(new Dimension(100, 24));
        this.threshtxt.setText("0");
        this.multinote.setText("Multiple notes");
        this.add((Component)this.box1, null);
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.threshsl, null);
        this.add((Component)this.threshtxt, null);
        this.add((Component)this.multinote, null);
        this.addComponentListener(this);
        this.threshsl.addChangeListener(this);
        this.multinote.addActionListener(this);
        int i = 0;
        while (i < this.bar.length) {
            this.box1.add((Component)this.bar[i], null);
            ++i;
        }
        this.setPreferredSize(new Dimension(10, 40));
        this.threshsl.setValue(25);
    }

    void initAudio() throws LineUnavailableException {
        DataLine.Info info;
        Class<?> clazz;
        if (this.line != null && this.line.isOpen()) {
            this.line.stop();
            this.line.close();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("javax.sound.sampled.TargetDataLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!AudioSystem.isLineSupported(info = new DataLine.Info(clazz, this.format))) {
            throw new IllegalStateException("format " + this.format + " not supported");
        }
        this.line = this.mixer != null ? (TargetDataLine)this.mixer.getLine(info) : (TargetDataLine)AudioSystem.getLine(info);
        if (this.line == null) {
            throw new IllegalStateException("Device not ready?");
        }
    }

    public void setMixer(Mixer mix) {
        this.mixer = mix;
        try {
            this.initAudio();
        }
        catch (Exception e) {
            this.error(String.valueOf(mix.getMixerInfo().getName()) + " :" + e);
        }
    }

    public void componentHidden(ComponentEvent e) {
        this.isActive = false;
        if (this.line != null) {
            this.line.stop();
            this.line.close();
        }
    }

    public void componentShown(ComponentEvent e) {
        if (this.line != null) {
            try {
                this.jLabel1.setText("opening " + this.line);
                this.line.open(this.format, 4096);
                this.isActive = true;
                if (!this.thread.isAlive()) {
                    this.thread.start();
                }
                this.initValues();
                this.line.start();
            }
            catch (LineUnavailableException ex) {
                this.error(ex.toString());
            }
        }
    }

    private void initValues() {
        this.topiperfft = Math.exp((double)((this.piano.N + 37) / 12) * Math.log(2.0)) / (double)this.SAMPLE_FREQ;
        this.bottomiperfft = Math.exp(3.0 * Math.log(2.0)) / (double)this.SAMPLE_FREQ;
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    void error(String e) {
        this.jLabel1.setText(e);
        System.err.println(e);
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void processBuffer(byte[] buffer) {
        if (buffer.length > 0) {
            int max = 0;
            float[] x = new float[buffer.length];
            int i = 0;
            while (i < buffer.length) {
                x[i] = buffer[i];
                max = Math.max(max, buffer[i]);
                ++i;
            }
            this.fftLength = (int)Math.pow(2.0, (int)(Math.log(buffer.length) / Math.log(2.0)) - 1);
            float[] f = this.fft.fftMag(x, this.fftLength);
            if (this.allowmultinotes) {
                this.checkSpectrumAllNotes(f);
            } else {
                this.checkSpectrumForPeaks(f);
            }
            this.bar[0].setValue(Math.min(255, max));
            this.bar[1].setValue(Math.min(255, 255 * buffer.length / this.MAX_BUF));
        }
    }

    public void finalize() throws Throwable {
        if (this.line != null) {
            this.line.stop();
            this.line.close();
        }
        this.isActive = false;
        this.kill = true;
        super.finalize();
    }

    private final void checkSpectrumForPeaks(float[] f) {
        int pk = -1;
        float pkval = Float.MIN_VALUE;
        int i = 0;
        while (i < f.length) {
            if (f[i] > pkval) {
                pk = i;
                pkval = f[i];
            }
            ++i;
        }
        if (pkval < this.MAGN_THRESHOLD) {
            pk = -1;
        }
        if (this.currpk != pk) {
            double freq = -1.0;
            if (this.currnote >= 0) {
                this.setNote(this.currnote, false);
            }
            this.currpk = pk;
            if (pk < 0) {
                this.currnote = -1;
            } else {
                freq = (float)pk * this.SAMPLE_FREQ / (float)this.fftLength;
                this.currnote = (int)(12.0 * Math.log(freq) / Math.log(2.0)) - 36;
                this.currnote = Math.max(0, Math.min(this.piano.N - 1, this.currnote));
                this.setNote(this.currnote, true);
            }
            this.jLabel1.setText("pk=" + freq + ", mag=" + pkval);
            this.piano.repaint();
        }
    }

    public void setNote(int note, boolean down) {
        if (this.piano.isHeld[note] && !down) {
            this.piano.isHeld[note] = false;
            this.piano.keyUp(note, false);
        } else if (!this.piano.isHeld[note] && down) {
            this.piano.isHeld[note] = true;
            this.piano.keyDown(note, this.piano.getVol(), false);
        }
    }

    private final void checkSpectrumAllNotes(float[] f) {
        int i = 1;
        while (i < f.length) {
            if (!((double)i > this.topiperfft * (double)this.fftLength) && !((double)i < this.bottomiperfft * (double)this.fftLength)) {
                int note = Math.max(0, Math.min(this.piano.N - 1, (int)(12.0 * Math.log((float)i * this.SAMPLE_FREQ / (float)this.fftLength) / Math.log(2.0)) - 36));
                if ((double)f[i] > (double)this.noteThreshold / Math.log(i)) {
                    this.setNote(note, true);
                } else {
                    this.setNote(note, false);
                }
            }
            ++i;
        }
        this.piano.repaint();
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    public void stateChanged(ChangeEvent e) {
        int v = this.threshsl.getValue();
        this.threshtxt.setText(String.valueOf(v));
        this.noteThreshold = v;
        this.MAGN_THRESHOLD = (float)v * 2.0f / (float)this.threshsl.getMaximum();
    }

    public void actionPerformed(ActionEvent e) {
        this.allowmultinotes = this.multinote.isSelected();
    }
}

