/*
 * Decompiled with CFR 0.152.
 */
package improviser.sound;

import improviser.SongData;
import improviser.sound.BassWith25;
import improviser.sound.BebopSolo;
import improviser.sound.Chords37;
import improviser.sound.MelodicSolo;
import improviser.sound.Player;
import improviser.sound.SimpleBass;
import improviser.sound.SimpleDrums;
import improviser.sound.Track;
import java.applet.Applet;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Random;
import javax.swing.JOptionPane;

public class WebImproviser
extends Applet
implements Runnable {
    SongData song;
    Player player;
    BebopSolo solo2;
    MelodicSolo solo1;
    Track bassSolo;
    Track bassAccomp;
    Track drums;
    Thread thread;
    boolean running = true;
    Random random = new Random();
    double[] handVels = new double[]{1.5, 1.5, 0.5, 3.0};
    int[] phraseLengths = new int[]{2, 3, 4};
    private static final int SAX = 66;
    private static final int BASS = 7;
    private static final int PIANO = 1;
    private static final int TROMBONE = 60;
    private static final int[] solos = new int[]{66, 60, 1, 7};
    int currentSolo = 0;
    long soloTimeout = 10000L;
    int initBassVel;
    int cyclesPerSolo = 2;
    boolean changeInstrument = false;

    public void start() {
        this.restartPlaying();
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void restartPlaying() {
        String chart = this.getParameter("Chart");
        if (chart == null) {
            throw new IllegalArgumentException("No chart file specified");
        }
        this.setChart(chart);
    }

    void startNewPlayer() {
        this.player = new Player(this.song);
        this.player.editorPane = null;
        Track[] trackArray = new Track[4];
        trackArray[0] = new Chords37(this.player);
        trackArray[1] = this.bassAccomp = new BassWith25(this.player);
        trackArray[2] = this.drums = new SimpleDrums(this.player);
        this.solo1 = new MelodicSolo(this.player);
        trackArray[3] = this.solo1;
        this.player.tracks = trackArray;
        this.player.start();
    }

    public void stop() {
        this.running = false;
        this.stopPlaying();
    }

    public synchronized void stopPlaying() {
        if (this.player != null) {
            this.player.stop();
        }
        this.notify();
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        try {
            Track.waitFor(this.player.indexLatch);
            while (this.running) {
                Track.waitFor(this.player.beatLatch);
                Track.waitFor(this.player.indexLatch);
                i = 0;
                ** GOTO lbl12
                {
                    Track.waitFor(this.player.indexLatch);
                    do {
                        if (this.player.indexLatch.getValue() > 0 && !this.changeInstrument) continue block13;
                        ++i;
lbl12:
                        // 2 sources

                    } while (i < this.cyclesPerSolo && !this.changeInstrument);
                }
                System.out.println("Changing Solo>>>");
                this.changeInstrument = false;
                switch (WebImproviser.solos[this.currentSolo]) {
                    case 1: 
                    case 66: {
                        this.solo1.trackActive = false;
                        this.solo1.join(this.soloTimeout);
                        break;
                    }
                    case 60: {
                        this.solo2.trackActive = false;
                        this.solo2.join();
                        break;
                    }
                    case 7: {
                        this.bassSolo.trackActive = false;
                        this.bassSolo.join();
                        this.bassSolo.turnOffChord();
                        this.bassAccomp.trackVelocity = this.initBassVel;
                    }
                }
                ++this.currentSolo;
                this.currentSolo %= WebImproviser.solos.length;
                switch (WebImproviser.solos[this.currentSolo]) {
                    case 60: {
                        this.solo2 = new BebopSolo(this.player);
                        this.solo2.handVelocity = this.handVels[(int)((double)this.handVels.length * this.random.nextDouble())];
                        this.solo2.phraseLength = this.phraseLengths[(int)((double)this.phraseLengths.length * this.random.nextDouble())];
                        this.solo2.trackVelocity = 75;
                        this.solo2.start();
                        this.solo2.patchNumber = 60;
                        break;
                    }
                    case 1: 
                    case 66: {
                        this.solo1 = new MelodicSolo(this.player);
                        this.solo1.patchNumber = WebImproviser.solos[this.currentSolo];
                        this.solo1.start();
                        break;
                    }
                    case 7: {
                        this.initBassVel = this.bassAccomp.trackVelocity;
                        this.bassAccomp.trackVelocity = 0;
                        this.bassSolo = new SimpleBass(this.player);
                        this.bassSolo.start();
                    }
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setChart(String chart) {
        try {
            this.trySetChart(chart);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "Error choosing chart", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trySetChart(String chart) {
        Player.Latch latch;
        if (chart == null) {
            throw new IllegalArgumentException("Please specify a chart");
        }
        try {
            this.song = (SongData)new ObjectInputStream(new FileInputStream(chart)).readObject();
        }
        catch (Exception e) {
            try {
                this.song = (SongData)new ObjectInputStream(new URL(this.getCodeBase(), chart).openStream()).readObject();
            }
            catch (Exception e2) {
                try {
                    System.out.println("reading resource " + this.getClass().getResource(""));
                    this.song = (SongData)new ObjectInputStream(this.getClass().getResourceAsStream(chart)).readObject();
                }
                catch (Exception e3) {
                    e.printStackTrace();
                    e2.printStackTrace();
                    e3.printStackTrace();
                    throw new RuntimeException(e2.toString());
                }
            }
        }
        Player.Latch o1 = null;
        Player.Latch o2 = null;
        if (this.player != null) {
            o1 = this.player.beatLatch;
            o2 = this.player.indexLatch;
            this.player.stop();
            this.player.waitTillFinished(10000L);
            if (this.player.thread.isAlive()) {
                throw new RuntimeException("The drummer is being stubborn.");
            }
        }
        this.startNewPlayer();
        if (o1 != null) {
            latch = o1;
            synchronized (latch) {
                o1.notifyAll();
            }
        }
        if (o2 != null) {
            latch = o2;
            synchronized (latch) {
                o2.notifyAll();
            }
        }
    }

    public void changeSolo() {
        this.changeInstrument = true;
    }
}

