/*
 * Decompiled with CFR 0.152.
 */
package improviser.sound;

import improviser.Chord;
import improviser.sound.Player;
import java.util.Vector;

public abstract class Track
extends Thread {
    public Player player;
    int channelNumber;
    public int trackVelocity = 100;
    public int trackTranspose = 60;
    Vector notesOn = new Vector();
    public boolean trackActive = true;

    public Track(String name, Player p) {
        super(name);
        this.player = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.initialiseTrack();
            Player.Latch latch = this.player.barLatch;
            synchronized (latch) {
                Track track = this;
                synchronized (track) {
                    System.out.println("wait for bar latch...");
                    this.notifyAll();
                }
                Track.waitFor(this.player.barLatch);
            }
            System.out.println("latched");
            while (this.player.playing && this.trackActive) {
                this.processLoop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.turnOffChord();
    }

    public abstract void processLoop();

    public abstract void initialiseTrack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitFor(Object latch) {
        try {
            Object object = latch;
            synchronized (object) {
                latch.wait();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void waitForFraction(double fracOfBeat) {
        try {
            Thread.sleep((int)(fracOfBeat * (double)this.player.msbeat));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void changeNotes(int[] newNotes) {
        this.turnOffChord();
        this.turnOnChord(newNotes);
    }

    public void changeChord(Chord chord) {
        this.turnOffChord();
        this.turnOnChord(chord);
    }

    public void changeNote(int newNote) {
        this.turnOffChord();
        this.turnOnChord(new int[]{newNote});
    }

    public final void turnOffChord() {
        int i = 0;
        while (i < this.notesOn.size()) {
            this.player.noteOff(this.channelNumber, (Integer)this.notesOn.get(i));
            ++i;
        }
        this.notesOn.removeAllElements();
    }

    final void turnOnChord(int[] notes) {
        int i = 0;
        while (i < notes.length) {
            int n = notes[i] + this.trackTranspose;
            this.notesOn.add(new Integer(n));
            this.player.noteOn(this.channelNumber, n, Math.min(this.trackVelocity, 127));
            ++i;
        }
    }

    final void turnOnChord(Chord chord) {
        int[] c = chord.getChordNotes();
        this.turnOnChord(c);
    }
}

