/*
 * Decompiled with CFR 0.152.
 */
package improviser.sound;

import improviser.SongData;
import improviser.sound.Track;

public class Swing {
    public static int swingDynamic = 40;
    static double swingFraction = 0.6;
    public static int msOut = 0;
    public static int b = 0;
    public static boolean sinusoidalRhythmVariation = false;
    public static boolean delayBeat = false;

    public static void playOffbeatChord(int[] chord, Track track) {
        int swlen = (int)((double)track.player.msbeat * swingFraction);
        try {
            Thread.sleep(swlen);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        track.trackVelocity += swingDynamic;
        track.changeNotes(chord);
        track.trackVelocity -= swingDynamic;
    }

    public static final void playOffbeatNote(int note, Track track) {
        int swlen = (int)((double)track.player.msbeat * swingFraction);
        try {
            Thread.sleep(swlen);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        track.trackVelocity += swingDynamic;
        track.changeNote(note);
        track.trackVelocity -= swingDynamic;
    }

    public static void waitForDuplet(Track track) {
        int swlen = (int)((double)track.player.msbeat * swingFraction);
        try {
            Thread.sleep(swlen);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void waitForTriplet(Track track) {
        int tlen = track.player.msbeat / 3;
        try {
            Thread.sleep(tlen);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void waitForQuadruplet(Track track) {
        int tlen = track.player.msbeat / 4;
        try {
            Thread.sleep(tlen);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void waitForWholeBeat(Track track) {
        if (!delayBeat) {
            Track.waitFor(track.player.beatLatch);
        } else {
            if (sinusoidalRhythmVariation) {
                msOut += (int)(10.0 * Math.sin((double)b++ / 6.0));
            }
            long wait = Math.abs(track.player.getTimeUntilWholeBeat() + (long)msOut);
            try {
                Thread.sleep(wait);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static final int[] addBeatsToChordTime(int[] t, int b, SongData song) {
        int[] n = new int[]{t[0], t[1] + b};
        n[0] = n[0] + n[1] / song.beatsPerBar;
        n[1] = n[1] % song.beatsPerBar;
        n[0] = n[0] % (song.length()[0] + 1);
        return n;
    }
}

