/*
 * Decompiled with CFR 0.152.
 */
package improviser.sound;

import improviser.sound.Player;
import improviser.sound.Swing;
import improviser.sound.Track;
import java.util.Vector;

public class SimpleDrums
extends Track {
    int[] ride = new int[]{51, 53, 59};
    int[] crash = new int[]{49, 52, 55, 57};
    int[] bass = new int[]{32};
    int[] snare = new int[]{42, 33, 36};
    int iride;
    int icrash;
    int ibass;
    int isnare;
    boolean swingSnare = false;
    boolean doubleSwing = false;

    public SimpleDrums(Player p) {
        super("SimpleDrums", p);
        this.trackTranspose = 0;
        this.channelNumber = 9;
        this.trackVelocity = 35;
    }

    public void processLoop() {
        int b = this.player.beatLatch.getValue();
        int bar = this.player.barLatch.getValue();
        Vector<Integer> s = new Vector<Integer>();
        if (b == 0 && bar % 16 == 0) {
            this.changeKit();
        }
        this.doubleSwing = bar % 6 == 5 && b > 1;
        if (b % 2 == 0) {
            s.add(new Integer(this.bass[this.ibass]));
        }
        if (b % 2 == 1 && !this.swingSnare) {
            s.add(new Integer(this.snare[this.isnare]));
        }
        s.add(new Integer(this.ride[this.iride]));
        int[] ch = new int[s.size()];
        int i = 0;
        while (i < ch.length) {
            ch[i] = (Integer)s.get(i);
            ++i;
        }
        this.changeNotes(ch);
        if (b % 2 == 1 || this.doubleSwing) {
            int[] ss = this.swingSnare ? new int[]{this.ride[this.iride], this.snare[this.isnare]} : new int[]{this.ride[this.iride]};
            Swing.playOffbeatChord(ss, this);
        }
        SimpleDrums.waitFor(this.player.beatLatch);
    }

    public void initialiseTrack() {
    }

    void changeKit() {
        this.iride = (this.iride + 1) % this.ride.length;
        this.icrash = (this.icrash + 1) % this.crash.length;
        this.ibass = (this.ibass + 1) % this.bass.length;
        this.isnare = (this.isnare + 1) % this.snare.length;
    }
}

