/*
 * Decompiled with CFR 0.152.
 */
package improviser.sound;

import improviser.Chord;
import improviser.Note;
import improviser.sound.Player;
import improviser.sound.Track;
import java.util.Arrays;

public class SimpleChords
extends Track {
    double swingfrac = 0.7;
    public double graceNoteProbability = 0.4;
    boolean prevshortnote = false;

    public SimpleChords(Player p) {
        super("SimpleChords", p);
        this.trackTranspose = 0;
        this.channelNumber = 0;
    }

    public void initialiseTrack() {
    }

    public void processLoop() {
        boolean shortnote;
        boolean gracenote;
        if (Math.random() > this.player.tension && this.player.beatLatch.getValue() != 0) {
            SimpleChords.waitFor(this.player.beatLatch);
        }
        boolean swing = Math.random() > 0.8;
        Chord c = swing && this.player.beatLatch.getValue() == this.player.song.beatsPerBar - 1 ? this.player.nextChord : this.player.currentChord;
        double prob = Math.random() * this.player.tension;
        int[] n = prob > 0.3 ? this.chooseChordNotes(c, 2, 2) : (prob > 0.1 ? this.chooseChordNotes(c, 3, 1) : c.getChordNotes());
        n = this.chooseVoicing(n);
        if (swing) {
            this.waitForFraction(this.swingfrac);
        }
        boolean bl = gracenote = Math.random() < this.graceNoteProbability;
        if (!gracenote) {
            this.changeNotes(n);
        } else {
            int grace;
            int n2 = grace = (int)(Math.random() * (double)n.length);
            n[n2] = n[n2] - 1;
            this.changeNotes(n);
            this.waitForFraction(0.2);
            this.player.channel[this.channelNumber].noteOff(n[grace]);
            int n3 = grace;
            n[n3] = n[n3] + 1;
            this.player.channel[this.channelNumber].noteOn(n[grace], this.trackVelocity - 20);
            this.notesOn.add(new Integer(n[grace]));
        }
        boolean bl2 = shortnote = Math.random() < this.player.tension * 0.5 && !this.prevshortnote;
        if (shortnote) {
            this.waitForFraction(0.1);
            this.turnOffChord();
        }
        SimpleChords.waitFor(this.player.beatLatch);
        this.prevshortnote = shortnote;
    }

    int[] chooseChordNotes(Chord c, int nChord, int nScale) {
        int[] chordn = c.getChordNotes();
        int[] scalen = c.getScaleNotes();
        int[] ch = this.select(chordn, nChord);
        int[] sc = this.select(Note.exclude(scalen, chordn), nScale);
        return Note.combine(ch, sc);
    }

    int[] select(int[] from, int n) {
        int[] sel = new int[n];
        int i = 0;
        while (i < sel.length) {
            boolean repeated;
            int tries = 0;
            do {
                sel[i] = (int)(Math.random() * (double)from.length);
                repeated = false;
                int j = 0;
                while (j < i) {
                    if (sel[j] == sel[i]) {
                        repeated = true;
                    }
                    ++j;
                }
            } while (repeated || ++tries < 10);
            ++i;
        }
        i = 0;
        while (i < sel.length) {
            sel[i] = from[sel[i]];
            ++i;
        }
        return sel;
    }

    int[] chooseVoicing(int[] notes) {
        int i = 0;
        while (i < notes.length) {
            notes[i] = Note.bringIntoRange(notes[i], 60);
            ++i;
        }
        Arrays.sort(notes);
        double prob = Math.random();
        if (prob > 0.7) {
            int n = notes.length - 1;
            notes[n] = notes[n] - 12;
            int n2 = notes.length - 3;
            notes[n2] = notes[n2] - 12;
        } else if (prob > 0.5) {
            int n = notes.length - 1;
            notes[n] = notes[n] - 12;
        } else if (prob > 0.9) {
            int i2 = 0;
            while (i2 < notes.length) {
                int n = i2;
                notes[n] = notes[n] + (2 - i2) * 12;
                ++i2;
            }
        }
        return notes;
    }
}

