/*
 * Decompiled with CFR 0.152.
 */
package improviser.sound;

import improviser.Note;
import improviser.sound.Player;
import improviser.sound.Track;

public class SimpleBass
extends Track {
    double swing = 0.7;
    int direction = 1;
    int lastnote = 0;
    boolean randomizeNextNote = true;
    int octave = 36;
    int lowestNote = 0;
    int highestNote = 20;

    public SimpleBass(Player p) {
        super("SimpleBass", p);
        this.channelNumber = 2;
        this.trackTranspose = 0;
    }

    public void initialiseTrack() {
        this.player.channel[this.channelNumber].programChange(32);
    }

    public void processLoop() {
        if (this.player.beatLatch.getValue() == 0 && Math.random() > 0.2) {
            int note = this.player.currentChord.keyNote;
        } else {
            int note;
            if (!this.randomizeNextNote) {
                boolean arpeggiate;
                boolean randomChange;
                boolean bl = randomChange = Math.random() > 0.9;
                if (this.direction == 1) {
                    if (this.lastnote > this.highestNote || randomChange) {
                        this.direction = -1;
                    }
                } else if (this.lastnote < this.lowestNote || randomChange) {
                    this.direction = 1;
                }
                boolean bl2 = arpeggiate = Math.random() > 0.8;
                note = this.direction == 1 ? (!arpeggiate ? Note.nextInScaleUp(this.lastnote, this.player.currentChord) : Note.nextInChordUp(this.lastnote, this.player.currentChord)) : (!arpeggiate ? Note.nextInScaleDown(this.lastnote, this.player.currentChord) : Note.nextInChordDown(this.lastnote, this.player.currentChord));
            } else {
                int[] scale = this.player.currentChord.getScaleNotes();
                note = scale[(int)(Math.random() * (double)scale.length)];
                this.randomizeNextNote = false;
            }
            this.changeNote(note + this.octave);
            this.lastnote = note;
            double prob = Math.random();
            if (prob > 0.25) {
                SimpleBass.waitFor(this.player.beatLatch);
            } else if (prob > 0.2) {
                this.waitForFraction(this.swing);
                int[] cnotes = this.player.currentChord.getChordNotes();
                int bounceNote = cnotes[(int)(Math.random() * (double)cnotes.length)];
                int n = this.lastnote;
                while (this.lastnote == n) {
                    int bounceOctave = (int)(Math.random() * 3.0) + 1;
                    n = bounceNote + 12 * bounceOctave;
                }
                this.changeNote(n);
                SimpleBass.waitFor(this.player.beatLatch);
            } else {
                this.waitForFraction(this.swing);
            }
        }
    }
}

