/*
 * Decompiled with CFR 0.152.
 */
package improviser.sound;

import improviser.Chord;
import improviser.ImproviserApp;
import improviser.SongData;
import improviser.gui.SongEditorPane;
import improviser.sound.BassWith25;
import improviser.sound.Chords37;
import improviser.sound.MelodicSolo;
import improviser.sound.SimpleDrums;
import improviser.sound.Track;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Synthesizer;

public class Player
implements Runnable {
    public SongEditorPane editorPane;
    SongData song;
    public double tension = 0.3;
    public Track[] tracks;
    public Track soloTrack;
    public Track chordsTrack;
    public Track bassTrack;
    public Track drumsTrack;
    public int msbeat;
    Thread thread = new Thread((Runnable)this, "Player");
    boolean playing;
    public boolean followScoreSelection;
    public boolean followScoreScroll;
    public int startChordIndex = 0;
    public Latch barLatch;
    public Latch beatLatch;
    public Latch indexLatch;
    Chord currentChord;
    Chord nextChord;
    int[] currentDuration;
    int durBeats;
    int[] chordStartTime;
    Synthesizer synth = null;
    MidiChannel[] channel;

    public void start() {
        this.thread.start();
    }

    public void waitTillFinished(long millis) {
        try {
            this.thread.join(millis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToChordIndex(int index) {
        Latch latch = this.indexLatch;
        synchronized (latch) {
            Latch latch2 = this.beatLatch;
            synchronized (latch2) {
                Latch latch3 = this.barLatch;
                synchronized (latch3) {
                    this.indexLatch.setValue(index - 1);
                    int[] time = this.song.totalTimeToChord(index);
                    this.barLatch.setValue(time[0] - 1);
                    this.beatLatch.setValue(-1);
                }
            }
        }
    }

    public void stop() {
        this.playing = false;
        int i = 0;
        while (i < this.tracks.length) {
            this.tracks[i].trackActive = false;
            ++i;
        }
    }

    void createTracks() {
        this.chordsTrack = new Chords37(this);
        this.bassTrack = new BassWith25(this);
        this.drumsTrack = new SimpleDrums(this);
        this.soloTrack = new MelodicSolo(this);
        this.tracks = new Track[]{this.chordsTrack, this.bassTrack, this.drumsTrack, this.soloTrack};
    }

    public Player(SongData s) {
        this.createTracks();
        this.song = s;
        if (this.song == null) {
            this.song = new SongData();
        }
        this.msbeat = 60000 / this.song.tempo;
        this.barLatch = new Latch(Integer.MAX_VALUE);
        this.beatLatch = new Latch(this.song.beatsPerBar);
        this.indexLatch = new Latch(this.song.size());
        if (ImproviserApp.properties != null) {
            ImproviserApp.properties.setRootObject(this, "Player");
        }
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean beginning;
        Latch latch;
        Object object;
        if (this.synth == null) {
            System.out.println("Cannot play because synthesizer failed to initialise.");
            return;
        }
        if (this.song.size() == 0) {
            return;
        }
        Latch latch2 = this.beatLatch;
        synchronized (latch2) {
            object = this.barLatch;
            synchronized (object) {
                latch = this.indexLatch;
                synchronized (latch) {
                    this.playing = true;
                    beginning = true;
                    this.moveToChordIndex(this.startChordIndex);
                }
            }
        }
        int i2 = 0;
        while (i2 < this.tracks.length) {
            object = this.tracks[i2];
            synchronized (object) {
                this.tracks[i2].start();
                try {
                    this.tracks[i2].wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            ++i2;
        }
        while (this.playing) {
            Latch i2 = this.indexLatch;
            synchronized (i2) {
                if (beginning) {
                    beginning = false;
                }
                this.indexLatch.increment();
                int index = this.indexLatch.getValue();
                this.currentChord = this.song.getChord(index);
                this.nextChord = index + 1 < this.song.size() ? this.song.getChord(index + 1) : this.song.getChord(0);
                this.currentDuration = this.song.timeOfChord(index);
                this.durBeats = this.currentDuration[0] * this.song.beatsPerBar + this.currentDuration[1];
                this.chordStartTime = this.currentTime();
                this.indexLatch.notifyAll();
                if (this.editorPane != null & this.followScoreSelection) {
                    this.editorPane.setSelected(index);
                }
                if (this.editorPane != null & this.followScoreScroll) {
                    this.editorPane.songDisplay.setPos(this.chordStartTime[0]);
                }
            }
            int t = 0;
            while (t < this.durBeats && this.playing) {
                Latch index = this.beatLatch;
                synchronized (index) {
                    latch = this.barLatch;
                    synchronized (latch) {
                        this.beatLatch.increment();
                        if (this.beatLatch.getValue() == 0) {
                            this.barLatch.increment();
                            this.beatLatch.notifyAll();
                            this.barLatch.notifyAll();
                        } else {
                            this.beatLatch.notifyAll();
                        }
                    }
                }
                try {
                    this.msbeat = 60000 / this.song.tempo;
                    Thread.sleep(this.msbeat);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++t;
            }
        }
        this.close();
    }

    Chord currentChord() {
        return this.currentChord;
    }

    int beatsUntilNextChord() {
        return this.durBeats + this.chordStartTime[0] * this.song.beatsPerBar + this.chordStartTime[1] - this.beatLatch.getValue() - this.barLatch.getValue() * this.song.beatsPerBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] currentTime() {
        Latch latch = this.barLatch;
        synchronized (latch) {
            Latch latch2 = this.beatLatch;
            synchronized (latch2) {
                return new int[]{this.barLatch.getValue(), this.beatLatch.getValue()};
            }
        }
    }

    void open() {
        try {
            this.synth = MidiSystem.getSynthesizer();
            this.synth.open();
            this.channel = this.synth.getChannels();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.synth.close();
    }

    public final long getTimeUntilWholeBeat() {
        return (long)this.msbeat - this.beatLatch.elapsed();
    }

    public void noteOn(int ch, int n, int v) {
        this.channel[ch].noteOn(n, v);
    }

    public void noteOff(int ch, int n) {
        this.channel[ch].noteOff(n);
    }

    class Latch {
        private int value = 0;
        private int maximum;
        private long lastCall;

        public Latch(int max) {
            this.maximum = max;
        }

        public synchronized void increment() {
            ++this.value;
            if (this.value >= this.maximum) {
                this.value = 0;
            }
            this.lastCall = System.currentTimeMillis();
        }

        public void setValue(int newValue) {
            this.value = newValue;
        }

        public int getValue() {
            return this.value;
        }

        public final long elapsed() {
            return System.currentTimeMillis() - this.lastCall;
        }
    }
}

