/*
 * Decompiled with CFR 0.152.
 */
package improviser.sound;

import improviser.sound.Swing;
import improviser.sound.Track;
import java.util.Vector;

class Melody {
    static final int REST = -1;
    private Vector notes = new Vector();
    private Vector groupings = new Vector();

    Melody() {
    }

    public int[] getNotes() {
        int[] n = new int[this.notes.size()];
        int i = 0;
        while (i < n.length) {
            n[i] = (Integer)this.notes.get(i);
            ++i;
        }
        return n;
    }

    public int[] getGroupings() {
        int[] g = new int[this.groupings.size()];
        int i = 0;
        while (i < g.length) {
            g[i] = (Integer)this.groupings.get(i);
            ++i;
        }
        return g;
    }

    public void addDuplet(int n1, int n2) {
        this.notes.add(new Integer(n1));
        this.notes.add(new Integer(n2));
        this.groupings.add(new Integer(2));
    }

    public void addTriplet(int n1, int n2, int n3) {
        this.notes.add(new Integer(n1));
        this.notes.add(new Integer(n2));
        this.notes.add(new Integer(n3));
        this.groupings.add(new Integer(3));
    }

    public void addCrotchet(int n) {
        this.notes.add(new Integer(n));
        this.groupings.add(new Integer(1));
    }

    public void play(Track track) {
        int[] groupings = this.getGroupings();
        int[] notes = this.getNotes();
        int iNote = 0;
        int initVel = track.trackVelocity;
        int initSwingVel = Swing.swingDynamic;
        int i = 0;
        while (i < groupings.length) {
            if (i < 2 * groupings.length / 3) {
                track.trackVelocity += 2;
                Swing.swingDynamic += 2;
            } else {
                track.trackVelocity -= 4;
                Swing.swingDynamic -= 4;
            }
            if (groupings[i] == 3) {
                this.playNote(track, notes[iNote++]);
                Swing.waitForTriplet(track);
                this.playNote(track, notes[iNote++]);
                Swing.waitForTriplet(track);
                track.trackVelocity += 10;
                this.playNote(track, notes[iNote++]);
                track.trackVelocity -= 10;
            } else if (groupings[i] == 2) {
                this.playNote(track, notes[iNote++]);
                int nn = notes[iNote++];
                if (nn != -1) {
                    Swing.playOffbeatChord(new int[]{nn}, track);
                } else {
                    track.turnOffChord();
                }
            } else if (groupings[i] == 1) {
                this.playNote(track, notes[iNote++]);
            }
            Track.waitFor(track.player.beatLatch);
            ++i;
        }
        track.trackVelocity = initVel;
        Swing.swingDynamic = initSwingVel;
    }

    void playNote(Track t, int note) {
        if (note == -1) {
            t.turnOffChord();
        } else {
            t.changeNote(note);
        }
    }
}

