/*
 * Decompiled with CFR 0.152.
 */
package improviser.sound;

import improviser.Chord;
import improviser.ChordProgression;
import improviser.Metre;
import improviser.Note;
import improviser.Phrase;
import improviser.PhraseFactory;
import improviser.SimplePhrase;
import improviser.sound.HarmonyConstraints;
import improviser.sound.Player;
import improviser.sound.Swing;
import improviser.sound.Track;

public class MelodicSolo
extends Track {
    int lastPatchNumber;
    public int patchNumber;
    public int subphrases;
    public int subphraseLength;
    public int bottomRange;
    public int topRange;
    public boolean offbeatStart;
    public double probMutate;
    public boolean phraseBreak;
    public double maxBreakLength;
    public double probArpeggio;
    public double probJump;
    public double probDuplet;
    public double probTriplet;
    public double probQuadruplet;
    public double probTurn;
    public double probChangeMetre;
    public double probChangeDirection;
    public boolean multipleTurns;
    public int swingArch;
    public int dynamicArch;
    public int delayArch;
    public boolean delayBeat;
    private boolean previousTurn;
    int currentNote;
    boolean direction;
    public Metre metre;
    public HarmonyConstraints harmonyConstraints;

    public MelodicSolo(Player p) {
        super("MelodicSolo", p);
        this.patchNumber = this.lastPatchNumber = 66;
        this.subphrases = 6;
        this.subphraseLength = 2;
        this.bottomRange = 0;
        this.topRange = 24;
        this.offbeatStart = true;
        this.probMutate = 0.3;
        this.phraseBreak = true;
        this.maxBreakLength = 3.0;
        this.probArpeggio = 0.3;
        this.probJump = 0.07;
        this.probDuplet = 0.3;
        this.probTriplet = 0.4;
        this.probQuadruplet = 0.2;
        this.probTurn = 0.01;
        this.probChangeMetre = 0.15;
        this.probChangeDirection = 0.5;
        this.multipleTurns = false;
        this.swingArch = 2;
        this.dynamicArch = 2;
        this.delayArch = 2;
        this.delayBeat = false;
        this.previousTurn = false;
        this.currentNote = 12;
        this.direction = true;
        this.metre = new Metre(2);
        this.harmonyConstraints = new HarmonyConstraints(this.player);
        this.trackTranspose = 48;
        this.channelNumber = 3;
        this.trackVelocity = 90;
    }

    public void processLoop() {
        if (this.lastPatchNumber != this.patchNumber) {
            this.lastPatchNumber = this.patchNumber;
            this.player.channel[this.channelNumber].programChange(this.patchNumber);
        }
        int index = this.player.indexLatch.getValue();
        int[] time = this.player.currentTime();
        int[] chTime = this.player.song.totalTimeToChord(index);
        time[0] = time[0] % (this.player.song.length()[0] + 1);
        int[] startTime = (int[])time.clone();
        System.out.println("bar=" + time[0] + ",beat=" + time[1] + "; length=(" + this.player.song.length()[0] + "," + this.player.song.length()[1]);
        Phrase phrase = PhraseFactory.createBlankPhrase();
        Chord lastChord = null;
        Chord currentChord = this.player.song.getChord(index);
        int i = 0;
        while (i < this.subphrases) {
            Phrase newSegment;
            boolean turn;
            boolean changeDirection;
            boolean changeMetre;
            lastChord = currentChord;
            boolean arpeggio = Math.random() < this.probArpeggio;
            boolean bl = changeMetre = Math.random() < this.probChangeMetre || this.metre.type == 1;
            if (changeMetre) {
                double metreF = Math.random();
                this.metre = metreF < this.probDuplet ? new Metre(2) : (metreF < this.probDuplet + this.probTriplet ? new Metre(3) : (metreF < this.probDuplet + this.probTriplet + this.probQuadruplet ? new Metre(4) : new Metre(1)));
            }
            boolean bl2 = changeDirection = Math.random() < this.probChangeDirection;
            if (changeDirection) {
                boolean bl3 = this.direction = !this.direction;
            }
            if (this.currentNote < this.bottomRange && !this.direction || this.currentNote > this.topRange && this.direction) {
                changeDirection = true;
            }
            if (this.currentNote > this.topRange + 6) {
                this.currentNote -= 12;
            }
            if (this.currentNote < this.bottomRange - 6) {
                this.currentNote += 12;
            }
            boolean bl4 = turn = Math.random() < this.probTurn;
            if (this.previousTurn && !this.multipleTurns) {
                turn = false;
            }
            if (turn && this.metre.type != 1) {
                int endNote = ChordProgression.nearestChordNote(this.currentNote, currentChord);
                newSegment = PhraseFactory.generateTurn(endNote, currentChord, this.metre);
                int beats = newSegment.getBeatsDuration();
                time = Swing.addBeatsToChordTime(time, beats, this.player.song);
                phrase = phrase.plus(newSegment);
                this.currentNote = endNote;
                this.previousTurn = true;
            } else {
                boolean jump;
                int lastNote;
                int resolve;
                newSegment = PhraseFactory.generateScale(this.currentNote, this.direction, arpeggio, this.player.song, time, this.subphraseLength, this.metre);
                this.previousTurn = false;
                int beats = newSegment.getBeatsDuration();
                time = Swing.addBeatsToChordTime(time, beats, this.player.song);
                phrase = phrase.plus(newSegment);
                Chord nextChord = this.player.song.getChord(this.player.song.chordIndexAtTime(time));
                this.currentNote = lastChord != currentChord && lastChord != null ? ChordProgression.nearestOverlapNote(phrase.finalNote(), lastChord, currentChord) : ((resolve = ChordProgression.noteMustResolve(lastNote = phrase.finalNote(), nextChord)) != 0 ? lastNote + resolve : (this.direction ? Note.nextInChordUp(phrase.finalNote(), nextChord) : Note.nextInChordDown(phrase.finalNote(), nextChord)));
                boolean bl5 = jump = Math.random() < this.probJump;
                if (jump) {
                    this.currentNote = (int)(Math.random() * (double)(this.topRange - this.bottomRange)) + this.bottomRange;
                }
            }
            ++i;
        }
        if (this.offbeatStart) {
            int oldLen = phrase.getBeatsDuration();
            phrase.delay((int)(4.0 * Math.random()));
            int extraBeats = phrase.getBeatsDuration() - oldLen;
            Swing.addBeatsToChordTime(time, extraBeats, this.player.song);
        }
        this.harmonyConstraints.constrainPhrase(phrase, startTime);
        System.out.println("phrase=" + phrase);
        SimplePhrase.dynamicArch = this.dynamicArch;
        SimplePhrase.swingArch = this.swingArch;
        SimplePhrase.delayArch = this.delayArch;
        Swing.delayBeat = this.delayBeat;
        phrase.play(this);
        if (lastChord != null && !lastChord.scaleContains(phrase.finalNote())) {
            this.changeNote(this.currentNote);
        }
        Swing.waitForTriplet(this);
        this.turnOffChord();
        this.turnOffChord();
        if (this.phraseBreak) {
            int breakLength = (int)(Math.random() * this.maxBreakLength * (double)this.player.msbeat);
            try {
                Thread.sleep(breakLength);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Swing.waitForWholeBeat(this);
        }
        boolean mutate = Math.random() < this.probMutate;
        while (mutate) {
            int delay = (int)(Math.random() * 3.0);
            int transpose = (int)(Math.random() * 6.0);
            phrase.delay(delay);
            phrase.transpose(transpose);
            time = this.player.currentTime();
            this.harmonyConstraints.constrainPhrase(phrase, time);
            phrase.play(this);
            int beats = phrase.getBeatsDuration();
            time = Swing.addBeatsToChordTime(time, beats, this.player.song);
            boolean bl = mutate = Math.random() < this.probMutate;
        }
    }

    public void initialiseTrack() {
        this.player.channel[this.channelNumber].programChange(this.patchNumber);
    }
}

