/*
 * Decompiled with CFR 0.152.
 */
package improviser.sound;

import improviser.Chord;
import improviser.ChordProgression;
import improviser.CompositePhrase;
import improviser.Metre;
import improviser.Note;
import improviser.Phrase;
import improviser.SimplePhrase;
import improviser.sound.Player;
import improviser.sound.Swing;

public class HarmonyConstraints {
    Player player;
    public boolean allowOutAfterOut = false;
    public boolean inChordAfterOutChord = false;
    public boolean allowOutScale = true;
    public boolean allowRepeatedNotes = false;
    public double deliberateOutness = 0.0;
    public boolean requireResolve = true;
    private static int REST = -1;
    public boolean restrictToPentatonic = false;
    int[] pentScaleMajor;
    int[] pentScaleMinor;

    public HarmonyConstraints(Player player) {
        int[] nArray = new int[5];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 7;
        nArray[4] = 9;
        this.pentScaleMajor = nArray;
        int[] nArray2 = new int[5];
        nArray2[1] = 3;
        nArray2[2] = 5;
        nArray2[3] = 7;
        nArray2[4] = 10;
        this.pentScaleMinor = nArray2;
        this.player = player;
    }

    public void constrainPhrase(Phrase phrase) {
        this.constrainPhrase(phrase, this.player.currentTime());
    }

    public void constrainPhrase(Phrase phrase, int[] time) {
        if (phrase instanceof SimplePhrase) {
            SimplePhrase p = (SimplePhrase)phrase;
            int[] notes = p.notes;
            this.constrainNotes(notes, p.metre, time);
        } else if (phrase instanceof CompositePhrase) {
            CompositePhrase p = (CompositePhrase)phrase;
            this.constrainPhrase(p.first, time);
            int[] secondTime = Swing.addBeatsToChordTime(time, p.first.getBeatsDuration(), this.player.song);
            this.constrainPhrase(p.second, secondTime);
        }
    }

    public void constrainNotes(int[] notes, Metre metre, int[] beginTime) {
        if (notes == null) {
            return;
        }
        int i = 0;
        while (i < notes.length) {
            Chord c2;
            int[] time = Swing.addBeatsToChordTime(beginTime, i / metre.type, this.player.song);
            int[] tim2 = Swing.addBeatsToChordTime(beginTime, (i + 1) / metre.type, this.player.song);
            Chord ch = this.player.song.getChord(this.player.song.chordIndexAtTime(time));
            if (ch == (c2 = this.player.song.getChord(this.player.song.chordIndexAtTime(tim2)))) {
                this.enforceKeyOnNote(ch, notes, i);
            } else {
                this.enforceKeysOnNote(ch, c2, notes, i);
            }
            ++i;
        }
    }

    protected void enforceKeyOnNote(Chord key, int[] notes, int i) {
        int r;
        int previous;
        if (notes[i] == REST) {
            return;
        }
        int n = previous = i < 1 ? -1 : notes[i - 1];
        if (this.requireResolve && previous != REST && (r = this.noteMustResolve(previous, key)) != 0) {
            notes[i] = previous + r;
        }
        if (this.restrictToPentatonic && (ChordProgression.isMinor(key) || ChordProgression.isMajor(key))) {
            this.enforcePentatonicOnNote(key, notes, i);
        } else if (!key.scaleContains(notes[i])) {
            boolean previousOut;
            boolean bl = previousOut = !key.scaleContains(previous) && previous != REST;
            if (!this.allowOutAfterOut && previousOut || !this.allowOutScale) {
                notes[i] = previous != REST ? (this.inChordAfterOutChord ? Note.nextInChordUp(previous, key) : Note.nextInScaleUp(previous, key)) : Note.nextInScaleDown(notes[i], key);
            }
        }
        if (Math.random() < this.deliberateOutness) {
            int n2 = i;
            notes[n2] = notes[n2] + 1;
        }
        if (notes[i] == previous && !this.allowRepeatedNotes) {
            notes[i] = Note.nextInScaleDown(notes[i], key);
        }
    }

    protected void enforceKeysOnNote(Chord from, Chord to, int[] notes, int i) {
        int previous;
        if (notes[i] == REST) {
            return;
        }
        int n = previous = i < 1 ? -1 : notes[i - 1];
        if (!from.scaleContains(notes[i]) || !to.scaleContains(notes[i])) {
            notes[i] = ChordProgression.nearestOverlapNote(notes[i], from, to);
        }
        if (notes[i] == previous) {
            notes[i] = Note.nextInScaleUp(notes[i], to);
        }
    }

    protected void enforcePentatonicOnNote(Chord key, int[] notes, int i) {
        int n = i;
        notes[n] = notes[n] + this.resolveToPentatonic(key, notes[i]);
    }

    protected int resolveToPentatonic(Chord key, int note) {
        int[] pentScale;
        if (ChordProgression.isMajor(key)) {
            pentScale = this.pentScaleMajor;
        } else if (ChordProgression.isMinor(key)) {
            pentScale = this.pentScaleMinor;
        } else {
            System.out.println("resolveToPentatonic called for " + key);
            pentScale = this.pentScaleMinor;
        }
        int scaleDeg = Note.toBaseRange(note - key.keyNote);
        int nearest = -1;
        int nearestDistance = 100;
        int i = 0;
        while (i < pentScale.length) {
            if (pentScale[i] == scaleDeg) {
                return 0;
            }
            int distance = pentScale[i] - scaleDeg;
            if (Math.abs(distance) < Math.abs(nearestDistance)) {
                nearestDistance = distance;
                nearest = i;
            }
            ++i;
        }
        return nearestDistance;
    }

    public int noteMustResolve(int note, Chord chord) {
        if (this.restrictToPentatonic && (ChordProgression.isMinor(chord) || ChordProgression.isMajor(chord))) {
            return this.resolveToPentatonic(chord, note);
        }
        return ChordProgression.noteMustResolve(note, chord);
    }
}

