/*
 * Decompiled with CFR 0.152.
 */
package improviser.sound;

import improviser.Chord;
import improviser.ChordProgression;
import improviser.sound.Player;
import improviser.sound.Swing;
import improviser.sound.Track;

public class Chords37
extends Track {
    int[] last37;
    boolean starting = true;
    boolean swingNextChord = false;
    boolean swungLastChord = false;
    public int patch = 0;
    int[] lastExtension;
    public boolean drop2 = false;
    public boolean is13 = false;

    public Chords37(Player p) {
        super("Chords37", p);
        this.trackTranspose = 48;
        this.channelNumber = 0;
        this.trackVelocity = 60;
    }

    public void processLoop() {
        int[] ch;
        boolean newdrop2;
        this.player.channel[this.channelNumber].programChange(this.patch);
        if (!this.starting) {
            Chords37.waitFor(this.player.indexLatch);
        }
        this.starting = false;
        int bar = this.player.barLatch.getValue();
        boolean bl = newdrop2 = bar / 8 % 2 == 0;
        if (this.drop2 != newdrop2) {
            this.drop2 = newdrop2;
            this.last37 = null;
            this.lastExtension = null;
        }
        if (!this.swungLastChord) {
            ch = this.createChord(this.player.indexLatch.getValue());
            this.changeNotes(ch);
        }
        this.swungLastChord = false;
        this.swingNextChord = bar % 4 > 2;
        if (this.swingNextChord) {
            ch = this.createChord((this.player.indexLatch.getValue() + 1) % this.player.song.size());
            int beats = this.player.beatsUntilNextChord();
            int i = 0;
            while (i < beats) {
                Chords37.waitFor(this.player.beatLatch);
                ++i;
            }
            Swing.playOffbeatChord(ch, this);
            this.swungLastChord = true;
        }
    }

    int[] createChord(int index) {
        Chord c = this.player.song.getChord(index);
        int[] basic = new int[]{ChordProgression.getMediant(c), ChordProgression.getLeadingNote(c)};
        if (ChordProgression.useMinorSeventh(c)) {
            basic[1] = basic[1] - 1;
        }
        int[] nearest = this.last37 == null ? basic : this.getNearestPosition(this.last37, basic);
        int[] rh = this.getExtension(index);
        int[] ch = new int[nearest.length + rh.length];
        ch[0] = nearest[0];
        ch[1] = nearest[1];
        int i = 0;
        while (i < rh.length) {
            ch[2 + i] = rh[i];
            ++i;
        }
        ch[0] = ch[0] + 12;
        ch[1] = ch[1] + 12;
        if (!this.drop2) {
            i = 2;
            while (i < ch.length) {
                int n = i++;
                ch[n] = ch[n] - 12;
            }
        }
        this.last37 = nearest;
        return ch;
    }

    int[] getExtension(int index) {
        Chord c = this.player.song.getChord(index);
        Chord nextc = this.player.song.getChord((index + 1) % this.player.song.size());
        int[] scale = c.getScaleNotes();
        int[] ex = ChordProgression.isMinor(c) || !this.is13 ? new int[]{ChordProgression.getSupertonic(c, nextc), ChordProgression.getDominant(c)} : new int[]{ChordProgression.getSupertonic(c, nextc), scale[scale.length - 2]};
        int i = 0;
        while (i < ex.length) {
            int n = i++;
            ex[n] = ex[n] + 24;
        }
        if (this.lastExtension != null) {
            ex = this.getNearestPosition(this.lastExtension, ex);
        }
        this.lastExtension = ex;
        return ex;
    }

    int[] getNearestPosition(int[] previous, int[] basic) {
        int[] inverse1 = new int[]{basic[0] + 12, basic[1]};
        int[] inverse2 = new int[]{basic[0], basic[1] - 12};
        int s0 = ChordProgression.distanceOfHands(previous, basic);
        int s1 = ChordProgression.distanceOfHands(previous, inverse1);
        int s2 = ChordProgression.distanceOfHands(previous, inverse2);
        int[] choice = s0 < s1 && s0 < s2 ? basic : (s1 < s0 && s1 < s2 ? inverse1 : inverse2);
        return choice;
    }

    public void initialiseTrack() {
    }
}

