/*
 * Decompiled with CFR 0.152.
 */
package improviser.sound;

import improviser.Chord;
import improviser.ChordProgression;
import improviser.Note;
import improviser.sound.Melody;
import improviser.sound.Player;
import improviser.sound.Track;

public class BebopSolo
extends Track {
    public int patchNumber = 66;
    int phraseLength = 3;
    int handPos = 0;
    double handVelocity = 2.0;
    double dhandPos = this.handPos;
    int startOffset;
    boolean lastBeatOfChord = false;
    int previousNote = -1;
    int obligateNextNote = -1;
    Chord nextc;

    public BebopSolo(Player p) {
        super("BebopSolo", p);
        this.trackTranspose = 48;
        this.channelNumber = 3;
        this.trackVelocity = 60;
    }

    public void processLoop() {
        int index = this.player.indexLatch.getValue();
        int[] time = this.player.currentTime();
        int[] chTime = this.player.song.totalTimeToChord(index);
        int beatsOffset = (time[0] % (this.player.song.length()[0] + 1) - chTime[0]) * this.player.song.beatsPerBar + time[1] - chTime[1];
        System.out.println("beatoffset=" + beatsOffset);
        Melody melody = this.compose(index, beatsOffset, this.phraseLength);
        melody.play(this);
        this.turnOffChord();
        BebopSolo.waitFor(this.player.indexLatch);
    }

    public void initialiseTrack() {
        this.player.channel[this.channelNumber].programChange(this.patchNumber);
    }

    Melody compose(int indexStart, int beatsOffset, int length) {
        Melody melody = new Melody();
        boolean triplet = true;
        this.startOffset = indexStart % 6;
        triplet = indexStart % 5 > 3;
        this.obligateNextNote = -1;
        int i = 0;
        while (i < length) {
            Chord c = this.player.song.getChord((i + indexStart) % this.player.song.size());
            this.nextc = this.player.song.getChord((indexStart + i + 1) % this.player.song.size());
            int[] clen = this.player.song.timeOfChord(i + indexStart);
            int chordLength = clen[1] + clen[0] * this.player.song.beatsPerBar;
            if (i == 0) {
                chordLength -= beatsOffset;
            }
            System.out.print(String.valueOf(c.getSymbol()) + "(" + chordLength + ")");
            int j = 0;
            while (j < chordLength) {
                int n2;
                int n1;
                this.lastBeatOfChord = j == chordLength - 1;
                if (triplet) {
                    n1 = this.moveHandInChord(c);
                    n2 = this.moveHandInChord(c);
                    int n3 = this.moveHandInChord(c);
                    melody.addTriplet(n1, n2, n3);
                } else {
                    n1 = this.moveHandInChord(c);
                    n2 = this.moveHandInChord(c);
                    melody.addDuplet(n1, n2);
                }
                triplet = i % (j + 1) == 0;
                ++j;
            }
            ++i;
        }
        Chord end = this.player.song.getChord((indexStart + length) % this.player.song.size());
        int n = this.obligateNextNote < 0 ? ChordProgression.nearestChordNote(this.handPos, end) : (end.scaleContains(this.obligateNextNote) ? this.obligateNextNote : ChordProgression.nearestChordNote(this.handPos, end));
        System.out.println(end.chordContains(n));
        System.out.print("Ending on " + Note.name(n) + "(h=" + Note.name(this.handPos) + ") in " + end.getSymbol());
        melody.addCrotchet(n);
        return melody;
    }

    void moveHand() {
        this.dhandPos += this.handVelocity;
        this.handPos = (int)this.dhandPos;
        if (this.handPos > 24 && this.handVelocity > 0.0) {
            this.handVelocity = -this.handVelocity;
        }
        if (this.handPos < 0 && this.handVelocity < 0.0) {
            this.handVelocity = -this.handVelocity;
        }
    }

    int moveHandInChord(Chord c) {
        int dir;
        if (this.startOffset > 0) {
            --this.startOffset;
            if (this.startOffset > 0) {
                System.out.print("R");
                return -1;
            }
        }
        this.moveHand();
        if (this.obligateNextNote >= 0) {
            this.previousNote = this.obligateNextNote;
            this.obligateNextNote = -1;
            System.out.print("on" + this.previousNote + "(h=" + this.handPos + ")");
            return this.previousNote;
        }
        int f = ChordProgression.nearestScaleNote(this.handPos, c);
        int h = ChordProgression.nearestChordNote(this.handPos, c);
        if (this.lastBeatOfChord) {
            f = ChordProgression.nearestOverlapNote(this.handPos, c, this.nextc);
            System.out.println(String.valueOf(Note.name(f)) + " overlaps " + c.getSymbol() + " and " + this.nextc.getSymbol());
        }
        System.out.print("n" + f + "(h=" + this.handPos + "),");
        if (f == this.previousNote) {
            ++f;
        }
        if ((dir = ChordProgression.noteMustResolve(f, c)) != 0) {
            this.obligateNextNote = f + dir;
        }
        this.previousNote = f;
        return f;
    }
}

