/*
 * Decompiled with CFR 0.152.
 */
package improviser.sound;

import improviser.Chord;
import improviser.ChordProgression;
import improviser.Note;
import improviser.sound.Player;
import improviser.sound.Track;

public class BassWith25
extends Track {
    int[] barPlan;
    boolean starting = true;
    int octave = 0;

    public BassWith25(Player p) {
        super("Bass", p);
        this.channelNumber = 1;
        this.trackTranspose = 36;
        this.trackVelocity = 70;
    }

    public void initialiseTrack() {
        this.player.channel[this.channelNumber].programChange(32);
    }

    public void processLoop() {
        int barnum = this.player.barLatch.getValue();
        if (this.player.beatLatch.getValue() == 0 || this.starting) {
            this.barPlan = this.planBar(barnum % (this.player.song.length()[0] + 1));
            this.starting = false;
        }
        if (this.barPlan != null) {
            this.changeNote(this.barPlan[this.player.beatLatch.getValue()]);
        }
        BassWith25.waitFor(this.player.beatLatch);
    }

    int[] planBar(int bar) {
        int[] c = this.player.song.chordIndicesInBar(bar);
        if (c == null) {
            return null;
        }
        int[] chordIndex = new int[c.length + 1];
        int j = 0;
        while (j < c.length) {
            chordIndex[j] = c[j];
            ++j;
        }
        int[] nArray = new int[2];
        nArray[0] = bar + 1;
        chordIndex[c.length] = this.player.song.chordIndexAtTime(nArray);
        if (chordIndex[c.length] < 0) {
            chordIndex[c.length] = 0;
        }
        int[] plan = new int[this.player.song.beatsPerBar];
        int beat = 0;
        int i = 0;
        while (i < c.length) {
            int[] ddd;
            int dur;
            Chord chord = this.player.song.getChord(chordIndex[i]);
            Chord nextChord = this.player.song.getChord(chordIndex[i + 1]);
            int[] tNext = this.player.song.totalTimeToChord(chordIndex[i + 1]);
            if (tNext[0] > bar && tNext[1] > 0 || tNext[0] > bar + 1) {
                nextChord = chord;
            }
            if ((dur = (ddd = this.player.song.timeOfChord(chordIndex[i]))[0] * this.player.song.beatsPerBar + ddd[1]) > 4) {
                dur = 4;
            }
            if (dur == 1) {
                plan[beat++] = chord.keyNote + this.octave * 12;
            } else if (dur == 2) {
                plan[beat++] = chord.keyNote + this.octave * 12;
                plan[beat++] = this.leadBass(chord, chord.keyNote, nextChord);
            } else if (dur == 3) {
                plan[beat++] = chord.keyNote + this.octave * 12;
                plan[beat++] = this.arpeggio(chord, 1);
                plan[beat++] = this.leadBass(chord, plan[beat - 1], nextChord);
            } else if (dur == 4) {
                plan[beat++] = chord.keyNote + this.octave * 12;
                if (ChordProgression.isII_I(chord, nextChord)) {
                    Chord five = new Chord(chord.keyNote + 5, "7");
                    plan[beat++] = this.leadBass(chord, chord.keyNote, five);
                    plan[beat++] = five.keyNote;
                    plan[beat++] = this.leadBass(five, five.keyNote, nextChord);
                } else {
                    plan[beat++] = this.arpeggio(chord, 1);
                    plan[beat++] = this.arpeggio(chord, 2);
                    plan[beat++] = this.leadBass(chord, plan[beat - 1], nextChord);
                }
            }
            ++i;
        }
        return plan;
    }

    int leadBass(Chord firstChord, int firstNote, Chord secondChord) {
        int choice;
        int rootChange = Note.toBaseRange(secondChord.keyNote - firstChord.keyNote);
        if (rootChange == 5) {
            if (firstChord.typeIndex == 7) {
                int k;
                choice = k = Note.nearestFromList(firstNote, new int[]{firstChord.keyNote + 6, firstChord.keyNote + 3});
            } else {
                int test = firstChord.keyNote + 3;
                choice = ChordProgression.isMinor(firstChord) ? test : test + 1;
            }
        } else {
            choice = rootChange == 10 ? firstChord.keyNote + 5 : (rootChange == 0 ? ChordProgression.getLeadingNote(secondChord) : (rootChange == 2 ? ChordProgression.getLeadingNote(secondChord) : (rootChange == 9 ? ChordProgression.getLeadingNote(firstChord) : secondChord.keyNote + 1)));
        }
        return choice + this.octave * 12;
    }

    int arpeggio(Chord chord, int index) {
        int[] notes = chord.getChordNotes();
        return notes[index % notes.length];
    }
}

