/*
 * Decompiled with CFR 0.152.
 */
package improviser.learning;

import java.util.Arrays;
import java.util.Vector;

public abstract class Sequence {
    protected abstract Vector getItems();

    protected abstract float[] getDurations();

    protected float timeTillStartOf(int index) {
        float f = 0.0f;
        float[] d = this.getDurations();
        int i = 0;
        while (i < index) {
            f += d[i];
            ++i;
        }
        return f;
    }

    public int indexAtTime(float time) {
        float[] durations = this.getDurations();
        int i = -1;
        while (i + 1 < durations.length && time >= durations[i + 1]) {
            time -= durations[++i];
        }
        if (i >= durations.length) {
            return -1;
        }
        return i;
    }

    public Sequence during(float time, float duration) {
        float[] durations = this.getDurations();
        int si = this.indexAtTime(time);
        float st = this.timeTillStartOf(si);
        float firstd = st + durations[si] - time;
        int ei = this.indexAtTime(time + duration);
        float et = this.timeTillStartOf(ei);
        float lastd = time + duration - et;
        int ln = Math.max(ei - si, 1);
        Object[] ch = new Object[ln];
        float[] d = new float[ln];
        int i = si;
        while (i <= ei) {
            ch[i - si] = this.getItems().get(i);
            if (i == si && i == ei) {
                d[0] = duration;
            } else if (i == si) {
                d[0] = firstd;
            } else if (i == ei) {
                d[ei - si] = lastd;
            } else {
                d[i - si] = durations[i];
            }
            ++i;
        }
        SimpleSequence h = new SimpleSequence();
        Vector<Object> v = new Vector<Object>();
        v.addAll(Arrays.asList(ch));
        h.getItems().addAll(v);
        h.durations = d;
        return h;
    }

    protected static class SimpleSequence
    extends Sequence {
        Vector vector = new Vector();
        float[] durations = new float[0];

        protected SimpleSequence() {
        }

        protected Vector getItems() {
            return this.vector;
        }

        protected float[] getDurations() {
            return this.durations;
        }
    }
}

