/*
 * Decompiled with CFR 0.152.
 */
package improviser.learning;

import improviser.learning.Phrase;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.Vector;
import javax.swing.JPanel;

public class PhraseDisplay
extends JPanel {
    Vector phrases = new Vector();
    Color[] cols = new Color[]{Color.blue, Color.red, Color.orange, Color.magenta};
    float xscale = 10.0f;
    float yscale = 1.0f;
    int xfreq = 4;
    int yfreq = 12;

    public PhraseDisplay() {
        this.setBackground(Color.white);
    }

    public void addPhrase(Phrase p) {
        this.phrases.add(p);
        this.repaint();
    }

    public void removePhrase(Phrase p) {
        this.phrases.remove(p);
        this.repaint();
    }

    public void paint(Graphics g_) {
        super.paint(g_);
        Graphics2D g = (Graphics2D)g_;
        this.paintGrid(g);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(3.0f));
        int i = 0;
        while (i < this.phrases.size()) {
            g.setColor(this.cols[i % this.cols.length]);
            Phrase p = (Phrase)this.phrases.get(i);
            this.paintPhrase(p, g);
            ++i;
        }
    }

    private void paintPhrase(Phrase p, Graphics g) {
        int x = 0;
        Point lastPoint = null;
        int i = 0;
        while (i < p.notes.length) {
            if (p.notes[i] == Integer.MIN_VALUE) {
                x += (int)(p.durations[i] * this.xscale);
                lastPoint = null;
            } else {
                Point newPoint = new Point(x, (int)((float)p.notes[i] * this.yscale));
                if (lastPoint == null) {
                    lastPoint = newPoint;
                } else {
                    g.drawLine(lastPoint.x, lastPoint.y, newPoint.x, newPoint.y);
                    lastPoint = newPoint;
                }
                newPoint = new Point(x += (int)(p.durations[i] * this.xscale), lastPoint.y);
                g.drawLine(lastPoint.x, lastPoint.y, newPoint.x, newPoint.y);
                lastPoint = newPoint;
            }
            ++i;
        }
    }

    private void paintGrid(Graphics g) {
        int nx = (int)((float)this.getWidth() / this.xscale);
        int i = 0;
        while (i < nx) {
            int x = (int)((float)i * this.xscale);
            if (i % this.xfreq == 0) {
                g.setColor(Color.darkGray);
            } else {
                g.setColor(Color.lightGray);
            }
            g.drawLine(x, 0, x, this.getHeight());
            ++i;
        }
        int ny = (int)((float)this.getWidth() / this.yscale / (float)this.yfreq);
        int i2 = 0;
        while (i2 < ny) {
            int y = (int)((float)i2 * this.yscale * (float)this.yfreq);
            g.setColor(Color.lightGray);
            g.drawLine(0, y, this.getWidth(), y);
            ++i2;
        }
    }

    public Dimension getPreferredSize() {
        float len = 0.0f;
        int i = 0;
        while (i < this.phrases.size()) {
            len = Math.max(((Phrase)this.phrases.get(i)).getTotalDuration(), len);
            ++i;
        }
        return new Dimension((int)(len * this.xscale), (int)(256.0f * this.yscale));
    }
}

