/*
 * Decompiled with CFR 0.152.
 */
package improviser.learning;

import improviser.sound.Track;

public class Phrase {
    public int[] notes = new int[0];
    public float[] durations = new float[0];
    public float restBefore = 0.0f;
    public int[] velocities = new int[0];
    public static final int REST = Integer.MIN_VALUE;

    public boolean isEmpty() {
        return this.notes.length == 0;
    }

    public final float getTotalDuration() {
        float f = 0.0f;
        int i = 0;
        while (i < this.durations.length) {
            f += this.durations[i];
            ++i;
        }
        return f + this.restBefore;
    }

    public final float getTotalDurationToIndex(int index) {
        float f = this.restBefore;
        int i = 0;
        while (i < index) {
            f += this.durations[i];
            ++i;
        }
        return f;
    }

    public int getIndexAtTime(float time) {
        if (time < this.restBefore) {
            return Integer.MIN_VALUE;
        }
        time -= this.restBefore;
        int i = 0;
        while (i < this.durations.length) {
            float d = this.durations[i];
            if (time < d) {
                return i;
            }
            time -= d;
            ++i;
        }
        return Integer.MIN_VALUE;
    }

    public void appendNote(int pitch, float duration, int velocity) {
        int r = this.notes.length;
        int[] n = new int[r + 1];
        System.arraycopy(this.notes, 0, n, 0, r);
        n[r] = pitch;
        this.notes = n;
        float[] m = new float[r + 1];
        System.arraycopy(this.durations, 0, m, 0, r);
        m[r] = duration;
        this.durations = m;
        n = new int[r + 1];
        System.arraycopy(this.notes, 0, n, 0, r);
        n[r] = velocity;
        this.velocities = n;
    }

    public void appendPhrase(Phrase p) {
        int r = this.notes.length;
        int s = p.notes.length;
        int t = p.restBefore > 0.0f ? 1 : 0;
        int[] n = new int[r + s + t];
        System.arraycopy(this.notes, 0, n, 0, r);
        if (t > 0) {
            n[r] = Integer.MIN_VALUE;
        }
        System.arraycopy(p.notes, 0, n, r + t, s);
        this.notes = n;
        float[] m = new float[r + s + t];
        System.arraycopy(this.durations, 0, m, 0, r);
        if (t > 0) {
            m[r] = p.restBefore;
        }
        System.arraycopy(p.durations, 0, m, r + t, s);
        this.durations = m;
        n = new int[r + s + t];
        System.arraycopy(this.velocities, 0, n, 0, r);
        if (t > 0) {
            n[r] = 0;
        }
        System.arraycopy(p.velocities, 0, n, r + t, s);
        this.velocities = n;
    }

    public void playBlocking(Track track, int transpose) {
        try {
            Thread.sleep((long)((float)track.player.msbeat * this.restBefore));
            int i = 0;
            while (i < this.notes.length) {
                int note = this.notes[i];
                if (note == Integer.MIN_VALUE) {
                    track.turnOffChord();
                    Thread.sleep((long)((float)track.player.msbeat * this.durations[i]));
                } else {
                    track.trackVelocity = this.velocities[i];
                    track.changeNote(note + transpose);
                    Thread.sleep((long)((float)track.player.msbeat * this.durations[i]));
                }
                ++i;
            }
            track.turnOffChord();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PlayControl playAsynchronous(Track t, int transpose) {
        PlayControl p = new PlayControl(this, t, transpose);
        return p;
    }

    public Phrase getFragment(float beginTimeOffset, float length) {
        block6: {
            block5: {
                float f;
                if (length < 0.0f) break block5;
                float totalDuration = this.getTotalDuration();
                if (!(beginTimeOffset > f)) break block6;
            }
            return new Phrase();
        }
        int beginWholeNoteI = this.getIndexAtTime(beginTimeOffset);
        float beginWholeNoteO = this.getTotalDurationToIndex(beginWholeNoteI);
        if (beginTimeOffset > beginWholeNoteO) {
            float firstDur = this.durations[beginWholeNoteI] - (beginTimeOffset - beginWholeNoteO);
        } else {
            float firstDur = this.durations[beginWholeNoteI];
        }
        Phrase p = new Phrase();
        return p;
    }

    public Phrase getSegment(int startIndex, int numNotes) {
        Phrase p = new Phrase();
        numNotes = Math.min(numNotes, this.notes.length - startIndex);
        p.notes = new int[numNotes];
        p.durations = new float[numNotes];
        if (numNotes > 0) {
            int i = 0;
            while (i < numNotes) {
                p.notes[i] = this.notes[startIndex + i];
                p.durations[i] = this.durations[startIndex + i];
                p.velocities[i] = this.velocities[startIndex + i];
                ++i;
            }
        }
        return p;
    }

    public static class PlayControl
    implements improviser.PlayControl {
        private Phrase phrase;
        private int transpose;
        private Track track;
        private boolean playing = false;
        private boolean running = false;
        private E e;
        private Thread thread;

        protected PlayControl(Phrase p, Track t, int tr) {
            this.phrase = p;
            this.track = t;
            this.transpose = tr;
            this.e = new E();
            this.thread = new Thread((Runnable)this.e, "Play" + this.phrase.toString());
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            E e = this.e;
            synchronized (e) {
                this.running = true;
                this.playing = true;
                this.e.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pause() {
            E e = this.e;
            synchronized (e) {
                this.playing = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            E e = this.e;
            synchronized (e) {
                this.running = false;
                this.playing = false;
                this.e.notify();
            }
        }

        public void waitTillFinished() throws InterruptedException {
            this.thread.join();
        }

        public double getProgress() {
            return (double)this.e.i / (double)this.phrase.notes.length;
        }

        public void setProgress(double d) {
            this.e.i = (int)(Math.min(Math.max(d, 0.0), 1.0) * (double)this.phrase.notes.length);
        }

        public boolean isPlaying() {
            return this.playing;
        }

        public boolean isRunning() {
            return this.running;
        }

        private class E
        implements Runnable {
            int i;

            private E() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    while (!PlayControl.this.running) {
                        E e = this;
                        synchronized (e) {
                            this.wait();
                        }
                    }
                    while (PlayControl.this.running) {
                        E e = this;
                        synchronized (e) {
                            while (!PlayControl.this.playing) {
                                this.wait();
                            }
                            if (!PlayControl.this.running) {
                                return;
                            }
                        }
                        Thread.sleep((long)((float)((PlayControl)PlayControl.this).track.player.msbeat * ((PlayControl)PlayControl.this).phrase.restBefore));
                        this.i = 0;
                        while (this.i < ((PlayControl)PlayControl.this).phrase.notes.length) {
                            int note = ((PlayControl)PlayControl.this).phrase.notes[this.i];
                            if (note == Integer.MIN_VALUE) {
                                PlayControl.this.track.turnOffChord();
                                Thread.sleep((long)((float)((PlayControl)PlayControl.this).track.player.msbeat * ((PlayControl)PlayControl.this).phrase.durations[this.i]));
                            } else {
                                E e2 = this;
                                synchronized (e2) {
                                    while (!PlayControl.this.playing) {
                                        this.wait();
                                    }
                                    if (!PlayControl.this.running) {
                                        return;
                                    }
                                }
                                ((PlayControl)PlayControl.this).track.trackVelocity = ((PlayControl)PlayControl.this).phrase.velocities[this.i];
                                PlayControl.this.track.changeNote(note + PlayControl.this.transpose);
                                Thread.sleep((long)((float)((PlayControl)PlayControl.this).track.player.msbeat * ((PlayControl)PlayControl.this).phrase.durations[this.i]));
                            }
                            ++this.i;
                        }
                        PlayControl.this.track.turnOffChord();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

