/*
 * Decompiled with CFR 0.152.
 */
package improviser.learning;

import improviser.PlayControl;
import improviser.PlayWindow;
import improviser.learning.MidiFileChooser;
import improviser.learning.Phrase;
import improviser.learning.PhraseDisplay;
import improviser.sound.Player;
import improviser.sound.Track;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class MidiTest
extends JFrame {
    private JPanel jPanel1 = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanel2 = new JPanel();
    private JPanel jPanel3 = new JPanel();
    private JButton openbutton = new JButton();
    MidiFileChooser mfc = new MidiFileChooser(null);
    private BorderLayout borderLayout2 = new BorderLayout();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private PhraseDisplay display = new PhraseDisplay();
    private JButton playbutton = new JButton();
    private JComboBox tracklist = new JComboBox();
    private JPanel jPanel4 = new JPanel();
    private JCheckBox showall = new JCheckBox();
    Vector phrases = new Vector();
    private JScrollBar horzscale = new JScrollBar();
    private JScrollBar vertscale = new JScrollBar();

    public static void main(String[] s) {
        new MidiTest();
    }

    public MidiTest() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setSize(500, 400);
        this.show();
    }

    private void jbInit() throws Exception {
        this.jPanel1.setLayout(this.borderLayout1);
        this.openbutton.setText("Open");
        this.openbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MidiTest.this.openbutton_actionPerformed(e);
            }
        });
        this.jPanel3.setLayout(this.borderLayout2);
        this.setDefaultCloseOperation(3);
        this.playbutton.setText("Play");
        this.playbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MidiTest.this.playbutton_actionPerformed(e);
            }
        });
        this.tracklist.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MidiTest.this.tracklist_actionPerformed(e);
            }
        });
        this.showall.setText("Show all");
        this.showall.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MidiTest.this.showall_actionPerformed(e);
            }
        });
        this.horzscale.setMaximum(300);
        this.horzscale.setMinimum(1);
        this.horzscale.setOrientation(0);
        this.horzscale.setValue(100);
        this.vertscale.setMinimum(1);
        this.vertscale.setValue(15);
        this.horzscale.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                MidiTest.this.horzscale_adjustmentValueChanged(e);
            }
        });
        this.vertscale.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                MidiTest.this.vertscale_adjustmentValueChanged(e);
            }
        });
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.openbutton, null);
        this.jPanel2.add((Component)this.playbutton, null);
        this.jPanel1.add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.jPanel3.add((Component)this.horzscale, "North");
        this.jPanel1.add((Component)this.jPanel4, "North");
        this.jPanel4.add((Component)this.showall, null);
        this.jScrollPane1.getViewport().add((Component)this.display, null);
        this.jPanel2.add((Component)this.tracklist, null);
        this.jPanel3.add((Component)this.vertscale, "West");
    }

    void openbutton_actionPerformed(ActionEvent e) {
        Phrase[] p = this.mfc.fileOpen();
        if (p == null) {
            return;
        }
        int i = 0;
        while (i < p.length) {
            if (p[i] != null) {
                this.display.addPhrase(p[i]);
                this.tracklist.addItem(p[i]);
                this.phrases.add(p[i]);
            }
            ++i;
        }
    }

    void playbutton_actionPerformed(ActionEvent e) {
        Object o = this.tracklist.getSelectedItem();
        Player player = new Player(null);
        Phrase phrase = null;
        phrase = o instanceof Phrase ? (Phrase)o : (Phrase)this.phrases.get(0);
        DummyTrack t = new DummyTrack(player);
        t.trackTranspose = 0;
        Phrase.PlayControl pc = phrase.playAsynchronous(t, 0);
        PlayWindow pw = new PlayWindow(pc);
        WaitThread th = new WaitThread(pc, player, pw);
        th.start();
    }

    void tracklist_actionPerformed(ActionEvent e) {
        this.redisplay();
    }

    private void redisplay() {
        if (!this.showall.isSelected()) {
            Vector v = this.display.phrases;
            while (v.size() > 0) {
                this.display.removePhrase((Phrase)v.get(0));
            }
            this.display.addPhrase((Phrase)this.tracklist.getSelectedItem());
        } else {
            Vector v = this.display.phrases;
            while (v.size() > 0) {
                this.display.removePhrase((Phrase)v.get(0));
            }
            int i = 0;
            while (i < this.phrases.size()) {
                this.display.addPhrase((Phrase)this.phrases.get(i));
                ++i;
            }
        }
    }

    void showall_actionPerformed(ActionEvent e) {
        this.redisplay();
    }

    void vertscale_adjustmentValueChanged(AdjustmentEvent e) {
        int sc = this.vertscale.getValue();
        this.display.yscale = (float)sc * 0.1f;
        this.display.repaint();
    }

    void horzscale_adjustmentValueChanged(AdjustmentEvent e) {
        int sc = this.horzscale.getValue();
        this.display.xscale = (float)sc * 0.1f;
        this.display.repaint();
    }

    class DummyTrack
    extends Track {
        DummyTrack(Player player) {
            super("Dummy", player);
        }

        public void initialiseTrack() {
            this.trackTranspose = 0;
        }

        public void processLoop() {
        }
    }

    class WaitThread
    extends Thread {
        PlayControl c;
        Player p;
        PlayWindow w;

        WaitThread(PlayControl pc, Player pl, PlayWindow pw) {
            this.c = pc;
            this.p = pl;
            this.w = pw;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block2: while (true) {
                    if (this.c.isRunning()) {
                        this.p.close();
                        this.w.hide();
                        return;
                    }
                    while (true) {
                        if (!this.c.isRunning()) continue block2;
                        Thread.sleep(100L);
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

