/*
 * Decompiled with CFR 0.152.
 */
package improviser.learning;

import improviser.learning.Phrase;
import java.awt.Component;
import java.io.File;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class MidiFileChooser
extends JFileChooser {
    Component parent;
    public boolean allowDrums = false;

    public MidiFileChooser(Component parent) {
        super("e:/midi music/jazz");
        this.parent = parent;
    }

    public Phrase[] fileOpen() {
        int ret = this.showOpenDialog(this.parent);
        if (ret == 0) {
            File f = this.getSelectedFile();
            try {
                MidiFileFormat mff = MidiSystem.getMidiFileFormat(f);
                Sequence mf = MidiSystem.getSequence(f);
                return this.toPhrases(mff, mf);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this.parent, e.toString(), "Could not open " + f.getName(), 0);
            }
        }
        return null;
    }

    private Phrase[] toPhrases(MidiFileFormat mff, Sequence mf) {
        float beatsPerTick = mf.getDivisionType() == 0.0f ? 1.0f / (float)mf.getResolution() : 1.0f / (float)mf.getResolution();
        float minNoteLength = 0.1f;
        Track[] ts = mf.getTracks();
        Phrase[] p = new Phrase[ts.length];
        int i = 0;
        while (i < ts.length) {
            Track t = ts[i];
            Phrase tp = new Phrase();
            long lastGoodEventTick = 0L;
            int lastNoteOn = Integer.MIN_VALUE;
            int lastVelOn = 0;
            int j = 0;
            while (j < t.size()) {
                MidiEvent e = t.get(j);
                long newTick = e.getTick();
                MidiMessage m = e.getMessage();
                int status = m.getStatus() & 0xF0;
                int chan = m.getStatus() & 0xF;
                if (this.allowDrums || chan != 10 && chan != 15) {
                    if (status == 144) {
                        float elapsed = (float)(newTick - lastGoodEventTick) * beatsPerTick;
                        if (lastNoteOn == Integer.MIN_VALUE) {
                            if (elapsed > 0.0f) {
                                tp.appendNote(Integer.MIN_VALUE, elapsed, 0);
                            }
                        } else if (elapsed > minNoteLength) {
                            tp.appendNote(lastNoteOn, elapsed, lastVelOn);
                        }
                        lastNoteOn = m.getMessage()[1];
                        lastVelOn = m.getMessage()[2];
                        lastGoodEventTick = newTick;
                    } else if (lastNoteOn != Integer.MIN_VALUE && status == 128 && m.getMessage()[1] == lastNoteOn) {
                        float duration = (float)(newTick - lastGoodEventTick) * beatsPerTick;
                        tp.appendNote(lastNoteOn, duration, lastVelOn);
                        lastGoodEventTick = newTick;
                        lastNoteOn = Integer.MIN_VALUE;
                    }
                }
                ++j;
            }
            p[i] = tp;
            if (p[i].isEmpty()) {
                p[i] = null;
            }
            ++i;
        }
        return p;
    }

    public Phrase bestPhrase(Phrase[] p) {
        float bestscore = 0.0f;
        Phrase bestphrase = null;
        int i = 0;
        while (i < p.length) {
            float s = this.score(p[i]);
            if (s > bestscore) {
                bestscore = s;
                bestphrase = p[i];
            }
            ++i;
        }
        return bestphrase;
    }

    private float score(Phrase p) {
        int lastbreak = 0;
        int nbreaks = 0;
        float Sbreakdur = 0.0f;
        float Sinbreakdur = 0.0f;
        int notesThisPhrase = 0;
        int cumNotes = 0;
        int i = 0;
        while (i < p.notes.length) {
            if (p.notes[i] == Integer.MIN_VALUE && (double)p.durations[i] > 0.5) {
                Sbreakdur += p.durations[i];
                lastbreak = i;
                ++nbreaks;
                cumNotes += notesThisPhrase;
            } else {
                Sinbreakdur += p.durations[i];
                ++notesThisPhrase;
            }
            ++i;
        }
        float s = Math.abs(10.0f - (float)cumNotes / (float)nbreaks);
        float nl = Math.abs(0.7f - Sinbreakdur / (float)cumNotes);
        return -s - 10.0f * nl;
    }
}

