/*
 * Decompiled with CFR 0.152.
 */
package improviser.learning;

import improviser.Chord;
import improviser.learning.Harmony;
import improviser.learning.Phrase;
import java.io.Serializable;
import sanjay.ContextMemoryBank;

public class JazzMemory
extends ContextMemoryBank
implements Serializable {
    public void createMemory(Phrase phrase, Phrase previous, Phrase next, Harmony harmony, String artist, String song, String style, int tempo, int register, float tension) {
        JazzContent p = new JazzContent();
        p.phrase = phrase;
        JazzContext c = new JazzContext();
        c.previous = previous;
        c.next = next;
        c.harmony = harmony;
        c.artist = artist;
        c.song = song;
        c.style = style;
        c.tempo = tempo;
        c.register = register;
        c.tension = tension;
        super.createMemory(p, c);
    }

    public static class JazzContent
    implements ContextMemoryBank.Content {
        Phrase phrase;
    }

    public static class JazzContext
    implements ContextMemoryBank.Context {
        Phrase previous;
        Phrase next;
        Harmony harmony;
        String artist;
        String song;
        String style;
        int tempo;
        int register;
        float tension;

        public double distanceFromTarget(ContextMemoryBank.Context c) {
            if (!(c instanceof JazzContext)) {
                return Double.MAX_VALUE;
            }
            JazzContext jc = (JazzContext)c;
            double score = 0.0;
            int i = 0;
            while (i < jc.harmony.chords.size()) {
                Chord a = jc.harmony.chord(i);
                float time = jc.harmony.timeTillStartOfChord(i);
                int myIndex = this.harmony.indexAtTime(time);
                Chord b = this.harmony.chord(myIndex);
                if (a.keyNote != b.keyNote) {
                    score -= 500.0;
                }
                score -= (double)(Math.abs(a.typeIndex - b.typeIndex) * 100);
                score -= (double)Math.abs(i - myIndex) * 0.1;
                ++i;
            }
            int lastNote = this.previous.notes[this.previous.notes.length - 1];
            score -= (double)lastNote;
            int i2 = 0;
            while (i2 < this.previous.notes.length) {
                ++i2;
            }
            return score += 0.001 * Math.random();
        }
    }
}

