/*
 * Decompiled with CFR 0.152.
 */
package improviser.learning;

import improviser.Chord;
import java.util.Arrays;
import java.util.Vector;

public class Harmony {
    Vector chords = new Vector();
    float[] durations = new float[0];

    public int indexAtTime(float time) {
        int i = -1;
        while (i + 1 < this.durations.length && time >= this.durations[i + 1]) {
            time -= this.durations[++i];
        }
        if (i >= this.durations.length) {
            return -1;
        }
        return i;
    }

    public Chord chord(int index) {
        return (Chord)this.chords.get(index);
    }

    protected float timeTillStartOfChord(int index) {
        float f = 0.0f;
        int i = 0;
        while (i < index) {
            f += this.durations[i];
            ++i;
        }
        return f;
    }

    public Harmony during(float time, float duration) {
        int si = this.indexAtTime(time);
        float st = this.timeTillStartOfChord(si);
        float firstd = st + this.durations[si] - time;
        int ei = this.indexAtTime(time + duration);
        float et = this.timeTillStartOfChord(ei);
        float lastd = time + duration - et;
        int ln = Math.max(ei - si, 1);
        Chord[] ch = new Chord[ln];
        float[] d = new float[ln];
        int i = si;
        while (i <= ei) {
            ch[i - si] = this.chord(i);
            if (i == si && i == ei) {
                d[0] = duration;
            } else if (i == si) {
                d[0] = firstd;
            } else if (i == ei) {
                d[ei - si] = lastd;
            } else {
                d[i - si] = this.durations[i];
            }
            ++i;
        }
        Harmony h = new Harmony();
        Vector<Chord> v = new Vector<Chord>();
        v.addAll(Arrays.asList(ch));
        h.chords = v;
        h.durations = d;
        return h;
    }
}

