/*
 * Decompiled with CFR 0.152.
 */
package improviser.gui;

import improviser.Chord;
import improviser.SongData;
import improviser.gui.SongDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SongEditorPane
extends JPanel
implements MouseWheelListener {
    public SongDisplay songDisplay = new SongDisplay();
    BorderLayout borderLayout1 = new BorderLayout();
    public JPanel panel1 = new JPanel();
    public JPanel panel2 = new JPanel();
    public JScrollBar vscroll = new JScrollBar();
    public BorderLayout borderLayout2 = new BorderLayout();
    public JScrollBar hscroll = new JScrollBar();
    public JButton button1 = new JButton();
    public JTextField textField = new JTextField();
    SongData song;
    JScrollBar lenscroll = new JScrollBar();
    JLabel lenlabel = new JLabel();
    JButton jButton1 = new JButton();
    JSlider tempoSlider = new JSlider();
    JLabel jLabel1 = new JLabel();
    JLabel tempoText = new JLabel();

    public SongEditorPane() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addMouseWheelListener(this);
    }

    public void setSong(SongData s) {
        this.song = s;
        this.songDisplay.setSong(s);
        this.setMaxHScroll();
        this.tempoSlider.setValue(s.tempo * 100 / 240);
    }

    public SongData getSong() {
        return this.song;
    }

    public int getSelected() {
        return this.songDisplay.getSelected();
    }

    public void setSelected(int index) {
        this.songDisplay.setSelected(index);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.panel2.setLayout(this.borderLayout2);
        this.hscroll.setOrientation(0);
        this.hscroll.setMaximum(4);
        this.hscroll.setBlockIncrement(4);
        this.hscroll.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                SongEditorPane.this.hscrollchange(e);
            }
        });
        this.button1.setToolTipText("Click here to create a chord with the given name");
        this.button1.setActionCommand("Insert");
        this.button1.setText("Insert");
        this.button1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SongEditorPane.this.action(e);
            }
        });
        this.textField.setBackground(SystemColor.window);
        this.textField.setPreferredSize(new Dimension(80, 21));
        this.textField.setToolTipText("Enter chord symbol here");
        this.textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SongEditorPane.this.textField_actionPerformed(e);
            }
        });
        this.vscroll.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                SongEditorPane.this.vscrollchange(e);
            }
        });
        this.songDisplay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SongEditorPane.this.displayEvent(e);
            }
        });
        this.lenscroll.setMaximum(16);
        this.lenscroll.setMinimum(1);
        this.lenscroll.setVisibleAmount(4);
        this.lenscroll.setOrientation(0);
        this.lenscroll.setBlockIncrement(4);
        this.lenscroll.setPreferredSize(new Dimension(55, 16));
        this.lenscroll.setToolTipText("Duration of selected chord, in beats");
        this.lenscroll.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                SongEditorPane.this.lenchange(e);
            }
        });
        this.lenlabel.setPreferredSize(new Dimension(30, 17));
        this.lenlabel.setText("0:1");
        this.vscroll.setMinimum(1);
        this.vscroll.setMaximum(32);
        this.vscroll.setBlockIncrement(8);
        this.jButton1.setToolTipText("Remove the selected chord");
        this.jButton1.setText("Delete");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SongEditorPane.this.action(e);
            }
        });
        this.panel1.setPreferredSize(new Dimension(536, 70));
        this.jLabel1.setText("c=");
        this.tempoSlider.setPreferredSize(new Dimension(80, 24));
        this.tempoSlider.setToolTipText("Playback tempo");
        this.tempoSlider.setBorder(BorderFactory.createRaisedBevelBorder());
        this.tempoSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SongEditorPane.this.tempochange(e);
            }
        });
        this.tempoText.setText("120");
        this.add((Component)this.songDisplay, "Center");
        this.add((Component)this.panel1, "South");
        this.panel1.add((Component)this.textField, null);
        this.panel1.add((Component)this.button1, null);
        this.panel1.add((Component)this.jButton1, null);
        this.panel1.add((Component)this.lenscroll, null);
        this.panel1.add((Component)this.lenlabel, null);
        this.panel1.add((Component)this.tempoSlider, null);
        this.panel1.add((Component)this.jLabel1, null);
        this.panel1.add((Component)this.tempoText, null);
        this.add((Component)this.panel2, "West");
        this.panel2.add((Component)this.vscroll, "Center");
        this.add((Component)this.hscroll, "North");
    }

    void vscrollchange(AdjustmentEvent e) {
        this.songDisplay.setZoom(this.vscroll.getValue() * 4);
    }

    void hscrollchange(AdjustmentEvent e) {
        this.songDisplay.setPos(this.hscroll.getValue());
    }

    void displayEvent(ActionEvent e) {
        int i;
        this.setMaxHScroll();
        String s = e.getActionCommand();
        if (s.equals("Selected") && (i = this.songDisplay.getSelected()) >= 0) {
            this.textField.setText(this.song.getChord(i).getSymbol());
            this.setscrolltime(this.song.timeOfChord(i));
        }
    }

    void setMaxHScroll() {
        int[] m = this.song.length();
        int ml = m[0];
        if (m[1] > 0) {
            ++ml;
        }
        this.hscroll.setMaximum(ml);
    }

    void textField_actionPerformed(ActionEvent e) {
        Chord c;
        if (this.songDisplay.getSelected() >= 0) {
            Chord c2 = this.parseBox();
            if (c2 != null) {
                this.song.setChord(this.songDisplay.selected, c2);
            }
        } else if (this.songDisplay.getSelected() == -1 && (c = this.parseBox()) != null) {
            this.song.insertChord(this.song.size(), c, this.getscrolltime());
        }
        this.setMaxHScroll();
        this.songDisplay.repaint();
    }

    public Chord parseBox() {
        String s = this.textField.getText();
        try {
            Chord c = new Chord(s);
            return c;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    void lenchange(AdjustmentEvent e) {
        int[] p = this.getscrolltime();
        if (this.songDisplay.getSelected() >= 0) {
            this.song.setTimeOfChord(this.songDisplay.getSelected(), p);
        }
        this.lenlabel.setText(String.valueOf(String.valueOf(p[0])) + ":" + String.valueOf(p[1]));
    }

    int[] getscrolltime() {
        int p = this.lenscroll.getValue();
        return new int[]{p / this.song.beatsPerBar, p % this.song.beatsPerBar};
    }

    void setscrolltime(int[] q) {
        int p = q[0] * this.song.beatsPerBar + q[1];
        this.lenscroll.setValue(p);
    }

    void action(ActionEvent e) {
        String com = e.getActionCommand();
        if (com.equals("Insert")) {
            Chord c = this.parseBox();
            this.insertChord(c);
        } else if (com.equals("Delete")) {
            int s = this.songDisplay.getSelected();
            if (s >= 0) {
                this.song.removeChord(s);
            }
            if (s >= this.song.size()) {
                this.songDisplay.setSelected(-1);
            }
        }
    }

    public void insertChord(Chord c) {
        int s = this.songDisplay.getSelected();
        if (c != null) {
            if (s >= 0) {
                this.song.insertChord(s, c, this.getscrolltime());
            } else {
                this.song.insertChord(this.song.size(), c, this.getscrolltime());
            }
        }
        this.setMaxHScroll();
        this.songDisplay.repaint();
    }

    void tempochange(ChangeEvent e) {
        int a = this.tempoSlider.getValue();
        this.song.tempo = 240 * a / 100;
        this.tempoText.setText(String.valueOf(this.song.tempo));
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int i = e.getUnitsToScroll();
        this.hscroll.setValue(this.hscroll.getValue() + i);
    }
}

